/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.gpx;

import java.time.temporal.Temporal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.FeatureOperations;
import org.apache.sis.feature.builder.AttributeRole;
import org.apache.sis.feature.builder.AttributeTypeBuilder;
import org.apache.sis.feature.builder.FeatureTypeBuilder;
import org.apache.sis.internal.feature.AttributeConvention;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.storage.FeatureCatalogBuilder;
import org.apache.sis.internal.storage.gpx.GroupAsPolylineOperation;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.storage.FeatureNaming;
import org.apache.sis.storage.IllegalNameException;
import org.apache.sis.storage.gps.Fix;
import org.apache.sis.util.iso.DefaultNameFactory;
import org.opengis.metadata.acquisition.GeometryType;
import org.opengis.metadata.citation.OnlineResource;
import org.opengis.metadata.content.ContentInformation;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.FactoryException;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.NameFactory;
import org.opengis.util.ScopedName;

final class Types {
    final DefaultFeatureType parent;
    final DefaultFeatureType wayPoint;
    final DefaultFeatureType route;
    final DefaultFeatureType track;
    final DefaultFeatureType trackSegment;
    final Collection<ContentInformation> metadata;
    @Deprecated
    final FeatureNaming<DefaultFeatureType> names;
    final Geometries<?> geometries;
    static final Types DEFAULT;

    Types(NameFactory nameFactory, Locale locale, GeometryLibrary geometryLibrary) throws FactoryException, IllegalNameException {
        this.geometries = Geometries.implementation(geometryLibrary);
        HashMap<String, InternationalString[]> hashMap = new HashMap<String, InternationalString[]>();
        ScopedName scopedName = AttributeConvention.GEOMETRY_PROPERTY;
        Map<String, ScopedName> map = Collections.singletonMap("name", scopedName);
        Map<String, ScopedName> map2 = Collections.singletonMap("name", AttributeConvention.ENVELOPE_PROPERTY);
        FeatureTypeBuilder featureTypeBuilder = new FeatureTypeBuilder(nameFactory, geometryLibrary, locale);
        featureTypeBuilder.setNameSpace("gpx").setName((CharSequence)"GPXEntity").setAbstract(true);
        featureTypeBuilder.addAttribute(Integer.class).setName((GenericName)AttributeConvention.IDENTIFIER_PROPERTY);
        this.parent = featureTypeBuilder.build();
        featureTypeBuilder.clear().setSuperTypes(this.parent).setNameSpace("gpx").setName((CharSequence)"WayPoint");
        ((AttributeTypeBuilder)featureTypeBuilder.addAttribute(GeometryType.POINT).setName((GenericName)scopedName)).setCRS((CoordinateReferenceSystem)CommonCRS.WGS84.normalizedGeographic()).addRole(AttributeRole.DEFAULT_GEOMETRY);
        featureTypeBuilder.setDefaultMultiplicity(0, 1);
        featureTypeBuilder.addAttribute(Double.class).setName((CharSequence)"ele");
        featureTypeBuilder.addAttribute(Temporal.class).setName((CharSequence)"time");
        featureTypeBuilder.addAttribute(Double.class).setName((CharSequence)"magvar");
        featureTypeBuilder.addAttribute(Double.class).setName((CharSequence)"geoidheight");
        featureTypeBuilder.addAttribute(String.class).setName((CharSequence)"name");
        featureTypeBuilder.addAttribute(String.class).setName((CharSequence)"cmt");
        featureTypeBuilder.addAttribute(String.class).setName((CharSequence)"desc");
        featureTypeBuilder.addAttribute(String.class).setName((CharSequence)"src");
        ((AttributeTypeBuilder)featureTypeBuilder.addAttribute(OnlineResource.class).setName((CharSequence)"link")).setMaximumOccurs(Integer.MAX_VALUE);
        featureTypeBuilder.addAttribute(String.class).setName((CharSequence)"sym");
        featureTypeBuilder.addAttribute(String.class).setName((CharSequence)"type");
        featureTypeBuilder.addAttribute(Fix.class).setName((CharSequence)"fix");
        featureTypeBuilder.addAttribute(Integer.class).setName((CharSequence)"sat");
        featureTypeBuilder.addAttribute(Double.class).setName((CharSequence)"hdop");
        featureTypeBuilder.addAttribute(Double.class).setName((CharSequence)"vdop");
        featureTypeBuilder.addAttribute(Double.class).setName((CharSequence)"pdop");
        featureTypeBuilder.addAttribute(Double.class).setName((CharSequence)"ageofdgpsdata");
        featureTypeBuilder.addAttribute(Integer.class).setName((CharSequence)"dgpsid");
        this.wayPoint = Types.create(featureTypeBuilder, hashMap);
        DefaultAttributeType<?> defaultAttributeType = GroupAsPolylineOperation.getResult(this.geometries);
        GroupAsPolylineOperation groupAsPolylineOperation = new GroupAsPolylineOperation(map, "rtept", defaultAttributeType);
        featureTypeBuilder.clear().setSuperTypes(this.parent).setNameSpace("gpx").setName((CharSequence)"Route");
        featureTypeBuilder.addProperty(groupAsPolylineOperation);
        featureTypeBuilder.addProperty(FeatureOperations.envelope(map2, null, groupAsPolylineOperation));
        featureTypeBuilder.setDefaultMultiplicity(0, 1);
        featureTypeBuilder.addProperty(this.wayPoint.getProperty("name"));
        featureTypeBuilder.addProperty(this.wayPoint.getProperty("cmt"));
        featureTypeBuilder.addProperty(this.wayPoint.getProperty("desc"));
        featureTypeBuilder.addProperty(this.wayPoint.getProperty("src"));
        featureTypeBuilder.addProperty(this.wayPoint.getProperty("link"));
        featureTypeBuilder.addAttribute(Integer.class).setName((CharSequence)"number");
        featureTypeBuilder.addProperty(this.wayPoint.getProperty("type"));
        featureTypeBuilder.addAssociation(this.wayPoint).setName((CharSequence)"rtept").setMaximumOccurs(Integer.MAX_VALUE);
        this.route = Types.create(featureTypeBuilder, hashMap);
        groupAsPolylineOperation = new GroupAsPolylineOperation(map, "trkpt", defaultAttributeType);
        featureTypeBuilder.clear().setSuperTypes(this.parent).setNameSpace("gpx").setName((CharSequence)"TrackSegment");
        featureTypeBuilder.addProperty(groupAsPolylineOperation);
        featureTypeBuilder.addProperty(FeatureOperations.envelope(map2, null, groupAsPolylineOperation));
        featureTypeBuilder.setDefaultMultiplicity(0, 1);
        featureTypeBuilder.addAssociation(this.wayPoint).setName((CharSequence)"trkpt").setMaximumOccurs(Integer.MAX_VALUE);
        this.trackSegment = Types.create(featureTypeBuilder, hashMap);
        groupAsPolylineOperation = new GroupAsPolylineOperation(map, "trkseg", defaultAttributeType);
        featureTypeBuilder.clear().setSuperTypes(this.parent).setNameSpace("gpx").setName((CharSequence)"Track");
        featureTypeBuilder.addProperty(groupAsPolylineOperation);
        featureTypeBuilder.addProperty(FeatureOperations.envelope(map2, null, groupAsPolylineOperation));
        featureTypeBuilder.setDefaultMultiplicity(0, 1);
        featureTypeBuilder.addProperty(this.route.getProperty("name"));
        featureTypeBuilder.addProperty(this.route.getProperty("cmt"));
        featureTypeBuilder.addProperty(this.route.getProperty("desc"));
        featureTypeBuilder.addProperty(this.route.getProperty("src"));
        featureTypeBuilder.addProperty(this.route.getProperty("link"));
        featureTypeBuilder.addProperty(this.route.getProperty("number"));
        featureTypeBuilder.addProperty(this.route.getProperty("type"));
        featureTypeBuilder.addAssociation(this.trackSegment).setName((CharSequence)"trkseg").setMaximumOccurs(Integer.MAX_VALUE);
        this.track = Types.create(featureTypeBuilder, hashMap);
        FeatureCatalogBuilder featureCatalogBuilder = new FeatureCatalogBuilder(null);
        featureCatalogBuilder.define(this.route);
        featureCatalogBuilder.define(this.track);
        featureCatalogBuilder.define(this.wayPoint);
        this.metadata = featureCatalogBuilder.build(true).getContentInfo();
        this.names = featureCatalogBuilder.features;
    }

    /*
     * Exception decompiling
     */
    private static DefaultFeatureType create(FeatureTypeBuilder var0, Map<String, InternationalString[]> var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static {
        try {
            DEFAULT = new Types((NameFactory)DefaultFactories.forBuildin(NameFactory.class, DefaultNameFactory.class), null, null);
        }
        catch (IllegalNameException | FactoryException throwable) {
            throw new AssertionError((Object)throwable);
        }
    }
}

