/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.logging;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.Localized;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.logging.QuietLogRecord;
import org.apache.sis.util.logging.WarningListener;
import org.apache.sis.util.resources.Errors;

@Deprecated
public class WarningListeners<S>
implements Localized {
    private final S source;
    private WarningListener<? super S>[] listeners;

    public WarningListeners(S source) {
        this.source = source;
    }

    public WarningListeners(S source, WarningListeners<? super S> other) {
        this(source);
        if (other != null) {
            this.listeners = other.listeners;
        }
    }

    public S getSource() {
        return this.source;
    }

    @Override
    public Locale getLocale() {
        return this.source instanceof Localized ? ((Localized)this.source).getLocale() : null;
    }

    public Logger getLogger() {
        return Logging.getLogger(this.source.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warning(LogRecord record) {
        WarningListener<? super S>[] warningListenerArray = this;
        synchronized (this) {
            WarningListener<? super S>[] current = this.listeners;
            // ** MonitorExit[warningListenerArray] (shouldn't be in output)
            if (current != null) {
                for (WarningListener<S> warningListener : current) {
                    warningListener.warningOccured(this.source, record);
                }
            } else {
                Logger logger;
                String name = record.getLoggerName();
                if (name != null) {
                    logger = Logging.getLogger(name);
                } else {
                    logger = this.getLogger();
                    record.setLoggerName(logger.getName());
                }
                if (record instanceof QuietLogRecord) {
                    ((QuietLogRecord)record).clearThrown();
                }
                logger.log(record);
            }
            return;
        }
    }

    public void warning(String message, Exception exception) {
        this.warning(Level.WARNING, message, exception);
    }

    public void warning(Level level, String message, Exception exception) {
        LogRecord record;
        StackTraceElement[] trace;
        ArgumentChecks.ensureNonNull("level", level);
        if (exception != null) {
            trace = exception.getStackTrace();
            message = Exceptions.formatChainedMessages(this.getLocale(), message, exception);
            if (message == null) {
                message = exception.toString();
            }
            record = new QuietLogRecord(level, message, exception);
        } else {
            ArgumentChecks.ensureNonEmpty("message", message);
            trace = Thread.currentThread().getStackTrace();
            record = new LogRecord(level, message);
        }
        for (StackTraceElement e : trace) {
            if (!WarningListeners.isPublic(e)) continue;
            record.setSourceClassName(e.getClassName());
            record.setSourceMethodName(e.getMethodName());
            break;
        }
        this.warning(record);
    }

    static boolean isPublic(StackTraceElement e) {
        String classname = e.getClassName();
        if (classname.startsWith("java") || classname.startsWith("org.apache.sis.internal.") || classname.indexOf(36) >= 0 || e.getMethodName().indexOf(36) >= 0) {
            return false;
        }
        if (classname.startsWith("org.apache.sis.util.logging.")) {
            return classname.endsWith("Test");
        }
        return true;
    }

    public synchronized void addWarningListener(WarningListener<? super S> listener) throws IllegalArgumentException {
        ArgumentChecks.ensureNonNull("listener", listener);
        WarningListener<? super S>[] current = this.listeners;
        int length = current != null ? current.length : 0;
        WarningListener[] copy = new WarningListener[length + 1];
        for (int i = 0; i < length; ++i) {
            WarningListener<? super S> c = current[i];
            if (c == listener) {
                throw new IllegalArgumentException(Errors.format((short)27, listener));
            }
            copy[i] = c;
        }
        copy[length] = listener;
        this.listeners = copy;
    }

    public synchronized void removeWarningListener(WarningListener<? super S> listener) throws NoSuchElementException {
        ArgumentChecks.ensureNonNull("listener", listener);
        WarningListener<? super S>[] current = this.listeners;
        if (current != null) {
            for (int i = 0; i < current.length; ++i) {
                if (current[i] != listener) continue;
                if (current.length == 1) {
                    this.listeners = null;
                } else {
                    WarningListener[] copy = new WarningListener[current.length - 1];
                    System.arraycopy(current, 0, copy, 0, i);
                    System.arraycopy(current, i + 1, copy, i, copy.length - i);
                    this.listeners = copy;
                }
                return;
            }
        }
        throw new NoSuchElementException(Errors.format((short)28, listener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WarningListener<? super S>> getListeners() {
        WarningListener<? super S>[] current;
        WarningListeners warningListeners = this;
        synchronized (warningListeners) {
            current = this.listeners;
        }
        return current != null ? UnmodifiableArrayList.wrap(current) : Collections.emptyList();
    }

    public synchronized boolean hasListeners() {
        return this.listeners != null;
    }
}

