/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.logging;

import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.Static;
import org.apache.sis.util.logging.DualLoggerFactory;
import org.apache.sis.util.logging.LoggerFactory;
import org.apache.sis.util.logging.WarningListeners;

public final class Logging
extends Static {
    private static final int LEVEL_THRESHOLD_FOR_STACKTRACE = 600;
    private static volatile LoggerFactory<?> factory;

    private Logging() {
    }

    public static void setLoggerFactory(LoggerFactory<?> factory) {
        Logging.factory = factory;
    }

    public static LoggerFactory<?> getLoggerFactory() {
        return factory;
    }

    public static Logger getLogger(String name) {
        Logger logger;
        ArgumentChecks.ensureNonNull("name", name);
        LoggerFactory<?> factory = Logging.factory;
        if (factory != null && (logger = factory.getLogger(name)) != null) {
            return logger;
        }
        return Logger.getLogger(name);
    }

    public static Logger getLogger(Class<?> source) {
        Class<?> outer;
        ArgumentChecks.ensureNonNull("source", source);
        while ((outer = source.getEnclosingClass()) != null) {
            source = outer;
        }
        String name = source.getName();
        int separator = name.lastIndexOf(46);
        String string = name = separator >= 1 ? name.substring(0, separator) : "";
        if (name.startsWith("org.apache.sis.internal.")) {
            name = "org.apache.sis." + name.substring("org.apache.sis.internal.".length());
        }
        return Logging.getLogger(name);
    }

    public static void log(Class<?> classe, String method, LogRecord record) {
        Logger logger;
        ArgumentChecks.ensureNonNull("record", record);
        String loggerName = record.getLoggerName();
        if (loggerName == null) {
            logger = Logging.getLogger(classe);
            record.setLoggerName(logger.getName());
        } else {
            logger = Logging.getLogger(loggerName);
        }
        if (classe != null && method != null) {
            record.setSourceClassName(classe.getCanonicalName());
            record.setSourceMethodName(method);
        } else {
            logger = Logging.inferCaller(logger, classe != null ? classe.getCanonicalName() : null, method, Thread.currentThread().getStackTrace(), record);
        }
        logger.log(record);
    }

    private static Logger inferCaller(Logger logger, String classe, String method, StackTraceElement[] trace, LogRecord record) {
        for (StackTraceElement element : trace) {
            String classname = element.getClassName();
            if (classe != null ? !classname.equals(classe) : !WarningListeners.isPublic(element)) continue;
            String methodName = element.getMethodName();
            if (method != null && !methodName.equals(method)) continue;
            if (logger == null) {
                int separator = classname.lastIndexOf(46);
                logger = Logging.getLogger(separator >= 1 ? classname.substring(0, separator - 1) : "");
            }
            if (classe == null) {
                classe = classname;
            }
            if (method != null) break;
            method = methodName;
            break;
        }
        if (logger == null) {
            logger = Logging.getLogger("global");
        }
        if (classe != null) {
            record.setSourceClassName(classe);
        }
        if (method != null) {
            record.setSourceMethodName(method);
        }
        return logger;
    }

    public static boolean unexpectedException(Logger logger, Class<?> classe, String method, Throwable error) {
        String classname = classe != null ? classe.getName() : null;
        return Logging.unexpectedException(logger, classname, method, error, Level.WARNING);
    }

    private static boolean unexpectedException(Logger logger, String classe, String method, Throwable error, Level level) {
        if (error == null) {
            return false;
        }
        if (logger == null && classe != null) {
            int separator = classe.lastIndexOf(46);
            String paquet = separator >= 1 ? classe.substring(0, separator - 1) : "";
            logger = Logging.getLogger(paquet);
        }
        if (logger != null && !logger.isLoggable(level)) {
            return false;
        }
        StringBuilder buffer = new StringBuilder(256).append(Classes.getShortClassName(error));
        String message = error.getMessage();
        if (message != null) {
            buffer.append(": ").append(message);
        }
        message = buffer.toString();
        message = Exceptions.formatChainedMessages(null, message, error);
        LogRecord record = new LogRecord(level, message);
        if (level.intValue() >= 600) {
            record.setThrown(error);
        }
        if (logger == null || classe == null || method == null) {
            logger = Logging.inferCaller(logger, classe, method, error.getStackTrace(), record);
        } else {
            record.setSourceClassName(classe);
            record.setSourceMethodName(method);
        }
        record.setLoggerName(logger.getName());
        logger.log(record);
        return true;
    }

    static boolean configurationException(Logger logger, Class<?> classe, String method, Throwable error) {
        String classname = classe != null ? classe.getName() : null;
        return Logging.unexpectedException(logger, classname, method, error, Level.CONFIG);
    }

    public static boolean recoverableException(Logger logger, Class<?> classe, String method, Throwable error) {
        String classname = classe != null ? classe.getName() : null;
        return Logging.unexpectedException(logger, classname, method, error, Level.FINE);
    }

    public static boolean ignorableException(Logger logger, Class<?> classe, String method, Throwable error) {
        String classname = classe != null ? classe.getName() : null;
        return Logging.unexpectedException(logger, classname, method, error, Level.FINER);
    }

    public static boolean severeException(Logger logger, Class<?> classe, String method, Throwable error) {
        String classname = classe != null ? classe.getName() : null;
        return Logging.unexpectedException(logger, classname, method, error, Level.SEVERE);
    }

    static {
        LoggerFactory factory = null;
        for (LoggerFactory found : ServiceLoader.load(LoggerFactory.class)) {
            if (factory == null) {
                factory = found;
                continue;
            }
            factory = new DualLoggerFactory(factory, found);
        }
        Logging.factory = factory;
    }
}

