/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.logging;

import java.util.logging.Logger;
import org.apache.sis.util.logging.DualLogger;
import org.apache.sis.util.logging.LoggerFactory;

final class DualLoggerFactory
extends LoggerFactory<DualLogger> {
    private final LoggerFactory<?> first;
    private final LoggerFactory<?> second;

    DualLoggerFactory(LoggerFactory<?> first, LoggerFactory<?> second) {
        super(DualLogger.class);
        this.first = first;
        this.second = second;
    }

    @Override
    public String getName() {
        return this.first.getName() + ", " + this.second.getName();
    }

    @Override
    protected DualLogger getImplementation(String name) {
        return new DualLogger(name, this.first.getLogger(name), this.second.getLogger(name));
    }

    @Override
    protected Logger wrap(String name, DualLogger implementation) {
        return implementation;
    }

    @Override
    protected DualLogger unwrap(Logger logger) {
        if (logger instanceof DualLogger) {
            return (DualLogger)logger;
        }
        return null;
    }
}

