/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.iso;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import org.apache.sis.internal.converter.SurjectiveConverter;
import org.apache.sis.internal.metadata.RecordSchemaSIS;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.ObjectConverters;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.iso.DefaultNameFactory;
import org.apache.sis.util.iso.Names;
import org.apache.sis.util.iso.RecordDefinition;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.GenericName;
import org.opengis.util.LocalName;
import org.opengis.util.MemberName;
import org.opengis.util.NameSpace;
import org.opengis.util.Record;
import org.opengis.util.RecordSchema;
import org.opengis.util.RecordType;
import org.opengis.util.Type;
import org.opengis.util.TypeName;

@XmlType(name="RecordType")
public class DefaultRecordType
extends RecordDefinition
implements RecordType,
Serializable {
    private static final long serialVersionUID = -1534515712654429099L;
    private final TypeName typeName;
    private final RecordSchema container;
    private transient Type[] memberTypes;

    public DefaultRecordType(RecordType other) {
        this.typeName = other.getTypeName();
        this.container = other.getContainer();
        this.memberTypes = this.computeTransientFields(other.getMemberTypes());
    }

    public DefaultRecordType(TypeName typeName, RecordSchema container, Map<? extends MemberName, ? extends Type> members) {
        ArgumentChecks.ensureNonNull("typeName", typeName);
        ArgumentChecks.ensureNonNull("container", container);
        ArgumentChecks.ensureNonNull("members", members);
        this.typeName = typeName;
        this.container = container;
        this.memberTypes = this.computeTransientFields(members);
        LocalName schemaName = container.getSchemaName();
        GenericName fullTypeName = typeName.toFullyQualifiedName();
        if (schemaName.compareTo((Object)typeName.scope().name().tip()) != 0) {
            throw new IllegalArgumentException(Errors.format((short)68, schemaName, fullTypeName));
        }
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            MemberName name = this.getName(i);
            Type type = this.memberTypes[i];
            if (type == null || name.getAttributeType().compareTo((Object)type.getTypeName()) != 0) {
                throw new IllegalArgumentException(Errors.format((short)55, name, type));
            }
            if (fullTypeName.compareTo((Object)name.scope().name()) == 0) continue;
            throw new IllegalArgumentException(Errors.format((short)68, fullTypeName, name.toFullyQualifiedName()));
        }
    }

    DefaultRecordType(TypeName typeName, RecordSchema container, Map<? extends CharSequence, ? extends Type> members, DefaultNameFactory nameFactory) {
        this.typeName = typeName;
        this.container = container;
        NameSpace namespace = nameFactory.createNameSpace((GenericName)typeName, null);
        LinkedHashMap<MemberName, Type> memberTypes = new LinkedHashMap<MemberName, Type>(Containers.hashMapCapacity(members.size()));
        for (Map.Entry<? extends CharSequence, ? extends Type> entry : members.entrySet()) {
            Type type = entry.getValue();
            CharSequence name = entry.getKey();
            MemberName member = nameFactory.createMemberName(namespace, name, type.getTypeName());
            if (memberTypes.put(member, type) == null) continue;
            throw new IllegalArgumentException(Errors.format((short)24, member));
        }
        this.memberTypes = this.computeTransientFields(memberTypes);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int size = in.readInt();
        LinkedHashMap<MemberName, Type> members = new LinkedHashMap<MemberName, Type>(Containers.hashMapCapacity(size));
        for (int i = 0; i < size; ++i) {
            Type type;
            MemberName member = (MemberName)in.readObject();
            if (members.put(member, type = (Type)in.readObject()) == null) continue;
            throw new InvalidObjectException(Errors.format((short)24, member));
        }
        this.memberTypes = this.computeTransientFields(members);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        int size = this.size();
        out.defaultWriteObject();
        out.writeInt(size);
        for (int i = 0; i < size; ++i) {
            out.writeObject(this.getName(i));
            out.writeObject(this.memberTypes[i]);
        }
    }

    public static DefaultRecordType castOrCopy(RecordType other) {
        if (other == null || other instanceof DefaultRecordType) {
            return (DefaultRecordType)other;
        }
        return new DefaultRecordType(other);
    }

    @Override
    final RecordType getRecordType() {
        return this;
    }

    public TypeName getTypeName() {
        return this.typeName;
    }

    public RecordSchema getContainer() {
        return this.container;
    }

    public Map<MemberName, Type> getMemberTypes() {
        return ObjectConverters.derivedValues(this.memberIndices(), MemberName.class, new SurjectiveConverter<Integer, Type>(){

            @Override
            public Class<Integer> getSourceClass() {
                return Integer.class;
            }

            @Override
            public Class<Type> getTargetClass() {
                return Type.class;
            }

            @Override
            public Type apply(Integer index) {
                return DefaultRecordType.this.getType(index);
            }
        });
    }

    public Set<MemberName> getMembers() {
        return this.memberIndices().keySet();
    }

    final Type getType(int index) {
        return this.memberTypes[index];
    }

    public TypeName locate(MemberName memberName) {
        Integer index = this.indexOf(memberName);
        return index != null ? this.getType(index).getTypeName() : null;
    }

    public boolean isInstance(Record record) {
        return record != null && this.getMembers().containsAll(record.getAttributes().keySet());
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other != null && other.getClass() == this.getClass()) {
            DefaultRecordType that = (DefaultRecordType)other;
            return Objects.equals(this.typeName, that.typeName) && Objects.equals(this.container, that.container) && Arrays.equals(this.memberTypes, that.memberTypes) && this.memberIndices().equals(that.memberIndices());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.typeName) + 31 * (this.memberIndices().hashCode() + 31 * Arrays.hashCode(this.memberTypes));
    }

    private DefaultRecordType() {
        DefaultRecordType type = RecordSchemaSIS.STRING;
        this.typeName = type.typeName;
        this.container = type.container;
    }

    @XmlValue
    private String getValue() {
        switch (this.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return String.valueOf(this.memberTypes[0]);
            }
        }
        return this.toString(null, null);
    }

    private void setValue(String value) {
        if (value != null) {
            LinkedHashMap<MemberName, Type> members = new LinkedHashMap<MemberName, Type>();
            for (CharSequence element : CharSequences.splitOnEOL(value)) {
                int s = ((String)element).indexOf(58);
                if (s >= 0) {
                    element = element.subSequence(0, CharSequences.skipTrailingWhitespaces(element, 0, s));
                }
                MemberName m = Names.createMemberName(null, null, element, String.class);
                members.put(m, RecordSchemaSIS.INSTANCE.toAttributeType(String.class));
            }
            this.memberTypes = this.computeTransientFields(members);
        }
    }
}

