/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.LenientComparable;
import org.apache.sis.util.Static;
import org.apache.sis.util.collection.CheckedContainer;

public final class Utilities
extends Static {
    private Utilities() {
    }

    public static boolean equalsIgnoreMetadata(Object object1, Object object2) {
        return Utilities.deepEquals(object1, object2, ComparisonMode.IGNORE_METADATA);
    }

    public static boolean equalsApproximately(Object object1, Object object2) {
        return Utilities.deepEquals(object1, object2, ComparisonMode.APPROXIMATE);
    }

    @Deprecated
    public static boolean equalsApproximatively(Object object1, Object object2) {
        return Utilities.equalsApproximately(object1, object2);
    }

    public static boolean deepEquals(Object object1, Object object2, ComparisonMode mode) {
        if (object1 == object2) {
            return true;
        }
        if (object1 == null || object2 == null) {
            assert (Utilities.isNotDebug(mode)) : (object1 != null ? object1.getClass() : (object2 != null ? object2.getClass() : Object.class)).getSimpleName() + " #" + (object1 == null ? (char)'1' : '2') + " is null";
            return false;
        }
        if (object1 instanceof LenientComparable) {
            return ((LenientComparable)object1).equals(object2, mode);
        }
        if (object2 instanceof LenientComparable) {
            return ((LenientComparable)object2).equals(object1, mode);
        }
        if (object1 instanceof Map.Entry) {
            if (object2 instanceof Map.Entry) {
                Map.Entry e1 = (Map.Entry)object1;
                Map.Entry e2 = (Map.Entry)object2;
                return Utilities.deepEquals(e1.getKey(), e2.getKey(), mode) && Utilities.deepEquals(e1.getValue(), e2.getValue(), mode);
            }
            assert (Utilities.isNotDebug(mode)) : Utilities.mismatchedType(Map.Entry.class, object2);
            return false;
        }
        if (object1 instanceof Map) {
            if (object2 instanceof Map) {
                return Utilities.equals(((Map)object1).entrySet(), ((Map)object2).entrySet(), mode);
            }
            assert (Utilities.isNotDebug(mode)) : Utilities.mismatchedType(Map.class, object2);
            return false;
        }
        if (object1 instanceof Collection) {
            if (object2 instanceof Collection) {
                return Utilities.equals((Collection)object1, (Collection)object2, mode);
            }
            assert (Utilities.isNotDebug(mode)) : Utilities.mismatchedType(Collection.class, object2);
            return false;
        }
        if (object1 instanceof Object[]) {
            if (!(object2 instanceof Object[])) {
                assert (Utilities.isNotDebug(mode)) : Utilities.mismatchedType(Object[].class, object2);
                return false;
            }
            Object[] array1 = (Object[])object1;
            Object[] array2 = (Object[])object2;
            if (array1 instanceof LenientComparable[]) {
                return Utilities.equals((LenientComparable[])array1, array2, mode);
            }
            if (array2 instanceof LenientComparable[]) {
                return Utilities.equals((LenientComparable[])array2, array1, mode);
            }
            int length = array1.length;
            if (array2.length != length) {
                assert (Utilities.isNotDebug(mode)) : "Length " + length + " != " + array2.length;
                return false;
            }
            for (int i = 0; i < length; ++i) {
                if (Utilities.deepEquals(array1[i], array2[i], mode)) continue;
                assert (Utilities.isNotDebug(mode)) : "object[" + i + "] not equal";
                return false;
            }
            return true;
        }
        return Objects.deepEquals(object1, object2);
    }

    private static boolean equals(LenientComparable[] array1, Object[] array2, ComparisonMode mode) {
        int length = array1.length;
        if (array2.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            LenientComparable e1 = array1[i];
            Object e2 = array2[i];
            if (e1 == e2 || e1 != null && e1.equals(e2, mode)) continue;
            assert (Utilities.isNotDebug(mode)) : "object[" + i + "] not equal";
            return false;
        }
        return true;
    }

    private static boolean equals(Iterable<?> object1, Iterable<?> object2, ComparisonMode mode) {
        Iterator<?> it1 = object1.iterator();
        Iterator<?> it2 = object2.iterator();
        while (it1.hasNext()) {
            Object element2;
            if (!it2.hasNext()) {
                assert (Utilities.isNotDebug(mode)) : Utilities.mismatchedElement("Iterable", object1, object2, "sizes");
                return false;
            }
            Object element1 = it1.next();
            if (Utilities.deepEquals(element1, element2 = it2.next(), mode)) continue;
            if (!(object1 instanceof Set) || !(object2 instanceof Set)) {
                assert (Utilities.isNotDebug(mode)) : Utilities.mismatchedElement("Iterable", object1, object2, "elements");
                return false;
            }
            LinkedList copy = new LinkedList();
            copy.add(element1);
            while (it1.hasNext()) {
                copy.add(it1.next());
            }
            while (true) {
                Iterator it = copy.iterator();
                do {
                    if (it.hasNext()) continue;
                    assert (Utilities.isNotDebug(mode)) : Utilities.mismatchedElement("Set", object1, object2, "elements");
                    return false;
                } while (!Utilities.deepEquals(it.next(), element2, mode));
                it.remove();
                if (!it2.hasNext()) break;
                element2 = it2.next();
            }
            return copy.isEmpty();
        }
        return !it2.hasNext();
    }

    private static boolean isNotDebug(ComparisonMode mode) {
        return mode != ComparisonMode.DEBUG;
    }

    private static String mismatchedType(Class<?> expected, Object actual) {
        return "Expected " + expected + " but got " + actual.getClass();
    }

    private static String mismatchedElement(String header, Iterable<?> object1, Iterable<?> object2, String tail) {
        Class type = null;
        if (object1 instanceof CheckedContainer) {
            type = ((CheckedContainer)((Object)object1)).getElementType();
        }
        if (type == null && object2 instanceof CheckedContainer) {
            type = ((CheckedContainer)((Object)object2)).getElementType();
        }
        return header + '<' + (type != null ? type.getSimpleName() : "?") + ">: " + tail + " not equal.";
    }

    public static int deepHashCode(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof Object[]) {
            return Arrays.deepHashCode((Object[])object);
        }
        if (object instanceof double[]) {
            return Arrays.hashCode((double[])object);
        }
        if (object instanceof float[]) {
            return Arrays.hashCode((float[])object);
        }
        if (object instanceof long[]) {
            return Arrays.hashCode((long[])object);
        }
        if (object instanceof int[]) {
            return Arrays.hashCode((int[])object);
        }
        if (object instanceof short[]) {
            return Arrays.hashCode((short[])object);
        }
        if (object instanceof byte[]) {
            return Arrays.hashCode((byte[])object);
        }
        if (object instanceof char[]) {
            return Arrays.hashCode((char[])object);
        }
        if (object instanceof boolean[]) {
            return Arrays.hashCode((boolean[])object);
        }
        return object.hashCode();
    }

    public static String deepToString(Object object) {
        if (object instanceof Object[]) {
            return Arrays.deepToString((Object[])object);
        }
        if (object instanceof double[]) {
            return Arrays.toString((double[])object);
        }
        if (object instanceof float[]) {
            return Arrays.toString((float[])object);
        }
        if (object instanceof long[]) {
            return Arrays.toString((long[])object);
        }
        if (object instanceof int[]) {
            return Arrays.toString((int[])object);
        }
        if (object instanceof short[]) {
            return Arrays.toString((short[])object);
        }
        if (object instanceof byte[]) {
            return Arrays.toString((byte[])object);
        }
        if (object instanceof char[]) {
            return Arrays.toString((char[])object);
        }
        if (object instanceof boolean[]) {
            return Arrays.toString((boolean[])object);
        }
        return String.valueOf(object);
    }
}

