/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util;

import java.io.UncheckedIOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.DirectoryIteratorException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.LocalizedException;
import org.apache.sis.util.Static;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.util.InternationalString;

public final class Exceptions
extends Static {
    private Exceptions() {
    }

    public static String getLocalizedMessage(Throwable exception, Locale locale) {
        String message;
        InternationalString i18n;
        if (exception == null) {
            return null;
        }
        if (locale == null) {
            return exception.getMessage();
        }
        if (exception instanceof LocalizedException && (i18n = ((LocalizedException)((Object)exception)).getInternationalMessage()) != null && (message = i18n.toString(locale)) != null) {
            return message;
        }
        return exception.getLocalizedMessage();
    }

    public static <T extends Throwable> T setMessage(T exception, String message, boolean append) {
        Throwable ne;
        String em;
        if (append && (em = CharSequences.trimWhitespaces(exception.getLocalizedMessage())) != null && !em.isEmpty()) {
            StringBuilder buffer = new StringBuilder(CharSequences.trimWhitespaces(message));
            int length = buffer.length();
            if (length != 0 && Character.isLetterOrDigit(buffer.charAt(length - 1))) {
                buffer.append(". ");
            }
            message = buffer.append(em).toString();
        }
        try {
            ne = (Throwable)exception.getClass().getConstructor(String.class).newInstance(message);
        }
        catch (ReflectiveOperationException e) {
            return exception;
        }
        ne.setStackTrace(exception.getStackTrace());
        return (T)ne;
    }

    public static boolean messageEquals(Throwable first, Throwable second) {
        if (first == second) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        return first.getClass() == second.getClass() && Objects.equals(first.getMessage(), second.getMessage());
    }

    public static String formatChainedMessages(Locale locale, String header, Throwable cause) {
        ArrayList<String> previousLines = new ArrayList<String>();
        StringBuilder buffer = null;
        Vocabulary resources = null;
        while (cause != null) {
            SQLException next;
            String message = CharSequences.trimWhitespaces(Exceptions.getLocalizedMessage(cause, locale));
            if (message != null && !message.isEmpty()) {
                if (buffer == null) {
                    buffer = new StringBuilder(128);
                    if (header != null) {
                        int length = CharSequences.skipTrailingWhitespaces(header, 0, header.length());
                        if (length > 0) {
                            buffer.append(header, 0, length);
                        }
                        previousLines.add(header);
                    }
                }
                if (!Exceptions.contains(previousLines, message)) {
                    previousLines.add(message);
                    if (buffer.length() != 0) {
                        if (resources == null) {
                            resources = Vocabulary.getResources(locale);
                        }
                        buffer.append(System.lineSeparator()).append(resources.getString((short)11, cause.getClass())).append(": ");
                    }
                    buffer.append(message);
                }
            }
            if (cause instanceof SQLException && (next = ((SQLException)cause).getNextException()) != null) {
                cause = next;
                continue;
            }
            cause = cause.getCause();
        }
        return buffer != null ? buffer.toString() : header;
    }

    private static boolean contains(List<String> previousLines, String message) {
        int i = previousLines.size();
        while (--i >= 0) {
            if (!previousLines.get(i).contains(message)) continue;
            return true;
        }
        return false;
    }

    public static Exception unwrap(Exception exception) {
        if (exception != null) {
            Throwable cause;
            while ((exception instanceof InvocationTargetException || exception instanceof BackingStoreException || exception instanceof UncheckedIOException || exception instanceof DirectoryIteratorException) && (cause = exception.getCause()) instanceof Exception) {
                exception = (Exception)cause;
            }
            while (true) {
                cause = exception.getCause();
                if (!exception.getClass().isInstance(cause)) break;
                exception = (Exception)cause;
            }
        }
        return exception;
    }
}

