/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.netcdf;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.ByteBuffer;
import java.nio.file.NoSuchFileException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.Resources;
import org.apache.sis.internal.netcdf.impl.ChannelDecoder;
import org.apache.sis.internal.storage.Capability;
import org.apache.sis.internal.storage.StoreMetadata;
import org.apache.sis.internal.storage.URIDataStore;
import org.apache.sis.internal.storage.io.ChannelDataInput;
import org.apache.sis.internal.system.SystemListener;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.ProbeResult;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.storage.netcdf.NetcdfStore;
import org.apache.sis.util.Version;
import org.apache.sis.util.logging.Logging;
import org.opengis.parameter.ParameterDescriptorGroup;

@StoreMetadata(formatName="NetCDF", fileSuffixes={"nc"}, capabilities={Capability.READ})
public class NetcdfStoreProvider
extends DataStoreProvider {
    static final String NAME = "NetCDF";
    static final String MIME_TYPE = "application/x-netcdf";
    private static final ParameterDescriptorGroup OPEN_DESCRIPTOR = URIDataStore.Provider.descriptor("NetCDF");
    private static final String UCAR_CLASSNAME = "ucar.nc2.NetcdfFile";
    private static Class<?> netcdfFileClass;
    private static volatile Method canOpenFromPath;
    private static volatile Constructor<? extends Decoder> createFromPath;
    private static volatile Constructor<? extends Decoder> createFromUCAR;

    @Override
    public String getShortName() {
        return NAME;
    }

    @Override
    public ParameterDescriptorGroup getOpenParameters() {
        return OPEN_DESCRIPTOR;
    }

    @Override
    public ProbeResult probeContent(StorageConnector connector) throws DataStoreException {
        int version = 0;
        boolean hasVersion = false;
        boolean isSupported = false;
        ByteBuffer buffer = connector.getStorageAs(ByteBuffer.class);
        if (buffer != null) {
            if (buffer.remaining() < 4) {
                return ProbeResult.INSUFFICIENT_BYTES;
            }
            int header = buffer.getInt(buffer.position());
            if ((header & 0xFFFFFF00) == 1128547840) {
                hasVersion = true;
                version = header & 0xFF;
                boolean bl = isSupported = version >= 1 && version <= 2;
            }
        }
        if (!isSupported) {
            String path = connector.getStorageAs(String.class);
            if (path != null) {
                NetcdfStoreProvider.ensureInitialized(false);
                Method method = canOpenFromPath;
                if (method != null) {
                    try {
                        isSupported = (Boolean)method.invoke(null, path);
                    }
                    catch (IllegalAccessException e) {
                        throw (Error)new IncompatibleClassChangeError("canOpen").initCause(e);
                    }
                    catch (InvocationTargetException e) {
                        Throwable cause = e.getCause();
                        if (cause instanceof DataStoreException) {
                            throw (DataStoreException)cause;
                        }
                        if (cause instanceof RuntimeException) {
                            throw (RuntimeException)cause;
                        }
                        if (cause instanceof Error) {
                            throw (Error)cause;
                        }
                        if (cause instanceof FileNotFoundException || cause instanceof NoSuchFileException) {
                            Logging.recoverableException(Logging.getLogger("org.apache.sis.storage.netcdf"), netcdfFileClass, "canOpen", cause);
                            return ProbeResult.UNSUPPORTED_STORAGE;
                        }
                        throw new DataStoreException(e);
                    }
                }
            } else {
                for (Class<?> type = connector.getStorage().getClass(); type != null; type = type.getSuperclass()) {
                    if (!UCAR_CLASSNAME.equals(type.getName())) continue;
                    isSupported = true;
                    break;
                }
            }
        }
        if (hasVersion) {
            return new ProbeResult(isSupported, MIME_TYPE, Version.valueOf(version));
        }
        return isSupported ? new ProbeResult(true, MIME_TYPE, null) : ProbeResult.UNSUPPORTED_STORAGE;
    }

    @Override
    public DataStore open(StorageConnector connector) throws DataStoreException {
        return new NetcdfStore(this, connector);
    }

    static Decoder decoder(StoreListeners listeners, StorageConnector connector) throws IOException, DataStoreException {
        Object keepOpen;
        Decoder decoder;
        GeometryLibrary geomlib = connector.getOption(OptionKey.GEOMETRY_LIBRARY);
        ChannelDataInput input = connector.getStorageAs(ChannelDataInput.class);
        if (input != null) {
            try {
                ChannelDecoder cd = new ChannelDecoder(input, connector.getOption(OptionKey.ENCODING), geomlib, listeners);
                cd.applyOtherConventions();
                decoder = cd;
                keepOpen = input;
            }
            catch (ArithmeticException | DataStoreException e) {
                String path = connector.getStorageAs(String.class);
                if (path != null) {
                    try {
                        decoder = NetcdfStoreProvider.createByReflection(path, false, geomlib, listeners);
                        keepOpen = path;
                    }
                    catch (IOException | DataStoreException s) {
                        e.addSuppressed(s);
                        throw e;
                    }
                }
                throw e;
            }
        } else {
            keepOpen = connector.getStorage();
            decoder = NetcdfStoreProvider.createByReflection(keepOpen, true, geomlib, listeners);
        }
        connector.closeAllExcept(keepOpen);
        return decoder;
    }

    private static Decoder createByReflection(Object input, boolean isUCAR, GeometryLibrary geomlib, StoreListeners listeners) throws IOException, DataStoreException {
        Class<Object> expectedType;
        Constructor<? extends Decoder> constructor;
        NetcdfStoreProvider.ensureInitialized(true);
        if (isUCAR) {
            constructor = createFromUCAR;
            expectedType = netcdfFileClass;
        } else {
            constructor = createFromPath;
            expectedType = String.class;
        }
        if (constructor == null || !expectedType.isInstance(input)) {
            return null;
        }
        try {
            return constructor.newInstance(new Object[]{input, geomlib, listeners});
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof DataStoreException) {
                throw (DataStoreException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new UndeclaredThrowableException(cause);
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void ensureInitialized(boolean open) {
        if (netcdfFileClass != null) return;
        Level severity = null;
        Throwable cause = null;
        Class<NetcdfStoreProvider> clazz = NetcdfStoreProvider.class;
        synchronized (NetcdfStoreProvider.class) {
            try {
                netcdfFileClass = Class.forName(UCAR_CLASSNAME);
                canOpenFromPath = netcdfFileClass.getMethod("canOpen", String.class);
                if (canOpenFromPath.getReturnType() == Boolean.TYPE) {
                    Class<Decoder> wrapper = Class.forName("org.apache.sis.internal.netcdf.ucar.DecoderWrapper").asSubclass(Decoder.class);
                    Class[] parameterTypes = new Class[]{netcdfFileClass, GeometryLibrary.class, StoreListeners.class};
                    createFromUCAR = wrapper.getConstructor(parameterTypes);
                    parameterTypes[0] = String.class;
                    createFromPath = wrapper.getConstructor(parameterTypes);
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
            }
            catch (ClassNotFoundException e) {
                severity = Level.CONFIG;
            }
            catch (NoClassDefFoundError | ReflectiveOperationException e) {
                severity = Level.WARNING;
                cause = e;
            }
            NetcdfStoreProvider.reset();
            netcdfFileClass = Void.TYPE;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            LogRecord record = Resources.forLocale(null).getLogRecord(severity, (short)4);
            record.setThrown(cause);
            record.setLoggerName("org.apache.sis.storage.netcdf");
            Logging.log(NetcdfStoreProvider.class, open ? "open" : "probeContent", record);
            return;
        }
    }

    static synchronized void reset() {
        netcdfFileClass = null;
        canOpenFromPath = null;
        createFromUCAR = null;
        createFromPath = null;
    }

    static {
        SystemListener.add(new SystemListener("org.apache.sis.storage.netcdf"){

            @Override
            protected void classpathChanged() {
                NetcdfStoreProvider.reset();
            }
        });
    }
}

