/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.sis.internal.storage.io.ChannelDataInput;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.math.Vector;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.resources.Errors;

enum Type {
    UNDEFINED(7, 1, false){

        @Override
        public long readLong(ChannelDataInput input, long count) throws IOException {
            throw new UnsupportedOperationException(this.name());
        }
    }
    ,
    BYTE(6, 1, false){

        @Override
        public long readLong(ChannelDataInput input, long count) throws IOException {
            long value = input.readByte();
            for (long i = 1L; i < count; ++i) {
                2.ensureSingleton(value, input.readByte(), count);
            }
            return value;
        }

        @Override
        public Object readArray(ChannelDataInput input, int count) throws IOException {
            return input.readBytes(count);
        }
    }
    ,
    UBYTE(1, 1, true){

        @Override
        public long readLong(ChannelDataInput input, long count) throws IOException {
            long value = input.readUnsignedByte();
            for (long i = 1L; i < count; ++i) {
                3.ensureSingleton(value, input.readUnsignedByte(), count);
            }
            return value;
        }

        @Override
        public Object readArray(ChannelDataInput input, int count) throws IOException {
            return input.readBytes(count);
        }
    }
    ,
    SHORT(8, 2, false){

        @Override
        public long readLong(ChannelDataInput input, long count) throws IOException {
            long value = input.readShort();
            for (long i = 1L; i < count; ++i) {
                4.ensureSingleton(value, input.readShort(), count);
            }
            return value;
        }

        @Override
        public Object readArray(ChannelDataInput input, int count) throws IOException {
            return input.readShorts(count);
        }
    }
    ,
    USHORT(3, 2, true){

        @Override
        public long readLong(ChannelDataInput input, long count) throws IOException {
            long value = input.readUnsignedShort();
            for (long i = 1L; i < count; ++i) {
                5.ensureSingleton(value, input.readUnsignedShort(), count);
            }
            return value;
        }

        @Override
        public Object readArray(ChannelDataInput input, int count) throws IOException {
            return input.readShorts(count);
        }
    }
    ,
    INT(9, 4, false){

        @Override
        public long readLong(ChannelDataInput input, long count) throws IOException {
            long value = input.readInt();
            for (long i = 1L; i < count; ++i) {
                6.ensureSingleton(value, input.readInt(), count);
            }
            return value;
        }

        @Override
        public Object readArray(ChannelDataInput input, int count) throws IOException {
            return input.readInts(count);
        }
    }
    ,
    UINT(4, 4, true){

        @Override
        public long readLong(ChannelDataInput input, long count) throws IOException {
            long value = input.readUnsignedInt();
            for (long i = 1L; i < count; ++i) {
                7.ensureSingleton(value, input.readUnsignedInt(), count);
            }
            return value;
        }

        @Override
        public Object readArray(ChannelDataInput input, int count) throws IOException {
            return input.readInts(count);
        }
    }
    ,
    LONG(17, 8, false){

        @Override
        public long readLong(ChannelDataInput input, long count) throws IOException {
            long value = input.readLong();
            for (long i = 1L; i < count; ++i) {
                8.ensureSingleton(value, input.readLong(), count);
            }
            return value;
        }

        @Override
        public Object readArray(ChannelDataInput input, int count) throws IOException {
            return input.readLongs(count);
        }
    }
    ,
    ULONG(16, 8, true){

        @Override
        public long readLong(ChannelDataInput input, long count) throws IOException {
            long value = input.readLong();
            for (long i = 1L; i < count; ++i) {
                9.ensureSingleton(value, input.readLong(), count);
            }
            if (value >= 0L) {
                return value;
            }
            throw new ArithmeticException(this.canNotConvert(Long.toUnsignedString(value)));
        }

        @Override
        public double readDouble(ChannelDataInput input, long count) throws IOException {
            return Numerics.toUnsignedDouble(this.readLong(input, count));
        }

        @Override
        public Object readArray(ChannelDataInput input, int count) throws IOException {
            return input.readLongs(count);
        }
    }
    ,
    FLOAT(11, 4, false){

        private float readFloat(ChannelDataInput input, long count) throws IOException {
            float value = input.readFloat();
            for (long i = 1L; i < count; ++i) {
                10.ensureSingleton(value, input.readFloat(), count);
            }
            return value;
        }

        @Override
        public long readLong(ChannelDataInput input, long count) throws IOException {
            float value = this.readFloat(input, count);
            long r = (long)value;
            if ((float)r == value) {
                return r;
            }
            throw new ArithmeticException(this.canNotConvert(Float.toString(value)));
        }

        @Override
        public double readDouble(ChannelDataInput input, long count) throws IOException {
            return DecimalFunctions.floatToDouble(this.readFloat(input, count));
        }

        @Override
        public Object readArray(ChannelDataInput input, int count) throws IOException {
            return input.readFloats(count);
        }
    }
    ,
    DOUBLE(12, 8, false){

        @Override
        public double readDouble(ChannelDataInput input, long count) throws IOException {
            double value = input.readDouble();
            for (long i = 1L; i < count; ++i) {
                11.ensureSingleton(value, input.readDouble(), count);
            }
            return value;
        }

        @Override
        public Object readArray(ChannelDataInput input, int count) throws IOException {
            return input.readDoubles(count);
        }
    }
    ,
    RATIONAL(10, 8, false){

        @Override
        public double readDouble(ChannelDataInput input, long count) throws IOException {
            double value = (double)input.readInt() / (double)input.readInt();
            for (long i = 1L; i < count; ++i) {
                12.ensureSingleton(value, (double)input.readInt() / (double)input.readInt(), count);
            }
            return value;
        }
    }
    ,
    URATIONAL(5, 8, true){

        @Override
        public double readDouble(ChannelDataInput input, long count) throws IOException {
            double value = (double)input.readUnsignedInt() / (double)input.readUnsignedInt();
            for (long i = 1L; i < count; ++i) {
                13.ensureSingleton(value, (double)input.readUnsignedInt() / (double)input.readUnsignedInt(), count);
            }
            return value;
        }
    }
    ,
    ASCII(2, 1, false){

        @Override
        public String[] readString(ChannelDataInput input, long length, Charset charset) throws IOException {
            byte[] chars = input.readBytes(Math.toIntExact(length));
            String[] lines = new String[1];
            int count = 0;
            int lower = 0;
            for (int i = 0; i < chars.length; ++i) {
                if (chars[i] != 0) continue;
                if (count >= lines.length) {
                    lines = Arrays.copyOf(lines, 2 * count);
                }
                lines[count++] = new String(chars, lower, i - lower, charset);
            }
            return ArraysExt.resize(lines, count);
        }

        private String readString(ChannelDataInput input, long count) throws IOException {
            String[] lines = this.readString(input, count, StandardCharsets.US_ASCII);
            String value = lines[0];
            for (int i = 1; i < lines.length; ++i) {
                if (value.equals(lines[i])) continue;
                throw new IllegalArgumentException(Errors.format((short)133, 1, count));
            }
            return value;
        }

        @Override
        public long readLong(ChannelDataInput input, long count) throws IOException {
            return Long.parseLong(this.readString(input, count));
        }

        @Override
        public double readDouble(ChannelDataInput input, long count) throws IOException {
            return Double.parseDouble(this.readString(input, count));
        }

        @Override
        public Object readArray(ChannelDataInput input, int count) throws IOException {
            return this.readString(input, count, StandardCharsets.US_ASCII);
        }
    };

    final int code;
    final int size;
    final boolean isUnsigned;
    private static final Type[] FROM_CODES;

    private Type(int code, int size, boolean isUnsigned) {
        this.code = code;
        this.size = size;
        this.isUnsigned = isUnsigned;
    }

    static Type valueOf(int code) {
        return code >= 0 && code < FROM_CODES.length ? FROM_CODES[code] : null;
    }

    static String toString(long numerator, long denominator) {
        return "" + numerator + '/' + denominator;
    }

    static void ensureSingleton(long previous, long actual, long count) {
        if (previous != actual) {
            throw new IllegalArgumentException(Errors.format((short)133, 1, count));
        }
    }

    static void ensureSingleton(double previous, double actual, long count) {
        if (Double.doubleToLongBits(previous) != Double.doubleToLongBits(actual)) {
            throw new IllegalArgumentException(Errors.format((short)133, 1, count));
        }
    }

    final String canNotConvert(String value) {
        return Errors.format((short)8, value, this.name());
    }

    public final short readShort(ChannelDataInput input, long count) throws IOException {
        long value = this.readLong(input, count);
        if (value >= -32768L && value <= 32767L) {
            return (short)value;
        }
        throw new ArithmeticException(this.canNotConvert(Long.toString(value)));
    }

    public final int readInt(ChannelDataInput input, long count) throws IOException {
        long value = this.readLong(input, count);
        if (value >= Integer.MIN_VALUE && value <= Integer.MAX_VALUE) {
            return (int)value;
        }
        throw new ArithmeticException(this.canNotConvert(Long.toString(value)));
    }

    public final long readUnsignedLong(ChannelDataInput input, long count) throws IOException {
        long value = this.readLong(input, count);
        if (value >= 0L) {
            return value;
        }
        throw new ArithmeticException(this.canNotConvert(Long.toUnsignedString(value)));
    }

    public long readLong(ChannelDataInput input, long count) throws IOException {
        double value = this.readDouble(input, count);
        long r = (long)value;
        if ((double)r == value) {
            return r;
        }
        throw new ArithmeticException(this.canNotConvert(Double.toString(value)));
    }

    public double readDouble(ChannelDataInput input, long count) throws IOException {
        return this.readLong(input, count);
    }

    public String[] readString(ChannelDataInput input, long length, Charset charset) throws IOException {
        String[] s = new String[Math.toIntExact(length)];
        for (int i = 0; i < s.length; ++i) {
            double value = this.readDouble(input, 1L);
            long r = (long)value;
            s[i] = (double)r == value ? String.valueOf(r) : String.valueOf(value);
        }
        return s;
    }

    public Object readArray(ChannelDataInput input, int count) throws IOException {
        throw new UnsupportedOperationException(this.name());
    }

    public final Vector readVector(ChannelDataInput input, long count) throws IOException {
        return Vector.create(this.readArray(input, Math.toIntExact(count)), this.isUnsigned);
    }

    static {
        FROM_CODES = new Type[19];
        Type[] typeArray = Type.values();
        int n = typeArray.length;
        for (int i = 0; i < n; ++i) {
            Type type;
            Type.FROM_CODES[type.code] = type = typeArray[i];
        }
        Type.FROM_CODES[13] = UINT;
        Type.FROM_CODES[18] = ULONG;
    }
}

