/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff;

import java.util.NoSuchElementException;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.internal.storage.MetadataBuilder;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.math.Vector;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.storage.geotiff.CRSBuilder;
import org.apache.sis.storage.geotiff.Localization;
import org.apache.sis.storage.geotiff.Reader;
import org.opengis.metadata.spatial.CellGeometry;
import org.opengis.metadata.spatial.DimensionNameType;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;
import org.opengis.util.NoSuchIdentifierException;

final class GridGeometryBuilder {
    private final Reader reader;
    public Vector keyDirectory;
    public Vector numericParameters;
    public String asciiParameters;
    public Vector modelTiePoints;
    private MatrixSIS affine;
    private boolean completeMatrixSpecified;
    public GridGeometry gridGeometry;
    private String description;
    private CellGeometry cellGeometry;

    public void setGridToCRS(Vector terms, int size) {
        int length = terms.size();
        this.completeMatrixSpecified = true;
        this.affine = Matrices.createZero(size, size);
        this.affine.setElement(size - 1, size - 1, 1.0);
        for (int i = 0; i < length; ++i) {
            this.affine.setElement(i / size, i % size, terms.doubleValue(i));
        }
    }

    public void setScaleFactors(Vector terms) {
        int size = terms.size();
        this.completeMatrixSpecified = false;
        this.affine = Matrices.createZero(size + 1, size + 1);
        this.affine.setElement(size, size, 1.0);
        for (int i = 0; i < size; ++i) {
            double e = terms.doubleValue(i);
            if (i == 1) {
                e = -e;
            }
            this.affine.setElement(i, i, e);
            this.affine.setElement(i, size, Double.NaN);
        }
    }

    GridGeometryBuilder(Reader reader) {
        this.reader = reader;
    }

    public boolean validateMandatoryTags() {
        MatrixSIS affine = this.affine;
        if (affine == null || this.completeMatrixSpecified) {
            return true;
        }
        Vector modelTiePoints = this.modelTiePoints;
        if (modelTiePoints != null) {
            int nearest = 0;
            double distance = Double.POSITIVE_INFINITY;
            int size = modelTiePoints.size();
            for (int i = 0; i < size; i += 6) {
                double t = modelTiePoints.doubleValue(i);
                double d = t * t;
                t = modelTiePoints.doubleValue(i + 1);
                double d2 = d + t * t;
                t = modelTiePoints.doubleValue(i + 2);
                double d3 = d2 + t * t;
                if (!(d3 < distance)) continue;
                distance = d3;
                nearest = i;
                if (d3 == 0.0) break;
            }
            if (distance != Double.POSITIVE_INFINITY) {
                DoubleDouble t = new DoubleDouble();
                int numDim = affine.getNumRow() - 1;
                int trCol = affine.getNumCol() - 1;
                for (int j = 0; j < numDim; ++j) {
                    t.value = -modelTiePoints.doubleValue(nearest + j);
                    t.error = DoubleDouble.errorForWellKnownValue(t.value);
                    t.multiplyGuessError(affine.getNumber(j, j));
                    t.addGuessError(modelTiePoints.doubleValue(nearest + j + 3));
                    affine.setNumber(j, trCol, t);
                }
                return true;
            }
        }
        return false;
    }

    public GridGeometry build(long width, long height) throws FactoryException {
        CoordinateReferenceSystem crs;
        block15: {
            crs = null;
            if (this.keyDirectory != null) {
                CRSBuilder helper = new CRSBuilder(this.reader);
                try {
                    crs = helper.build(this.keyDirectory, this.numericParameters, this.asciiParameters);
                    this.description = helper.description;
                    this.cellGeometry = helper.cellGeometry;
                }
                catch (ParameterNotFoundException | NoSuchIdentifierException e) {
                    short key = 23;
                    if (e instanceof NoSuchAuthorityCodeException) {
                        key = 22;
                    }
                    this.reader.owner.warning(this.reader.resources().getString(key, this.reader.owner.getDisplayName()), (Exception)e);
                }
                catch (ClassCastException | IllegalArgumentException | NoSuchElementException e) {
                    if (helper.alreadyReported) break block15;
                    this.canNotCreate(e);
                }
            }
        }
        int n = crs != null ? crs.getCoordinateSystem().getDimension() : 2;
        DimensionNameType[] axisTypes = new DimensionNameType[n];
        long[] high = new long[n];
        switch (n) {
            default: {
                axisTypes[2] = DimensionNameType.VERTICAL;
            }
            case 2: {
                axisTypes[1] = DimensionNameType.ROW;
                high[1] = height - 1L;
            }
            case 1: {
                axisTypes[0] = DimensionNameType.COLUMN;
                high[0] = width - 1L;
            }
            case 0: 
        }
        GridExtent extent = new GridExtent(axisTypes, null, high, true);
        boolean pixelIsPoint = CellGeometry.POINT.equals((Object)this.cellGeometry);
        MathTransformFactory factory = DefaultFactories.forBuildin(MathTransformFactory.class);
        try {
            MathTransform gridToCRS;
            if (this.affine != null) {
                gridToCRS = factory.createAffineTransform(Matrices.resizeAffine(this.affine, ++n, n));
            } else {
                pixelIsPoint = true;
                gridToCRS = Localization.nonLinear(this.modelTiePoints);
                gridToCRS = factory.createPassThroughTransform(0, gridToCRS, n - 2);
            }
            this.gridGeometry = new GridGeometry(extent, pixelIsPoint ? PixelInCell.CELL_CENTER : PixelInCell.CELL_CORNER, gridToCRS, crs);
        }
        catch (TransformException e) {
            GeneralEnvelope envelope = null;
            if (crs != null) {
                envelope = new GeneralEnvelope(crs);
                envelope.setToNaN();
            }
            this.gridGeometry = new GridGeometry(extent, envelope);
            this.canNotCreate((Exception)((Object)e));
        }
        this.keyDirectory = null;
        this.numericParameters = null;
        this.asciiParameters = null;
        this.modelTiePoints = null;
        this.affine = null;
        return this.gridGeometry;
    }

    public void completeMetadata(MetadataBuilder metadata) {
        if (metadata.addSpatialRepresentation(this.description, this.gridGeometry, true)) {
            PixelOrientation po;
            metadata.setCellGeometry(this.cellGeometry);
            if (CellGeometry.POINT.equals((Object)this.cellGeometry)) {
                po = PixelOrientation.CENTER;
            } else if (CellGeometry.AREA.equals((Object)this.cellGeometry)) {
                po = PixelOrientation.UPPER_LEFT;
            } else {
                return;
            }
            metadata.setPointInPixel(po);
        }
    }

    private void canNotCreate(Exception e) {
        this.reader.owner.warning(this.reader.resources().getString((short)26, this.reader.input.filename), e);
    }
}

