/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff;

enum Compression {
    NONE(1),
    CCITTRLE(2),
    PACKBITS(32773),
    LZW(5),
    DEFLATE(8),
    JPEG(7),
    CCITTFAX3(3),
    CCITTFAX4(4),
    NEXT(32766),
    CCITTRLEW(32771),
    THUNDERSCAN(32809),
    IT8CTPAD(32895),
    IT8LW(32896),
    IT8MP(32897),
    IT8BL(32898),
    PIXARFILM(32908),
    PIXARLOG(32909),
    DCS(32947),
    JBIG(34661),
    SGILOG(34676),
    SGILOG24(34677),
    JP2000(34712);

    final int code;

    private Compression(int code) {
        this.code = code;
    }

    static Compression valueOf(long code) {
        if ((code & 0xFFFFFFFFFFFF0000L) == 0L) {
            switch ((int)code) {
                case 1: {
                    return NONE;
                }
                case 2: {
                    return CCITTRLE;
                }
                case 5: {
                    return LZW;
                }
                case 6: 
                case 7: {
                    return JPEG;
                }
                case 8: 
                case 32946: {
                    return DEFLATE;
                }
                case 32773: {
                    return PACKBITS;
                }
            }
            for (Compression c : Compression.values()) {
                if ((long)c.code != code) continue;
                return c;
            }
        }
        return null;
    }
}

