/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.event;

import java.lang.reflect.Method;
import java.util.IdentityHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.sis.internal.storage.StoreResource;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.event.QuietLogRecord;
import org.apache.sis.storage.event.StoreEvent;
import org.apache.sis.storage.event.StoreListener;
import org.apache.sis.storage.event.WarningEvent;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.Localized;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.logging.WarningListener;
import org.apache.sis.util.logging.WarningListeners;

public class StoreListeners
extends WarningListeners
implements Localized {
    private final StoreListeners parent;
    private final Resource source;
    private volatile ForType<?> listeners;

    public StoreListeners(StoreListeners parent, Resource source) {
        super(source);
        if (source == null && this instanceof Resource) {
            source = (Resource)((Object)this);
        } else {
            ArgumentChecks.ensureNonNull("source", source);
        }
        this.source = source;
        this.parent = parent;
    }

    public Resource getSource() {
        return this.source;
    }

    private static DataStore getDataStore(StoreListeners m) {
        do {
            DataStore ds;
            Resource source;
            if ((source = m.source) instanceof DataStore) {
                return (DataStore)source;
            }
            if (!(source instanceof StoreResource) || (ds = ((StoreResource)source).getOriginator()) == null) continue;
            return ds;
        } while ((m = m.parent) != null);
        return null;
    }

    public String getSourceName() {
        DataStore ds = StoreListeners.getDataStore(this);
        if (ds != null) {
            String name = ds.getDisplayName();
            if (name != null) {
                return name;
            }
            DataStoreProvider provider = ds.getProvider();
            if (provider != null && (name = provider.getShortName()) != null) {
                return name;
            }
        }
        return Classes.getShortClassName(this.source);
    }

    @Override
    public Locale getLocale() {
        StoreListeners m = this;
        do {
            Locale locale;
            Resource src;
            if ((src = m.source) == this || src == m || !(src instanceof Localized) || (locale = ((Localized)((Object)src)).getLocale()) == null) continue;
            return locale;
        } while ((m = m.parent) != null);
        return null;
    }

    private Logger logger() {
        Resource src = this.source;
        DataStore ds = StoreListeners.getDataStore(this);
        if (ds != null) {
            Logger logger;
            DataStoreProvider provider = ds.getProvider();
            if (provider != null && (logger = provider.getLogger()) != null) {
                return logger;
            }
            src = ds;
        }
        return Logging.getLogger(src.getClass());
    }

    public void warning(String message) {
        ArgumentChecks.ensureNonNull("message", message);
        this.warning(Level.WARNING, message, null);
    }

    public void warning(Exception exception) {
        ArgumentChecks.ensureNonNull("exception", exception);
        this.warning(Level.WARNING, null, exception);
    }

    @Override
    public void warning(String message, Exception exception) {
        this.warning(Level.WARNING, message, exception);
    }

    @Override
    public void warning(Level level, String message, Exception exception) {
        LogRecord record;
        StackTraceElement[] trace;
        ArgumentChecks.ensureNonNull("level", level);
        if (exception != null) {
            trace = exception.getStackTrace();
            message = Exceptions.formatChainedMessages(this.getLocale(), message, exception);
            if (message == null) {
                message = exception.toString();
            }
            record = new QuietLogRecord(level, message, exception);
        } else {
            ArgumentChecks.ensureNonEmpty("message", message);
            trace = Thread.currentThread().getStackTrace();
            record = new LogRecord(level, message);
        }
        try {
            for (StackTraceElement e : trace) {
                if (StoreListeners.setPublicSource(record, Class.forName(e.getClassName()), e.getMethodName())) break;
            }
        }
        catch (ClassNotFoundException | SecurityException e) {
            Logging.ignorableException(Logging.getLogger("org.apache.sis.storage"), StoreListeners.class, "warning", e);
        }
        this.warning(record);
    }

    private static boolean setPublicSource(LogRecord record, Class<?> type, String methodName) {
        if (Resource.class.isAssignableFrom(type)) {
            record.setSourceClassName(type.getCanonicalName());
            record.setSourceMethodName(methodName);
            for (Method m : type.getMethods()) {
                if (!methodName.equals(m.getName())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void warning(LogRecord description) {
        if (!this.fire(new WarningEvent(this.source, description), WarningEvent.class)) {
            Logger logger;
            String name = description.getLoggerName();
            if (name != null) {
                logger = Logging.getLogger(name);
            } else {
                logger = this.logger();
                description.setLoggerName(logger.getName());
            }
            if (description instanceof QuietLogRecord) {
                ((QuietLogRecord)description).clearImplicitThrown();
            }
            logger.log(description);
        }
    }

    public <T extends StoreEvent> boolean fire(T event, Class<T> eventType) {
        ArgumentChecks.ensureNonNull("event", event);
        ArgumentChecks.ensureNonNull("eventType", eventType);
        Map<StoreListener<?>, Boolean> done = null;
        StoreListeners m = this;
        do {
            ForType<?> e = m.listeners;
            while (e != null) {
                if (e.type.isAssignableFrom(eventType)) {
                    done = e.eventOccured(event, done);
                }
                e = e.next;
            }
        } while ((m = m.parent) != null);
        return done != null && !done.isEmpty();
    }

    public synchronized <T extends StoreEvent> void addListener(Class<T> eventType, StoreListener<? super T> listener) {
        ArgumentChecks.ensureNonNull("listener", listener);
        ArgumentChecks.ensureNonNull("eventType", eventType);
        ForType<Object> ce = null;
        ForType<?> e = this.listeners;
        while (e != null) {
            if (e.type.equals(eventType)) {
                ce = e;
                break;
            }
            e = e.next;
        }
        if (ce == null) {
            ce = new ForType<T>(eventType, this.listeners);
            this.listeners = ce;
        }
        ce.add(listener);
    }

    public synchronized <T extends StoreEvent> void removeListener(Class<T> eventType, StoreListener<? super T> listener) {
        ArgumentChecks.ensureNonNull("listener", listener);
        ArgumentChecks.ensureNonNull("eventType", eventType);
        ForType<?> e = this.listeners;
        while (e != null) {
            if (e.type.equals(eventType)) {
                e.remove(listener);
                break;
            }
            e = e.next;
        }
    }

    public boolean hasListeners(Class<? extends StoreEvent> eventType) {
        ArgumentChecks.ensureNonNull("eventType", eventType);
        StoreListeners m = this;
        block0: do {
            ForType<?> e = m.listeners;
            while (e != null) {
                if (eventType.isAssignableFrom(e.type)) {
                    if (!e.hasListeners()) continue block0;
                    return true;
                }
                e = e.next;
            }
        } while ((m = m.parent) != null);
        return false;
    }

    @Override
    @Deprecated
    public boolean hasListeners() {
        return this.hasListeners(StoreEvent.class);
    }

    @Deprecated
    public void addWarningListener(WarningListener listener) {
        this.addListener(WarningEvent.class, new Legacy(listener));
    }

    @Deprecated
    public void removeWarningListener(WarningListener listener) {
        ForType<?> e = this.listeners;
        while (e != null) {
            StoreListener[] list;
            if (e.type.equals(WarningEvent.class) && (list = ((ForType)e).listeners) != null) {
                for (StoreListener c : list) {
                    if (!(c instanceof Legacy) || ((Legacy)c).delegate != listener) continue;
                    this.removeListener(WarningEvent.class, c);
                    break;
                }
            }
            e = e.next;
        }
    }

    @Deprecated
    private static final class Legacy
    implements StoreListener<WarningEvent> {
        final WarningListener<? super Resource> delegate;

        Legacy(WarningListener<? super Resource> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void eventOccured(WarningEvent event) {
            this.delegate.warningOccured(event.getSource(), event.getDescription());
        }
    }

    private static final class ForType<T extends StoreEvent> {
        final Class<T> type;
        private volatile StoreListener<? super T>[] listeners;
        final ForType<?> next;

        ForType(Class<T> type, ForType<?> next) {
            this.type = type;
            this.next = next;
        }

        final void add(StoreListener<? super T> listener) {
            StoreListener<? super T>[] list = this.listeners;
            int length = list != null ? list.length : 0;
            StoreListener[] copy = new StoreListener[length + 1];
            if (list != null) {
                System.arraycopy(list, 0, copy, 0, length);
            }
            copy[length] = listener;
            this.listeners = copy;
        }

        final void remove(StoreListener<? super T> listener) {
            Object list = this.listeners;
            if (list != null) {
                int i = ((StoreListener<? super T>[])list).length;
                while (--i >= 0) {
                    if (list[i] != listener) continue;
                    list = ((StoreListener<? super T>[])list).length == 1 ? null : ArraysExt.remove(list, i, 1);
                    this.listeners = list;
                    break;
                }
            }
        }

        final boolean hasListeners() {
            return this.listeners != null;
        }

        final Map<StoreListener<?>, Boolean> eventOccured(T event, Map<StoreListener<?>, Boolean> done) {
            StoreListener<? super T>[] list = this.listeners;
            if (list != null) {
                if (done == null) {
                    done = new IdentityHashMap(list.length);
                }
                for (StoreListener<T> storeListener : list) {
                    if (done.put(storeListener, Boolean.TRUE) != null) continue;
                    storeListener.eventOccured(event);
                }
            }
            return done;
        }
    }
}

