/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.earthobservation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.temporal.Temporal;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sis.internal.referencing.GeodeticObjectBuilder;
import org.apache.sis.internal.referencing.ReferencingFactoryContainer;
import org.apache.sis.internal.referencing.provider.TransverseMercator;
import org.apache.sis.internal.storage.MetadataBuilder;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.internal.util.StandardDateFormat;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.ModifiableMetadata;
import org.apache.sis.metadata.iso.DefaultIdentifier;
import org.apache.sis.metadata.iso.DefaultMetadata;
import org.apache.sis.metadata.iso.content.DefaultAttributeGroup;
import org.apache.sis.metadata.iso.content.DefaultBand;
import org.apache.sis.metadata.iso.content.DefaultCoverageDescription;
import org.apache.sis.metadata.sql.MetadataStoreException;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreReferencingException;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.apache.sis.util.iso.SimpleInternationalString;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.citation.DateType;
import org.opengis.metadata.content.CoverageContentType;
import org.opengis.metadata.content.TransferFunctionType;
import org.opengis.metadata.identification.TopicCategory;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.metadata.spatial.DimensionNameType;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.util.FactoryException;
import org.opengis.util.NoSuchIdentifierException;

final class LandsatReader
extends MetadataBuilder {
    private static final String[] BAND_NAMES = new String[]{"Coastal Aerosol", "Blue", "Green", "Red", "Near-Infrared", "Short Wavelength Infrared (SWIR) 1", "Short Wavelength Infrared (SWIR) 2", "Panchromatic", "Cirrus", "Thermal Infrared Sensor (TIRS) 1", "Thermal Infrared Sensor (TIRS) 2"};
    private static final short[] WAVELENGTHS = new short[]{433, 482, 562, 655, 865, 1610, 2200, 590, 1375, 10800, 12000};
    static final Pattern CREDIT = Pattern.compile("\\bcourtesy\\h+of\\h+(the)?\\b\\s*", 2);
    static final int DIM = 2;
    private static final String BAND_SUFFIX = "_BAND";
    static final int BAND_GROUPS = 2692437;
    private static final int NUM_GROUPS = 3;
    static final int PANCHROMATIC = 0;
    static final int REFLECTIVE = 2;
    static final int THERMAL = 4;
    private static final int PROJECTED = 0;
    private static final int GEOGRAPHIC = 8;
    private static final String END = "END";
    private String filename;
    private final StoreListeners listeners;
    private String group;
    private Temporal sceneTime;
    private final double[] corners;
    private final int[] gridSizes;
    private final DefaultBand[] bands;
    private CommonCRS datum;
    private short utmZone;
    private ParameterValueGroup projection;
    private final ReferencingFactoryContainer factories;

    LandsatReader(String filename, StoreListeners listeners) {
        this.filename = filename;
        this.listeners = listeners;
        this.factories = new ReferencingFactoryContainer();
        this.bands = new DefaultBand[BAND_NAMES.length];
        this.gridSizes = new int[6];
        this.corners = new double[16];
        Arrays.fill(this.corners, Double.NaN);
    }

    void read(BufferedReader reader) throws IOException, DataStoreException {
        String line;
        this.newCoverage(true);
        while ((line = reader.readLine()) != null) {
            int end = CharSequences.skipTrailingWhitespaces(line, 0, line.length());
            int start = CharSequences.skipLeadingWhitespaces(line, 0, end);
            if (start >= end || line.charAt(start) == '#') continue;
            int separator = line.indexOf(61, start);
            if (separator < 0) {
                if (end - start != END.length() || !line.regionMatches(true, start, END, 0, END.length())) {
                    throw new DataStoreException(this.errors().getString((short)109, line));
                }
                return;
            }
            String key = line.substring(start, CharSequences.skipTrailingWhitespaces(line, start, separator)).toUpperCase(Locale.US);
            int band = 0;
            int i = key.length();
            while (--i >= 0) {
                char c = key.charAt(i);
                if (c >= '0' && c <= '9') continue;
                if (c != '_' || !key.regionMatches(i - BAND_SUFFIX.length(), BAND_SUFFIX, 0, BAND_SUFFIX.length())) break;
                try {
                    band = Integer.parseInt(key.substring(++i));
                    key = key.substring(0, i);
                }
                catch (NumberFormatException e) {
                    this.warning(key, reader, e);
                }
                break;
            }
            if (end - (start = CharSequences.skipLeadingWhitespaces(line, separator + 1, end)) >= 2 && line.charAt(start) == '\"' && line.charAt(end - 1) == '\"') {
                start = CharSequences.skipLeadingWhitespaces(line, start + 1, --end);
                end = CharSequences.skipTrailingWhitespaces(line, start, end);
            }
            try {
                this.parseKeyValuePair(key, band, line.substring(start, end));
            }
            catch (IllegalArgumentException | DateTimeException e) {
                this.warning(key, reader, e);
            }
        }
        this.listeners.warning(this.errors().getString((short)137, this.getFilename()));
    }

    private Double parseDouble(String value) throws NumberFormatException {
        return this.shared(Double.valueOf(value));
    }

    private void parseCorner(int index, String value) throws NumberFormatException {
        this.corners[index] = Double.parseDouble(value);
    }

    private void parseGridSize(int index, String value) throws NumberFormatException {
        this.gridSizes[index] = Integer.parseUnsignedInt(value);
    }

    private void parseKeyValuePair(String key, int band, String value) throws IllegalArgumentException, DateTimeException, DataStoreException {
        switch (key) {
            case "GROUP": {
                this.group = value;
                break;
            }
            case "END_GROUP": {
                this.group = null;
                break;
            }
            case "ORIGIN": {
                Matcher m = CREDIT.matcher(value);
                if (m.find()) {
                    this.newParty(MetadataBuilder.PartyType.ORGANISATION);
                    this.addAuthor(value.substring(m.end()));
                }
                this.addCredits(value);
                break;
            }
            case "REQUEST_ID": {
                this.addAcquisitionRequirement(null, value);
                break;
            }
            case "LANDSAT_SCENE_ID": {
                this.addTitleOrIdentifier(value, MetadataBuilder.Scope.ALL);
                break;
            }
            case "FILE_DATE": {
                this.addCitationDate(StandardDateFormat.toDate(OffsetDateTime.parse(value)), DateType.CREATION, MetadataBuilder.Scope.ALL);
                break;
            }
            case "DATA_TYPE": {
                this.setProcessingLevelCode("Landsat", value);
                break;
            }
            case "ELEVATION_SOURCE": {
                this.addSource(value, ScopeCode.MODEL, (CharSequence)Vocabulary.formatInternational((short)146));
                break;
            }
            case "OUTPUT_FORMAT": {
                if ("GeoTIFF".equalsIgnoreCase(value)) {
                    try {
                        value = "GeoTIFF";
                        this.setFormat(value);
                        break;
                    }
                    catch (MetadataStoreException e) {
                        this.warning(key, null, e);
                    }
                }
                this.addFormatName(value);
                break;
            }
            case "SPACECRAFT_ID": {
                this.addPlatform(null, value);
                break;
            }
            case "SENSOR_ID": {
                this.addInstrument(null, value);
                break;
            }
            case "DATE_ACQUIRED": {
                LocalDate date = LocalDate.parse(value);
                if (this.sceneTime instanceof OffsetTime) {
                    this.sceneTime = date.atTime((OffsetTime)this.sceneTime);
                    break;
                }
                if (date.equals(this.sceneTime)) break;
                this.flushSceneTime();
                this.sceneTime = date;
                break;
            }
            case "SCENE_CENTER_TIME": {
                OffsetTime time = OffsetTime.parse(value);
                if (this.sceneTime instanceof LocalDate) {
                    this.sceneTime = ((LocalDate)this.sceneTime).atTime(time);
                    break;
                }
                this.sceneTime = time;
                break;
            }
            case "CORNER_UL_LON_PRODUCT": {
                this.parseCorner(8, value);
                break;
            }
            case "CORNER_UL_LAT_PRODUCT": {
                this.parseCorner(9, value);
                break;
            }
            case "CORNER_UR_LON_PRODUCT": {
                this.parseCorner(10, value);
                break;
            }
            case "CORNER_UR_LAT_PRODUCT": {
                this.parseCorner(11, value);
                break;
            }
            case "CORNER_LL_LON_PRODUCT": {
                this.parseCorner(12, value);
                break;
            }
            case "CORNER_LL_LAT_PRODUCT": {
                this.parseCorner(13, value);
                break;
            }
            case "CORNER_LR_LON_PRODUCT": {
                this.parseCorner(14, value);
                break;
            }
            case "CORNER_LR_LAT_PRODUCT": {
                this.parseCorner(15, value);
                break;
            }
            case "CORNER_UL_PROJECTION_X_PRODUCT": {
                this.parseCorner(0, value);
                break;
            }
            case "CORNER_UL_PROJECTION_Y_PRODUCT": {
                this.parseCorner(1, value);
                break;
            }
            case "CORNER_UR_PROJECTION_X_PRODUCT": {
                this.parseCorner(2, value);
                break;
            }
            case "CORNER_UR_PROJECTION_Y_PRODUCT": {
                this.parseCorner(3, value);
                break;
            }
            case "CORNER_LL_PROJECTION_X_PRODUCT": {
                this.parseCorner(4, value);
                break;
            }
            case "CORNER_LL_PROJECTION_Y_PRODUCT": {
                this.parseCorner(5, value);
                break;
            }
            case "CORNER_LR_PROJECTION_X_PRODUCT": {
                this.parseCorner(6, value);
                break;
            }
            case "CORNER_LR_PROJECTION_Y_PRODUCT": {
                this.parseCorner(7, value);
                break;
            }
            case "PANCHROMATIC_LINES": {
                this.parseGridSize(1, value);
                break;
            }
            case "PANCHROMATIC_SAMPLES": {
                this.parseGridSize(0, value);
                break;
            }
            case "REFLECTIVE_LINES": {
                this.parseGridSize(3, value);
                break;
            }
            case "REFLECTIVE_SAMPLES": {
                this.parseGridSize(2, value);
                break;
            }
            case "THERMAL_LINES": {
                this.parseGridSize(5, value);
                break;
            }
            case "THERMAL_SAMPLES": {
                this.parseGridSize(4, value);
                break;
            }
            case "GRID_CELL_SIZE_PANCHROMATIC": 
            case "GRID_CELL_SIZE_REFLECTIVE": 
            case "GRID_CELL_SIZE_THERMAL": {
                this.addResolution(Double.parseDouble(value));
                break;
            }
            case "FILE_NAME_BAND_": {
                DefaultBand db = this.band(key, band);
                if (db == null) break;
                db.getNames().add(new DefaultIdentifier(value));
                break;
            }
            case "METADATA_FILE_NAME": {
                if (this.filename != null) break;
                this.filename = value;
                break;
            }
            case "CLOUD_COVER": {
                double v = Double.parseDouble(value);
                if (!(v >= 0.0)) break;
                this.setCloudCoverPercentage(v);
                break;
            }
            case "SUN_AZIMUTH": {
                this.setIlluminationAzimuthAngle(Double.parseDouble(value));
                break;
            }
            case "SUN_ELEVATION": {
                this.setIlluminationElevationAngle(Double.parseDouble(value));
                break;
            }
            case "QUANTIZE_CAL_MIN_BAND_": {
                Double v = this.parseDouble(value);
                DefaultBand db = this.band(key, band);
                if (db == null) break;
                db.setMinValue(v);
                break;
            }
            case "QUANTIZE_CAL_MAX_BAND_": {
                Double v = this.parseDouble(value);
                DefaultBand db = this.band(key, band);
                if (db == null) break;
                db.setMaxValue(v);
                break;
            }
            case "RADIANCE_MULT_BAND_": {
                this.setTransferFunction(key, band, true, value);
                break;
            }
            case "RADIANCE_ADD_BAND_": {
                this.setTransferFunction(key, band, false, value);
                break;
            }
            case "MAP_PROJECTION": {
                if ("UTM".equalsIgnoreCase(value)) {
                    this.projection = null;
                    break;
                }
                if (!"PS".equalsIgnoreCase(value)) break;
                try {
                    this.projection = this.factories.getMathTransformFactory().getDefaultParameters("EPSG:9829");
                    this.utmZone = (short)-1;
                    break;
                }
                catch (NoSuchIdentifierException e) {
                    throw new DataStoreReferencingException(e);
                }
            }
            case "DATUM": {
                this.datum = CommonCRS.valueOf(Strings.toUpperCase(value, Characters.Filter.LETTERS_AND_DIGITS));
                break;
            }
            case "UTM_ZONE": {
                if (this.utmZone != 0) break;
                this.utmZone = Short.parseShort(value);
                break;
            }
            case "VERTICAL_LON_FROM_POLE": {
                this.setProjectionParameter(key, "central_meridian", value, false);
                break;
            }
            case "TRUE_SCALE_LAT": {
                this.setProjectionParameter(key, "standard_parallel_1", value, false);
                break;
            }
            case "FALSE_EASTING": {
                this.setProjectionParameter(key, "false_easting", value, true);
                break;
            }
            case "FALSE_NORTHING": {
                this.setProjectionParameter(key, "false_northing", value, true);
            }
        }
    }

    private void setTransferFunction(String key, int band, boolean isScale, String value) {
        Double v = this.parseDouble(value);
        DefaultBand db = this.band(key, band);
        if (db != null) {
            db.setTransferFunctionType(TransferFunctionType.LINEAR);
            if (isScale) {
                db.setScaleFactor(v);
            } else {
                db.setOffset(v);
            }
        }
    }

    private DefaultBand band(String key, int index) {
        DefaultBand band;
        if (index < 1 || index > BAND_NAMES.length) {
            this.listeners.warning(this.errors().getString((short)144, key + index, index));
            return null;
        }
        if ((band = this.bands[--index]) == null) {
            band = new DefaultBand();
            band.setDescription(new SimpleInternationalString(BAND_NAMES[index]));
            band.setPeakResponse(Double.valueOf(WAVELENGTHS[index]));
            band.setBoundUnits(Units.NANOMETRE);
            this.bands[index] = band;
        }
        return band;
    }

    private void setProjectionParameter(String key, String name, String value, boolean isLinear) {
        if (this.projection != null) {
            this.projection.parameter(name).setValue(Double.parseDouble(value), isLinear ? Units.METRE : Units.DEGREE);
        } else {
            this.listeners.warning(this.errors().getString((short)141, this.filename, key));
        }
    }

    private void flushSceneTime() {
        Temporal st = this.sceneTime;
        if (st != null) {
            this.sceneTime = null;
            Date t = StandardDateFormat.toDate(st);
            this.addAcquisitionTime(t);
            try {
                this.addTemporalExtent(t, t);
            }
            catch (UnsupportedOperationException e) {
                this.warning(null, null, e);
            }
        }
    }

    private boolean toBoundingBox(int base) {
        double xmin = Double.POSITIVE_INFINITY;
        double ymin = Double.POSITIVE_INFINITY;
        double xmax = Double.NEGATIVE_INFINITY;
        double ymax = Double.NEGATIVE_INFINITY;
        int i = base + 8;
        while (--i >= base) {
            double v = this.corners[i];
            if (v < ymin) {
                ymin = v;
            }
            if (v > ymax) {
                ymax = v;
            }
            if ((v = this.corners[--i]) < xmin) {
                xmin = v;
            }
            if (!(v > xmax)) continue;
            xmax = v;
        }
        if (xmin < xmax && ymin < ymax) {
            this.corners[base] = xmin;
            this.corners[++base] = xmax;
            this.corners[++base] = ymin;
            this.corners[++base] = ymax;
            return true;
        }
        return false;
    }

    final Metadata getMetadata() throws FactoryException {
        this.addLanguage(Locale.ENGLISH, MetadataBuilder.Scope.METADATA);
        this.addResourceScope(ScopeCode.valueOf((String)"COVERAGE"), null);
        this.addTopicCategory(TopicCategory.GEOSCIENTIFIC_INFORMATION);
        try {
            this.flushSceneTime();
        }
        catch (DateTimeException e) {
            this.warning(null, null, e);
        }
        if (this.datum != null) {
            if (this.utmZone > 0) {
                this.addReferenceSystem((ReferenceSystem)this.datum.universal(1.0, TransverseMercator.Zoner.UTM.centralMeridian(this.utmZone)));
            }
            if (this.projection != null) {
                double sp = this.projection.parameter("standard_parallel_1").doubleValue();
                ProjectedCRS crs = (ProjectedCRS)CRS.forCode("EPSG:" + (sp >= 0.0 ? 3995 : 3031));
                if (this.datum != CommonCRS.WGS84 || Math.abs(sp) != 71.0 || this.projection.parameter("false_easting").doubleValue() != 0.0 || this.projection.parameter("false_northing").doubleValue() != 0.0 || this.projection.parameter("central_meridian").doubleValue() != 0.0) {
                    crs = ((GeodeticObjectBuilder)new GeodeticObjectBuilder(this.listeners.getLocale()).addName("Polar stereographic")).setConversion(this.projection).createProjectedCRS(this.datum.geographic(), crs.getCoordinateSystem());
                }
                this.addReferenceSystem((ReferenceSystem)crs);
            }
        }
        if (this.toBoundingBox(8)) {
            this.addExtent(this.corners, 8);
        }
        for (int i = 0; i < this.gridSizes.length; i += 2) {
            int width = this.gridSizes[i];
            int height = this.gridSizes[i + 1];
            if ((width | height) == 0) continue;
            this.newGridRepresentation(MetadataBuilder.GridType.GEORECTIFIED);
            this.setAxisName(0, DimensionNameType.SAMPLE);
            this.setAxisName(1, DimensionNameType.LINE);
            this.setAxisSize(0, Integer.toUnsignedLong(width));
            this.setAxisSize(1, Integer.toUnsignedLong(height));
        }
        this.setISOStandards(true);
        DefaultMetadata result = this.build(false);
        if (result != null) {
            DefaultCoverageDescription content = (DefaultCoverageDescription)CollectionsExt.singletonOrNull(result.getContentInfo());
            if (content != null) {
                DefaultAttributeGroup[] groups = new DefaultAttributeGroup[3];
                for (int i = 0; i < this.bands.length; ++i) {
                    DefaultBand band = this.bands[i];
                    if (band == null) continue;
                    int gi = 2692437 >>> 2 * i & 3;
                    DefaultAttributeGroup group = groups[gi];
                    if (group == null) {
                        group = new DefaultAttributeGroup(CoverageContentType.PHYSICAL_MEASUREMENT, null);
                        content.getAttributeGroups().add(group);
                        groups[gi] = group;
                    }
                    group.getAttributes().add(band);
                }
            }
            result.transitionTo(ModifiableMetadata.State.FINAL);
        }
        return result;
    }

    private String getFilename() {
        return this.filename != null ? this.filename : Vocabulary.getResources(this.listeners.getLocale()).getString((short)108);
    }

    private String toLongName(String key) {
        if (this.group != null) {
            key = this.group + ':' + key;
        }
        return key;
    }

    private void warning(String key, BufferedReader reader, Exception e) {
        if (key != null) {
            String file = this.getFilename();
            if (reader instanceof LineNumberReader) {
                file = file + ":" + ((LineNumberReader)reader).getLineNumber();
            }
            key = this.errors().getString((short)11, this.toLongName(key), file);
        }
        this.listeners.warning(key, e);
    }

    private Errors errors() {
        return Errors.getResources(this.listeners.getLocale());
    }
}

