/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.sis.internal.referencing.LazySet;
import org.apache.sis.internal.storage.StoreMetadata;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.ProbeProviderPair;
import org.apache.sis.storage.ProbeResult;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.UnsupportedStorageException;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;

final class DataStoreRegistry {
    private final ServiceLoader<DataStoreProvider> loader;

    public DataStoreRegistry() {
        this.loader = DefaultFactories.createServiceLoader(DataStoreProvider.class);
    }

    public DataStoreRegistry(ClassLoader loader) {
        ArgumentChecks.ensureNonNull("loader", loader);
        this.loader = ServiceLoader.load(DataStoreProvider.class, loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DataStoreProvider> providers() {
        ServiceLoader<DataStoreProvider> serviceLoader = this.loader;
        synchronized (serviceLoader) {
            final Iterator<DataStoreProvider> providers = this.loader.iterator();
            return new LazySet<DataStoreProvider>(new Iterator<DataStoreProvider>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean hasNext() {
                    ServiceLoader serviceLoader = DataStoreRegistry.this.loader;
                    synchronized (serviceLoader) {
                        return providers.hasNext();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public DataStoreProvider next() {
                    ServiceLoader serviceLoader = DataStoreRegistry.this.loader;
                    synchronized (serviceLoader) {
                        return (DataStoreProvider)providers.next();
                    }
                }
            });
        }
    }

    public String probeContentType(Object storage) throws DataStoreException {
        ArgumentChecks.ensureNonNull("storage", storage);
        ProbeProviderPair p = this.lookup(storage, false);
        return p != null ? p.probe.getMimeType() : null;
    }

    public DataStore open(Object storage) throws UnsupportedStorageException, DataStoreException {
        ArgumentChecks.ensureNonNull("storage", storage);
        return this.lookup((Object)storage, (boolean)true).store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProbeProviderPair lookup(Object storage, boolean open) throws DataStoreException {
        StorageConnector connector = storage instanceof StorageConnector ? (StorageConnector)storage : new StorageConnector(storage);
        String extension = connector.getFileExtension();
        Boolean matchCondition = extension != null && !extension.isEmpty() ? Boolean.TRUE : null;
        LinkedList<ProbeProviderPair> needMoreBytes = new LinkedList<ProbeProviderPair>();
        ProbeProviderPair selected = null;
        try {
            block9: do {
                DataStoreProvider provider;
                Iterator<DataStoreProvider> providers;
                ServiceLoader<DataStoreProvider> serviceLoader = this.loader;
                synchronized (serviceLoader) {
                    providers = this.loader.iterator();
                    provider = providers.hasNext() ? providers.next() : null;
                }
                while (provider != null) {
                    Object probe;
                    boolean accept = true;
                    if (matchCondition != null) {
                        StoreMetadata md = provider.getClass().getAnnotation(StoreMetadata.class);
                        boolean bl = accept = (md != null && ArraysExt.containsIgnoreCase(md.fileSuffixes(), extension)) == matchCondition;
                    }
                    if (accept) {
                        probe = provider.probeContent(connector);
                        if (((ProbeResult)probe).isSupported()) {
                            selected = new ProbeProviderPair(provider, (ProbeResult)probe);
                            break block9;
                        }
                        if (ProbeResult.INSUFFICIENT_BYTES.equals(probe)) {
                            needMoreBytes.add(new ProbeProviderPair(provider, (ProbeResult)probe));
                        } else if (ProbeResult.UNDETERMINED.equals(probe) && selected == null) {
                            selected = new ProbeProviderPair(provider, (ProbeResult)probe);
                        }
                    }
                    probe = this.loader;
                    synchronized (probe) {
                        provider = providers.hasNext() ? providers.next() : null;
                    }
                }
                while (!needMoreBytes.isEmpty() && connector.prefetch()) {
                    Iterator it = needMoreBytes.iterator();
                    while (it.hasNext()) {
                        ProbeProviderPair p = (ProbeProviderPair)it.next();
                        p.probe = p.provider.probeContent(connector);
                        if (p.probe.isSupported()) {
                            selected = p;
                            break block9;
                        }
                        if (ProbeResult.INSUFFICIENT_BYTES.equals(p.probe)) continue;
                        if (selected == null && ProbeResult.UNDETERMINED.equals(p.probe)) {
                            selected = p;
                        }
                        it.remove();
                    }
                }
            } while (matchCondition != null && !(matchCondition = Boolean.valueOf(matchCondition == false)).booleanValue());
            if (open && selected != null) {
                selected.store = selected.provider.open(connector);
                connector = null;
            }
        }
        finally {
            if (connector != null && connector != storage) {
                connector.closeAllExcept(null);
            }
        }
        if (open && selected == null) {
            String name = connector.getStorageName();
            throw new UnsupportedStorageException(null, 14, name);
        }
        return selected;
    }
}

