/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.geometry.MismatchedReferenceSystemException;
import org.apache.sis.internal.referencing.DirectPositionView;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.referencing.operation.transform.IterationStrategy;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

class SpecializableTransform
extends AbstractMathTransform
implements Serializable {
    private static final long serialVersionUID = -7379277748632094312L;
    private final MathTransform global;
    private final SubArea[] domains;
    private MathTransform inverse;

    SpecializableTransform(MathTransform global, Map<Envelope, MathTransform> specializations) {
        this.global = global;
        int sourceDim = global.getSourceDimensions();
        int targetDim = global.getTargetDimensions();
        ArrayList<SubArea> areas = new ArrayList<SubArea>(specializations.size());
        for (Map.Entry<Envelope, MathTransform> entry : specializations.entrySet()) {
            MathTransform tr = entry.getValue();
            SpecializableTransform.ensureDimensionMatches(0, sourceDim, tr.getSourceDimensions());
            SpecializableTransform.ensureDimensionMatches(1, targetDim, tr.getTargetDimensions());
            SubArea[] inherited = null;
            if (tr instanceof SpecializableTransform) {
                inherited = ((SpecializableTransform)tr).domains;
                tr = ((SpecializableTransform)tr).global;
            }
            SubArea area = new SubArea(entry.getKey(), tr);
            SpecializableTransform.addSpecialization(area, areas, sourceDim);
            if (inherited == null) continue;
            for (SubArea other : inherited) {
                SubArea e = new SubArea(other, other.transform);
                e.intersect(area);
                SpecializableTransform.addSpecialization(e, areas, sourceDim);
            }
        }
        this.domains = areas.toArray(new SubArea[areas.size()]);
        SubArea.uniformize(this.domains);
    }

    private static void ensureDimensionMatches(int type, int expected, int actual) {
        if (expected != actual) {
            throw new MismatchedDimensionException(Resources.format((short)37, type, expected, actual));
        }
    }

    private static void addSpecialization(SubArea area, List<SubArea> domains, int dim) {
        if (!area.isEmpty()) {
            if (area.getDimension() != dim) {
                throw new MismatchedDimensionException(Errors.format((short)81, "envelope", dim, area.getDimension()));
            }
            for (SubArea previous : domains) {
                if (!previous.addSpecialization(area)) continue;
                return;
            }
            for (SubArea previous : domains) {
                if (!area.intersects(previous)) continue;
                throw new IllegalArgumentException("Current implementation does not accept overlapping envelopes.");
            }
            domains.add(area);
        }
    }

    @Override
    public final int getSourceDimensions() {
        return this.global.getSourceDimensions();
    }

    @Override
    public final int getTargetDimensions() {
        return this.global.getTargetDimensions();
    }

    private MathTransform forDomain(SubArea domain) {
        return domain != null ? domain.transform : this.global;
    }

    @Override
    public final DirectPosition transform(DirectPosition ptSrc, DirectPosition ptDst) throws TransformException {
        return this.forDomain(SubArea.find(this.domains, ptSrc)).transform(ptSrc, ptDst);
    }

    @Override
    public final Matrix derivative(DirectPosition point) throws TransformException {
        return this.forDomain(SubArea.find(this.domains, point)).derivative(point);
    }

    @Override
    public final Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws TransformException {
        Matrix derivative;
        DirectPositionView.Double pos = new DirectPositionView.Double(srcPts, srcOff, this.global.getSourceDimensions());
        MathTransform tr = this.forDomain(SubArea.find(this.domains, (DirectPosition)pos));
        if (tr instanceof AbstractMathTransform) {
            return ((AbstractMathTransform)tr).transform(srcPts, srcOff, dstPts, dstOff, derivate);
        }
        Matrix matrix = derivative = derivate ? tr.derivative((DirectPosition)pos) : null;
        if (dstPts != null) {
            tr.transform(srcPts, srcOff, dstPts, dstOff, 1);
        }
        return derivative;
    }

    private void transform(TransformCall transform, DirectPositionView src, int dstOff, int srcInc, int dstInc, int numPts) throws TransformException {
        boolean downard = srcInc < 0;
        SubArea domain = SubArea.find(this.domains, (DirectPosition)src);
        while (numPts > 0) {
            MathTransform tr;
            int srcOff = src.offset;
            if (domain == null) {
                tr = this.global;
                do {
                    src.offset += srcInc;
                } while (--numPts > 0 && (domain = SubArea.find(this.domains, (DirectPosition)src)) == null);
            } else {
                SubArea previous = domain;
                tr = domain.transform;
                do {
                    src.offset += srcInc;
                } while (--numPts > 0 && (domain = SubArea.find(domain, (DirectPosition)src)) == previous);
                if (domain == null) {
                    domain = SubArea.find(this.domains, (DirectPosition)src);
                }
            }
            int num = (src.offset - srcOff) / srcInc;
            int dstLow = dstOff;
            dstOff += dstInc * num;
            if (downard) {
                srcOff = src.offset - srcInc;
                dstLow = dstOff - dstInc;
            }
            transform.apply(tr, srcOff, dstLow, num);
        }
    }

    @Override
    public final void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        int srcInc = this.getSourceDimensions();
        int dstInc = this.getTargetDimensions();
        if (srcPts == dstPts) {
            switch (IterationStrategy.suggest(srcOff, srcInc, dstOff, dstInc, numPts)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    srcOff += (numPts - 1) * srcInc;
                    srcInc = -srcInc;
                    dstOff += (numPts - 1) * dstInc;
                    dstInc = -dstInc;
                    break;
                }
                default: {
                    srcPts = Arrays.copyOfRange(srcPts, srcOff, srcOff + numPts * srcInc);
                    srcOff = 0;
                }
            }
        }
        double[] refPts = srcPts;
        this.transform((tr, src, dst, num) -> tr.transform(refPts, src, dstPts, dst, num), new DirectPositionView.Double(srcPts, srcOff, Math.abs(srcInc)), dstOff, srcInc, dstInc, numPts);
    }

    @Override
    public final void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws TransformException {
        int srcInc = this.getSourceDimensions();
        int dstInc = this.getTargetDimensions();
        if (srcPts == dstPts) {
            switch (IterationStrategy.suggest(srcOff, srcInc, dstOff, dstInc, numPts)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    srcOff += (numPts - 1) * srcInc;
                    srcInc = -srcInc;
                    dstOff += (numPts - 1) * dstInc;
                    dstInc = -dstInc;
                    break;
                }
                default: {
                    srcPts = Arrays.copyOfRange(srcPts, srcOff, srcOff + numPts * srcInc);
                    srcOff = 0;
                }
            }
        }
        float[] refPts = srcPts;
        this.transform((tr, src, dst, num) -> tr.transform(refPts, src, dstPts, dst, num), new DirectPositionView.Float(srcPts, srcOff, Math.abs(srcInc)), dstOff, srcInc, dstInc, numPts);
    }

    @Override
    public final void transform(double[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws TransformException {
        int srcDim = this.getSourceDimensions();
        int dstDim = this.getTargetDimensions();
        this.transform((tr, src, dst, num) -> tr.transform(srcPts, src, dstPts, dst, num), new DirectPositionView.Double(srcPts, srcOff, srcDim), dstOff, srcDim, dstDim, numPts);
    }

    @Override
    public final void transform(float[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        int srcDim = this.getSourceDimensions();
        int dstDim = this.getTargetDimensions();
        this.transform((tr, src, dst, num) -> tr.transform(srcPts, src, dstPts, dst, num), new DirectPositionView.Float(srcPts, srcOff, srcDim), dstOff, srcDim, dstDim, numPts);
    }

    @Override
    protected final int computeHashCode() {
        return super.computeHashCode() + 7 * this.global.hashCode() ^ Arrays.hashCode(this.domains);
    }

    @Override
    public final boolean equals(Object object, ComparisonMode mode) {
        if (super.equals(object, mode)) {
            SpecializableTransform other = (SpecializableTransform)object;
            return Utilities.deepEquals(this.global, other.global, mode) && Utilities.deepEquals(this.domains, other.domains, mode);
        }
        return false;
    }

    @Override
    protected final String formatTo(Formatter formatter) {
        formatter.newLine();
        formatter.append(this.global);
        for (SubArea domain : this.domains) {
            SubArea.format(domain, formatter);
        }
        formatter.setInvalidWKT(SpecializableTransform.class, null);
        return "Specializable_MT";
    }

    @Override
    public synchronized MathTransform inverse() throws NoninvertibleTransformException {
        if (this.inverse == null) {
            this.inverse = this.createInverse();
        }
        return this.inverse;
    }

    Inverse createInverse() throws NoninvertibleTransformException {
        return new Inverse(this);
    }

    static class Inverse
    extends AbstractMathTransform.Inverse
    implements Serializable {
        private static final long serialVersionUID = 1060617594604917167L;
        private final SpecializableTransform forward;
        private final MathTransform global;

        Inverse(SpecializableTransform forward) throws NoninvertibleTransformException {
            this.forward = forward;
            this.global = forward.global.inverse();
            for (SubArea domain : forward.domains) {
                SubArea.createInverse(domain);
            }
        }

        @Override
        public MathTransform inverse() {
            return this.forward;
        }

        @Override
        public final DirectPosition transform(DirectPosition ptSrc, DirectPosition ptDst) throws TransformException {
            double[] source = ptSrc.getCoordinate();
            ptDst = this.global.transform(ptSrc, ptDst);
            SubArea domain = SubArea.find(this.forward.domains, ptDst);
            if (domain != null) {
                ptDst = domain.inverse.transform((DirectPosition)new DirectPositionView.Double(source), ptDst);
            }
            return ptDst;
        }

        @Override
        public final Matrix derivative(DirectPosition point) throws TransformException {
            return this.transform(point.getCoordinate(), 0, null, 0, true);
        }

        @Override
        public final Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws TransformException {
            Matrix derivative;
            int srcInc = this.global.getSourceDimensions();
            int dstInc = this.global.getTargetDimensions();
            if (dstPts == null) {
                dstPts = new double[dstInc];
                dstOff = 0;
            } else if (srcPts == dstPts && srcOff + srcInc > dstOff && srcOff < dstOff + dstInc) {
                srcPts = Arrays.copyOfRange(srcPts, srcOff, srcInc);
                srcOff = 0;
            }
            MathTransform tr = this.global;
            boolean secondTry = false;
            do {
                if (tr instanceof AbstractMathTransform) {
                    derivative = ((AbstractMathTransform)tr).transform(srcPts, srcOff, dstPts, dstOff, derivate);
                } else {
                    tr.transform(srcPts, srcOff, dstPts, dstOff, 1);
                    Matrix matrix = derivative = derivate ? tr.derivative((DirectPosition)new DirectPositionView.Double(srcPts, srcOff, srcInc)) : null;
                }
                if (secondTry) break;
                SubArea domain = SubArea.find(this.forward.domains, (DirectPosition)new DirectPositionView.Double(dstPts, dstOff, dstInc));
                if (domain == null) continue;
                tr = domain.inverse;
                secondTry = true;
            } while (secondTry);
            return derivative;
        }

        private void transform(TransformCall transform, double[] dstPts, int srcOff, int dstOff, int srcInc, int dstInc, int numPts) throws TransformException {
            SubArea[] domains = this.forward.domains;
            transform.apply(this.global, srcOff, dstOff, numPts);
            DirectPositionView.Double dst = new DirectPositionView.Double(dstPts, dstOff, dstInc);
            while (numPts > 0) {
                SubArea domain = SubArea.find(domains, (DirectPosition)dst);
                if (domain == null) {
                    dst.offset += dstInc;
                    --numPts;
                    continue;
                }
                do {
                    SubArea specialized = domain;
                    int num = (dst.offset - dstOff) / dstInc;
                    srcOff += num * srcInc;
                    dstOff = dst.offset;
                    do {
                        dst.offset += dstInc;
                        if (--numPts > 0) continue;
                        domain = null;
                        break;
                    } while ((domain = SubArea.find(domain, (DirectPosition)dst)) == specialized);
                    num = (dst.offset - dstOff) / dstInc;
                    transform.apply(specialized.inverse, srcOff, dstOff, num);
                    srcOff += srcInc * num;
                    dstOff = dst.offset;
                } while (domain != null);
            }
        }

        @Override
        public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
            int srcEnd;
            if (numPts <= 0) {
                return;
            }
            int srcInc = this.global.getSourceDimensions();
            int dstInc = this.global.getTargetDimensions();
            if (srcPts == dstPts && ((srcEnd = srcOff + numPts * srcInc) > dstOff || dstOff + numPts * dstInc > srcOff)) {
                srcPts = Arrays.copyOfRange(srcPts, srcOff, srcEnd);
                srcOff = 0;
            }
            double[] refPts = srcPts;
            this.transform((tr, src, dst, num) -> tr.transform(refPts, src, dstPts, dst, num), dstPts, srcOff, dstOff, srcInc, dstInc, numPts);
        }

        @Override
        public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws TransformException {
            if (numPts <= 0) {
                return;
            }
            int srcInc = this.global.getSourceDimensions();
            int dstInc = this.global.getTargetDimensions();
            double[] buffer = new double[numPts * dstInc];
            this.transform((tr, src, dst, num) -> tr.transform(srcPts, src, buffer, dst, num), buffer, srcOff, 0, srcInc, dstInc, numPts);
            numPts *= dstInc;
            for (int i = 0; i < numPts; ++i) {
                dstPts[dstOff++] = (float)buffer[i];
            }
        }

        @Override
        public void transform(double[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws TransformException {
            if (numPts <= 0) {
                return;
            }
            int srcInc = this.global.getSourceDimensions();
            int dstInc = this.global.getTargetDimensions();
            double[] buffer = new double[numPts * dstInc];
            this.transform((tr, src, dst, num) -> tr.transform(srcPts, src, buffer, dst, num), buffer, srcOff, 0, srcInc, dstInc, numPts);
            numPts *= dstInc;
            for (int i = 0; i < numPts; ++i) {
                dstPts[dstOff++] = (float)buffer[i];
            }
        }

        @Override
        public void transform(float[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
            if (numPts <= 0) {
                return;
            }
            int srcInc = this.global.getSourceDimensions();
            int dstInc = this.global.getTargetDimensions();
            this.transform((tr, src, dst, num) -> tr.transform(srcPts, src, dstPts, dst, num), dstPts, srcOff, dstOff, srcInc, dstInc, numPts);
        }
    }

    @FunctionalInterface
    private static interface TransformCall {
        public void apply(MathTransform var1, int var2, int var3, int var4) throws TransformException;
    }

    private static final class SubArea
    extends GeneralEnvelope {
        private static final long serialVersionUID = 4197316795428796526L;
        final MathTransform transform;
        MathTransform inverse;
        private SubArea specialization;

        SubArea(Envelope area, MathTransform transform) {
            super(area);
            this.transform = transform;
        }

        boolean addSpecialization(SubArea candidate) {
            if (this.specialization == null) {
                if (!this.contains(candidate)) {
                    return false;
                }
            } else if (!candidate.addSpecialization(this.specialization)) {
                return this.specialization.addSpecialization(candidate);
            }
            this.specialization = candidate;
            return true;
        }

        static void uniformize(SubArea[] domains) {
            CoordinateReferenceSystem common = null;
            for (SubArea area : domains) {
                do {
                    CoordinateReferenceSystem crs = area.getCoordinateReferenceSystem();
                    if (common == null) {
                        common = crs;
                        continue;
                    }
                    if (crs == null || Utilities.equalsIgnoreMetadata(common, crs)) continue;
                    throw new MismatchedReferenceSystemException(Errors.format((short)78));
                } while ((area = area.specialization) != null);
            }
            for (SubArea area : domains) {
                do {
                    area.setCoordinateReferenceSystem(common);
                } while ((area = area.specialization) != null);
            }
        }

        static void createInverse(SubArea area) throws NoninvertibleTransformException {
            do {
                area.inverse = area.transform.inverse();
            } while ((area = area.specialization) != null);
        }

        static SubArea find(SubArea[] domains, DirectPosition pos) {
            for (SubArea area : domains) {
                if (!area.contains(pos)) continue;
                SubArea next = area.specialization;
                while (next != null && next.contains(pos)) {
                    area = next;
                    next = next.specialization;
                }
                return area;
            }
            return null;
        }

        static SubArea find(SubArea area, DirectPosition pos) {
            SubArea found = null;
            while (area.contains(pos)) {
                found = area;
                area = area.specialization;
                if (area != null) continue;
                break;
            }
            return found;
        }

        static void format(SubArea area, Formatter formatter) {
            while (area != null) {
                formatter.newLine();
                formatter.append(area);
                formatter.newLine();
                formatter.append(area.transform);
                area = area.specialization;
            }
        }

        @Override
        public int hashCode() {
            int code = super.hashCode() ^ this.transform.hashCode();
            if (this.specialization != null) {
                code += 37 * this.specialization.hashCode();
            }
            return code;
        }

        @Override
        public boolean equals(Object obj) {
            if (super.equals(obj)) {
                SubArea other = (SubArea)obj;
                return this.transform.equals(other.transform) && Objects.equals(this.specialization, other.specialization);
            }
            return false;
        }

        @Override
        protected String formatTo(Formatter formatter) {
            super.formatTo(formatter);
            return "Domain";
        }
    }
}

