/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.util.Arrays;
import org.apache.sis.internal.referencing.ExtendedPrecisionMatrix;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.AbstractLinearTransform;
import org.apache.sis.referencing.operation.transform.IterationStrategy;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.operation.Matrix;

final class ScaleTransform
extends AbstractLinearTransform
implements ExtendedPrecisionMatrix {
    private static final long serialVersionUID = 8527439133082104085L;
    private final double[] factors;
    private final double[] errors;
    private final int numDroppedDimensions;

    ScaleTransform(double[] factors) {
        this.factors = (double[])factors.clone();
        this.errors = null;
        this.numDroppedDimensions = 0;
    }

    ScaleTransform(int numRow, int numCol, double[] elements) {
        this.numDroppedDimensions = numCol - numRow;
        int n = numRow * numCol;
        int tgtDim = numRow - 1;
        this.factors = new double[tgtDim];
        double[] errors = null;
        int lastError = -1;
        for (int i = 0; i < tgtDim; ++i) {
            double e;
            int j = numCol * i + i;
            this.factors[i] = elements[j];
            if ((j += n) >= elements.length || (e = elements[j]) == 0.0) continue;
            if (errors == null) {
                errors = new double[tgtDim];
            }
            errors[i] = e;
            lastError = i;
        }
        this.errors = ArraysExt.resize(errors, lastError + 1);
    }

    @Override
    public double[] getExtendedElements() {
        int numCol = this.getNumCol();
        int n = this.getNumRow() * numCol;
        double[] elements = new double[this.errors == null ? n : n << 1];
        for (int i = 0; i < this.factors.length; ++i) {
            int j = numCol * i + i;
            elements[j] = this.factors[i];
            if (this.errors == null || i >= this.errors.length) continue;
            elements[j + n] = this.errors[i];
        }
        elements[n - 1] = 1.0;
        return elements;
    }

    @Override
    public int getSourceDimensions() {
        return this.factors.length + this.numDroppedDimensions;
    }

    @Override
    public int getTargetDimensions() {
        return this.factors.length;
    }

    public double getElement(int row, int column) {
        int dstDim = this.factors.length;
        int srcDim = dstDim + this.numDroppedDimensions;
        ArgumentChecks.ensureBetween("row", 0, dstDim, row);
        ArgumentChecks.ensureBetween("column", 0, srcDim, column);
        if (row == dstDim) {
            return column == srcDim ? 1.0 : 0.0;
        }
        return row == column ? this.factors[row] : 0.0;
    }

    @Override
    public boolean isIdentity() {
        if (this.numDroppedDimensions != 0) {
            return false;
        }
        for (int i = 0; i < this.factors.length; ++i) {
            if (this.factors[i] == 1.0) continue;
            return false;
        }
        return true;
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) {
        this.transform(srcPts, srcOff, dstPts, dstOff, 1);
        return derivate ? this.derivative(null) : null;
    }

    @Override
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        int dstDim;
        int srcDim;
        if (srcPts == dstPts && IterationStrategy.suggest(srcOff, srcDim = (dstDim = this.factors.length) + this.numDroppedDimensions, dstOff, dstDim, numPts) != IterationStrategy.ASCENDING) {
            srcPts = Arrays.copyOfRange(srcPts, srcOff, srcOff + numPts * srcDim);
            srcOff = 0;
        }
        while (--numPts >= 0) {
            for (int i = 0; i < this.factors.length; ++i) {
                dstPts[dstOff++] = srcPts[srcOff++] * this.factors[i];
            }
            srcOff += this.numDroppedDimensions;
        }
    }

    @Override
    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        int dstDim;
        int srcDim;
        if (srcPts == dstPts && IterationStrategy.suggest(srcOff, srcDim = (dstDim = this.factors.length) + this.numDroppedDimensions, dstOff, dstDim, numPts) != IterationStrategy.ASCENDING) {
            srcPts = Arrays.copyOfRange(srcPts, srcOff, srcOff + numPts * srcDim);
            srcOff = 0;
        }
        while (--numPts >= 0) {
            for (int i = 0; i < this.factors.length; ++i) {
                dstPts[dstOff++] = (float)((double)srcPts[srcOff++] * this.factors[i]);
            }
            srcOff += this.numDroppedDimensions;
        }
    }

    @Override
    public void transform(double[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        while (--numPts >= 0) {
            for (int i = 0; i < this.factors.length; ++i) {
                dstPts[dstOff++] = (float)(srcPts[srcOff++] * this.factors[i]);
            }
            srcOff += this.numDroppedDimensions;
        }
    }

    @Override
    public void transform(float[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        while (--numPts >= 0) {
            for (int i = 0; i < this.factors.length; ++i) {
                dstPts[dstOff++] = (double)srcPts[srcOff++] * this.factors[i];
            }
            srcOff += this.numDroppedDimensions;
        }
    }

    @Override
    public Matrix derivative(DirectPosition point) {
        int n = this.factors.length;
        MatrixSIS matrix = Matrices.createZero(n, n + this.numDroppedDimensions);
        for (int i = 0; i < n; ++i) {
            matrix.setElement(i, i, this.factors[i]);
        }
        return matrix;
    }

    @Override
    protected int computeHashCode() {
        return Arrays.hashCode(this.factors) + 31 * super.computeHashCode();
    }

    @Override
    protected boolean equalsSameClass(Object object) {
        ScaleTransform that = (ScaleTransform)object;
        return this.numDroppedDimensions == that.numDroppedDimensions && Arrays.equals(this.factors, that.factors) && Arrays.equals(this.errors, that.errors);
    }
}

