/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.util.Arrays;
import org.apache.sis.internal.referencing.ExtendedPrecisionMatrix;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.AbstractLinearTransform;
import org.apache.sis.referencing.operation.transform.IterationStrategy;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.ScaleTransform;
import org.apache.sis.referencing.operation.transform.TranslationTransform;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.operation.Matrix;

class ProjectiveTransform
extends AbstractLinearTransform
implements ExtendedPrecisionMatrix {
    private static final long serialVersionUID = -2104496465933824935L;
    private final int numRow;
    private final int numCol;
    private final double[] elt;

    protected ProjectiveTransform(Matrix matrix) {
        this.numRow = matrix.getNumRow();
        this.numCol = matrix.getNumCol();
        if (matrix instanceof ExtendedPrecisionMatrix) {
            this.elt = ((ExtendedPrecisionMatrix)matrix).getExtendedElements();
            assert (this.elt.length % (this.numRow * this.numCol) == 0);
        } else {
            this.elt = new double[this.numRow * this.numCol];
            int mix = 0;
            for (int j = 0; j < this.numRow; ++j) {
                for (int i = 0; i < this.numCol; ++i) {
                    this.elt[mix++] = matrix.getElement(j, i);
                }
            }
        }
    }

    final LinearTransform optimize() {
        if (this.numCol < this.numRow) {
            return this;
        }
        int n = (this.numRow - 1) * this.numCol;
        int i = 0;
        while (i < this.numCol) {
            if (this.elt[n + i] == (double)(++i == this.numCol ? 1 : 0)) continue;
            return this;
        }
        boolean isScale = true;
        boolean isTranslation = this.numRow == this.numCol;
        for (int i2 = 0; i2 < n; ++i2) {
            int col;
            if (this.elt[i2] == 0.0 || (isScale &= i2 / this.numCol == (col = i2 % this.numCol)) | (isTranslation &= col == this.numCol - 1)) continue;
            return this;
        }
        if (isTranslation) {
            return new TranslationTransform(this.numRow, this.elt);
        }
        return new ScaleTransform(this.numRow, this.numCol, this.elt);
    }

    @Override
    public final int getSourceDimensions() {
        return this.numCol - 1;
    }

    @Override
    public final int getTargetDimensions() {
        return this.numRow - 1;
    }

    @Override
    public final int getNumRow() {
        return this.numRow;
    }

    @Override
    public final int getNumCol() {
        return this.numCol;
    }

    @Override
    public final double[] getExtendedElements() {
        return (double[])this.elt.clone();
    }

    public final double getElement(int row, int column) {
        ArgumentChecks.ensureBetween("row", 0, this.numRow - 1, row);
        ArgumentChecks.ensureBetween("column", 0, this.numCol - 1, column);
        return this.elt[row * this.numCol + column];
    }

    @Override
    public final boolean isIdentity() {
        if (this.numRow != this.numCol) {
            return false;
        }
        int mix = 0;
        for (int j = 0; j < this.numRow; ++j) {
            for (int i = 0; i < this.numCol; ++i) {
                if (this.elt[mix++] == (double)(i == j ? 1 : 0)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public final Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) {
        this.transform(srcPts, srcOff, dstPts, dstOff, 1);
        return derivate ? this.derivative(null) : null;
    }

    @Override
    public final void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        int dstDim;
        int srcDim;
        int srcInc = srcDim = this.numCol - 1;
        int dstInc = dstDim = this.numRow - 1;
        if (srcPts == dstPts) {
            switch (IterationStrategy.suggest(srcOff, srcDim, dstOff, dstDim, numPts)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    srcOff += (numPts - 1) * srcDim;
                    dstOff += (numPts - 1) * dstDim;
                    srcInc = -srcInc;
                    dstInc = -dstInc;
                    break;
                }
                default: {
                    srcPts = Arrays.copyOfRange(srcPts, srcOff, srcOff + numPts * srcDim);
                    srcOff = 0;
                }
            }
        }
        double[] buffer = new double[this.numRow];
        while (--numPts >= 0) {
            int mix = 0;
            for (int j = 0; j < this.numRow; ++j) {
                double sum = this.elt[mix + srcDim];
                for (int i = 0; i < srcDim; ++i) {
                    double e;
                    if ((e = this.elt[mix++]) == 0.0) continue;
                    sum += srcPts[srcOff + i] * e;
                }
                buffer[j] = sum;
                ++mix;
            }
            double w = buffer[dstDim];
            for (int j = 0; j < dstDim; ++j) {
                dstPts[dstOff + j] = buffer[j] / w;
            }
            srcOff += srcInc;
            dstOff += dstInc;
        }
    }

    @Override
    public final void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        int dstDim;
        int srcDim;
        int srcInc = srcDim = this.numCol - 1;
        int dstInc = dstDim = this.numRow - 1;
        if (srcPts == dstPts) {
            switch (IterationStrategy.suggest(srcOff, srcDim, dstOff, dstDim, numPts)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    srcOff += (numPts - 1) * srcDim;
                    dstOff += (numPts - 1) * dstDim;
                    srcInc = -srcInc;
                    dstInc = -dstInc;
                    break;
                }
                default: {
                    srcPts = Arrays.copyOfRange(srcPts, srcOff, srcOff + numPts * srcDim);
                    srcOff = 0;
                }
            }
        }
        double[] buffer = new double[this.numRow];
        while (--numPts >= 0) {
            int mix = 0;
            for (int j = 0; j < this.numRow; ++j) {
                double sum = this.elt[mix + srcDim];
                for (int i = 0; i < srcDim; ++i) {
                    double e;
                    if ((e = this.elt[mix++]) == 0.0) continue;
                    sum += (double)srcPts[srcOff + i] * e;
                }
                buffer[j] = sum;
                ++mix;
            }
            double w = buffer[dstDim];
            for (int j = 0; j < dstDim; ++j) {
                dstPts[dstOff + j] = (float)(buffer[j] / w);
            }
            srcOff += srcInc;
            dstOff += dstInc;
        }
    }

    @Override
    public final void transform(double[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        int srcDim = this.numCol - 1;
        int dstDim = this.numRow - 1;
        double[] buffer = new double[this.numRow];
        while (--numPts >= 0) {
            int mix = 0;
            for (int j = 0; j < this.numRow; ++j) {
                double sum = this.elt[mix + srcDim];
                for (int i = 0; i < srcDim; ++i) {
                    double e;
                    if ((e = this.elt[mix++]) == 0.0) continue;
                    sum += srcPts[srcOff + i] * e;
                }
                buffer[j] = sum;
                ++mix;
            }
            double w = buffer[dstDim];
            for (int j = 0; j < dstDim; ++j) {
                dstPts[dstOff++] = (float)(buffer[j] / w);
            }
            srcOff += srcDim;
        }
    }

    @Override
    public final void transform(float[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        int srcDim = this.numCol - 1;
        int dstDim = this.numRow - 1;
        double[] buffer = new double[this.numRow];
        while (--numPts >= 0) {
            int mix = 0;
            for (int j = 0; j < this.numRow; ++j) {
                double sum = this.elt[mix + srcDim];
                for (int i = 0; i < srcDim; ++i) {
                    double e;
                    if ((e = this.elt[mix++]) == 0.0) continue;
                    sum += (double)srcPts[srcOff + i] * e;
                }
                buffer[j] = sum;
                ++mix;
            }
            double w = buffer[dstDim];
            for (int j = 0; j < dstDim; ++j) {
                dstPts[dstOff++] = buffer[j] / w;
            }
            srcOff += srcDim;
        }
    }

    @Override
    public final Matrix derivative(DirectPosition point) {
        int srcDim = this.numCol - 1;
        int dstDim = this.numRow - 1;
        MatrixSIS matrix = Matrices.createZero(dstDim, srcDim);
        int mix = 0;
        for (int j = 0; j < dstDim; ++j) {
            for (int i = 0; i < srcDim; ++i) {
                matrix.setElement(j, i, this.elt[mix++]);
            }
            ++mix;
        }
        return matrix;
    }

    @Override
    protected int computeHashCode() {
        return Arrays.hashCode(this.elt) + 31 * super.computeHashCode();
    }

    @Override
    protected boolean equalsSameClass(Object object) {
        ProjectiveTransform that = (ProjectiveTransform)object;
        return this.numRow == that.numRow && this.numCol == that.numCol && Arrays.equals(this.elt, that.elt);
    }
}

