/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.awt.geom.AffineTransform;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.sis.internal.referencing.DirectPositionView;
import org.apache.sis.internal.referencing.ExtendedPrecisionMatrix;
import org.apache.sis.internal.referencing.j2d.AffineTransform2D;
import org.apache.sis.referencing.operation.matrix.AffineTransforms2D;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.referencing.operation.transform.ConcatenatedTransform;
import org.apache.sis.referencing.operation.transform.CopyTransform;
import org.apache.sis.referencing.operation.transform.IdentityTransform;
import org.apache.sis.referencing.operation.transform.LinearInterpolator1D;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.LinearTransform1D;
import org.apache.sis.referencing.operation.transform.PassThroughTransform;
import org.apache.sis.referencing.operation.transform.ProjectiveTransform;
import org.apache.sis.referencing.operation.transform.ProjectiveTransform2D;
import org.apache.sis.referencing.operation.transform.ScaleTransform;
import org.apache.sis.referencing.operation.transform.SpecializableTransform;
import org.apache.sis.referencing.operation.transform.SpecializableTransform2D;
import org.apache.sis.referencing.operation.transform.TranslationTransform;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Static;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public final class MathTransforms
extends Static {
    private MathTransforms() {
    }

    public static LinearTransform identity(int dimension) {
        ArgumentChecks.ensurePositive("dimension", dimension);
        return IdentityTransform.create(dimension);
    }

    public static LinearTransform uniformTranslation(int dimension, double offset) {
        ArgumentChecks.ensurePositive("dimension", dimension);
        if (offset == 0.0) {
            return IdentityTransform.create(dimension);
        }
        switch (dimension) {
            case 0: {
                return IdentityTransform.create(0);
            }
            case 1: {
                return LinearTransform1D.create(1.0, offset);
            }
            case 2: {
                return new AffineTransform2D(1.0, 0.0, 0.0, 1.0, offset, offset);
            }
        }
        return new TranslationTransform(dimension, offset);
    }

    public static LinearTransform translation(double ... vector) {
        LinearTransform tr;
        ArgumentChecks.ensureNonNull("vector", vector);
        switch (vector.length) {
            case 0: {
                return IdentityTransform.create(0);
            }
            case 1: {
                return LinearTransform1D.create(1.0, vector[0]);
            }
            case 2: {
                tr = new AffineTransform2D(1.0, 0.0, 0.0, 1.0, vector[0], vector[1]);
                break;
            }
            default: {
                tr = new TranslationTransform(vector);
            }
        }
        return tr.isIdentity() ? IdentityTransform.create(vector.length) : tr;
    }

    public static LinearTransform scale(double ... factors) {
        LinearTransform tr;
        ArgumentChecks.ensureNonNull("factors", factors);
        switch (factors.length) {
            case 0: {
                return IdentityTransform.create(0);
            }
            case 1: {
                return LinearTransform1D.create(factors[0], 0.0);
            }
            case 2: {
                tr = new AffineTransform2D(factors[0], 0.0, 0.0, factors[1], 0.0, 0.0);
                break;
            }
            default: {
                tr = new ScaleTransform(factors);
            }
        }
        return tr.isIdentity() ? IdentityTransform.create(factors.length) : tr;
    }

    public static LinearTransform linear(double scale, double offset) {
        return LinearTransform1D.create(scale, offset);
    }

    public static LinearTransform linear(Matrix matrix) {
        CopyTransform candidate;
        ArgumentChecks.ensureNonNull("matrix", matrix);
        int sourceDimension = matrix.getNumCol() - 1;
        int targetDimension = matrix.getNumRow() - 1;
        if (sourceDimension == targetDimension) {
            if (matrix.isIdentity()) {
                return MathTransforms.identity(sourceDimension);
            }
            if (Matrices.isAffine(matrix)) {
                switch (sourceDimension) {
                    case 1: {
                        return MathTransforms.linear(matrix.getElement(0, 0), matrix.getElement(0, 1));
                    }
                    case 2: {
                        if (matrix instanceof ExtendedPrecisionMatrix) {
                            return new AffineTransform2D(((ExtendedPrecisionMatrix)matrix).getExtendedElements());
                        }
                        return new AffineTransform2D(matrix.getElement(0, 0), matrix.getElement(1, 0), matrix.getElement(0, 1), matrix.getElement(1, 1), matrix.getElement(0, 2), matrix.getElement(1, 2));
                    }
                }
            } else if (sourceDimension == 2) {
                return new ProjectiveTransform2D(matrix);
            }
        }
        if ((candidate = CopyTransform.create(matrix)) != null) {
            return candidate;
        }
        return new ProjectiveTransform(matrix).optimize();
    }

    public static LinearTransform linear(MathTransform transform, DirectPosition position) throws TransformException {
        if (transform instanceof LinearTransform) {
            ArgumentChecks.ensureDimensionMatches("position", transform.getSourceDimensions(), position);
            return (LinearTransform)transform;
        }
        return MathTransforms.linear(MathTransforms.getMatrix(transform, position));
    }

    public static MathTransform1D interpolate(double[] preimage, double[] values) {
        return LinearInterpolator1D.create(preimage, values);
    }

    public static MathTransform specialize(MathTransform global, Map<Envelope, MathTransform> specializations) {
        ArgumentChecks.ensureNonNull("generic", global);
        ArgumentChecks.ensureNonNull("specializations", specializations);
        if (specializations.isEmpty()) {
            return global;
        }
        if (global.getSourceDimensions() == 2 && global.getTargetDimensions() == 2) {
            return new SpecializableTransform2D(global, specializations);
        }
        return new SpecializableTransform(global, specializations);
    }

    public static MathTransform passThrough(int firstAffectedCoordinate, MathTransform subTransform, int numTrailingCoordinates) {
        int dimension;
        ArgumentChecks.ensureNonNull("subTransform", subTransform);
        ArgumentChecks.ensurePositive("firstAffectedCoordinate", firstAffectedCoordinate);
        ArgumentChecks.ensurePositive("numTrailingCoordinates", numTrailingCoordinates);
        if (firstAffectedCoordinate == 0 && numTrailingCoordinates == 0) {
            return subTransform;
        }
        if (subTransform.isIdentity() && (dimension = subTransform.getSourceDimensions()) == subTransform.getTargetDimensions()) {
            return IdentityTransform.create(firstAffectedCoordinate + dimension + numTrailingCoordinates);
        }
        return PassThroughTransform.create0(firstAffectedCoordinate, subTransform, numTrailingCoordinates);
    }

    public static MathTransform compound(MathTransform ... components) {
        ArgumentChecks.ensureNonNull("components", components);
        int sum = 0;
        int[] dimensions = new int[components.length];
        for (int i = 0; i < components.length; ++i) {
            MathTransform tr = components[i];
            ArgumentChecks.ensureNonNullElement("components", i, tr);
            dimensions[i] = tr.getSourceDimensions();
            sum += dimensions[i];
        }
        MathTransform compound = null;
        int firstAffectedCoordinate = 0;
        for (int i = 0; i < components.length; ++i) {
            MathTransform tr = components[i];
            tr = MathTransforms.passThrough(firstAffectedCoordinate, tr, sum - (firstAffectedCoordinate += dimensions[i]));
            compound = compound == null ? tr : MathTransforms.concatenate(compound, tr);
        }
        assert (MathTransforms.isValid(MathTransforms.getSteps(compound))) : compound;
        return compound;
    }

    public static MathTransform concatenate(MathTransform tr1, MathTransform tr2) throws MismatchedDimensionException {
        MathTransform tr;
        ArgumentChecks.ensureNonNull("tr1", tr1);
        ArgumentChecks.ensureNonNull("tr2", tr2);
        try {
            tr = ConcatenatedTransform.create(tr1, tr2, null);
        }
        catch (FactoryException e) {
            throw new IllegalArgumentException(e);
        }
        assert (MathTransforms.isValid(MathTransforms.getSteps(tr))) : tr;
        return tr;
    }

    public static MathTransform1D concatenate(MathTransform1D tr1, MathTransform1D tr2) throws MismatchedDimensionException {
        return (MathTransform1D)MathTransforms.concatenate((MathTransform)tr1, (MathTransform)tr2);
    }

    public static MathTransform2D concatenate(MathTransform2D tr1, MathTransform2D tr2) throws MismatchedDimensionException {
        return (MathTransform2D)MathTransforms.concatenate((MathTransform)tr1, (MathTransform)tr2);
    }

    public static MathTransform concatenate(MathTransform tr1, MathTransform tr2, MathTransform tr3) throws MismatchedDimensionException {
        ArgumentChecks.ensureNonNull("tr1", tr1);
        ArgumentChecks.ensureNonNull("tr2", tr2);
        ArgumentChecks.ensureNonNull("tr3", tr3);
        return MathTransforms.concatenate(MathTransforms.concatenate(tr1, tr2), tr3);
    }

    public static MathTransform1D concatenate(MathTransform1D tr1, MathTransform1D tr2, MathTransform1D tr3) throws MismatchedDimensionException {
        return (MathTransform1D)MathTransforms.concatenate((MathTransform)tr1, (MathTransform)tr2, (MathTransform)tr3);
    }

    public static MathTransform2D concatenate(MathTransform2D tr1, MathTransform2D tr2, MathTransform2D tr3) throws MismatchedDimensionException {
        return (MathTransform2D)MathTransforms.concatenate((MathTransform)tr1, (MathTransform)tr2, (MathTransform)tr3);
    }

    static boolean isValid(List<MathTransform> steps) {
        boolean wasLinear = false;
        for (MathTransform step : steps) {
            if (step instanceof LinearTransform) {
                if (wasLinear) {
                    return false;
                }
                wasLinear = true;
                continue;
            }
            wasLinear = false;
        }
        return true;
    }

    public static List<MathTransform> getSteps(MathTransform transform) {
        if (transform != null) {
            if (transform instanceof ConcatenatedTransform) {
                return ((ConcatenatedTransform)transform).getSteps();
            }
            return Collections.singletonList(transform);
        }
        return Collections.emptyList();
    }

    public static Matrix getMatrix(MathTransform transform) {
        if (transform instanceof LinearTransform) {
            return ((LinearTransform)transform).getMatrix();
        }
        if (transform instanceof AffineTransform) {
            return AffineTransforms2D.toMatrix((AffineTransform)transform);
        }
        return null;
    }

    public static Matrix getMatrix(MathTransform transform, DirectPosition position) throws TransformException {
        ArgumentChecks.ensureNonNull("transform", transform);
        int srcDim = transform.getSourceDimensions();
        ArgumentChecks.ensureDimensionMatches("position", srcDim, position);
        Matrix affine = MathTransforms.getMatrix(transform);
        if (affine != null) {
            return affine;
        }
        ArgumentChecks.ensureNonNull("position", position);
        int tgtDim = transform.getTargetDimensions();
        double[] pts = new double[Math.max(srcDim + 1, tgtDim)];
        for (int i = 0; i < srcDim; ++i) {
            pts[i] = position.getOrdinate(i);
        }
        Matrix d = MathTransforms.derivativeAndTransform(transform, pts, 0, pts, 0);
        MatrixSIS a = Matrices.createZero(tgtDim + 1, srcDim + 1);
        for (int j = 0; j < tgtDim; ++j) {
            for (int i = 0; i < srcDim; ++i) {
                a.setElement(j, i, d.getElement(j, i));
            }
            a.setElement(j, srcDim, pts[j]);
            pts[j] = -position.getOrdinate(j);
        }
        a.setElement(tgtDim, srcDim, 1.0);
        pts = ArraysExt.resize(pts, srcDim + 1);
        pts[srcDim] = 1.0;
        a.translate(pts);
        return a;
    }

    public static Matrix derivativeAndTransform(MathTransform transform, double[] srcPts, int srcOff, double[] dstPts, int dstOff) throws TransformException {
        if (transform instanceof AbstractMathTransform) {
            return ((AbstractMathTransform)transform).transform(srcPts, srcOff, dstPts, dstOff, true);
        }
        Matrix derivative = transform.derivative((DirectPosition)new DirectPositionView.Double(srcPts, srcOff, transform.getSourceDimensions()));
        if (dstPts != null) {
            transform.transform(srcPts, srcOff, dstPts, dstOff, 1);
        }
        return derivative;
    }
}

