/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import javax.measure.Unit;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Length;
import org.apache.sis.internal.referencing.provider.FranceGeocentricInterpolation;
import org.apache.sis.internal.referencing.provider.Molodensky;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.referencing.datum.DatumShiftGrid;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.operation.transform.DatumShiftTransform;
import org.apache.sis.referencing.operation.transform.EllipsoidToCentricTransform;
import org.apache.sis.referencing.operation.transform.InterpolatedGeocentricTransform2D;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class InterpolatedGeocentricTransform
extends DatumShiftTransform {
    private static final long serialVersionUID = 5503722845441653093L;
    static final ParameterDescriptorGroup DESCRIPTOR;
    private static final ParameterDescriptorGroup INVERSE;
    final double semiMajor;
    final double scale;
    final AbstractMathTransform ellipsoidToCentric;
    final AbstractMathTransform centricToEllipsoid;
    private final InterpolatedGeocentricTransform inverse;

    InterpolatedGeocentricTransform(InterpolatedGeocentricTransform inverse, Ellipsoid source, Ellipsoid target) {
        this(target, inverse.getTargetDimensions() > 2, source, inverse.getSourceDimensions() > 2, inverse.grid, inverse);
    }

    protected InterpolatedGeocentricTransform(Ellipsoid source, boolean isSource3D, Ellipsoid target, boolean isTarget3D, DatumShiftGrid<Angle, Length> grid) {
        this(source, isSource3D, target, isTarget3D, grid, null);
    }

    private InterpolatedGeocentricTransform(Ellipsoid source, boolean isSource3D, Ellipsoid target, boolean isTarget3D, DatumShiftGrid<?, ?> grid, InterpolatedGeocentricTransform inverse) {
        super(inverse != null ? INVERSE : DESCRIPTOR, isSource3D, isTarget3D, grid);
        ArgumentChecks.ensureNonNull("source", source);
        ArgumentChecks.ensureNonNull("target", target);
        ArgumentChecks.ensureNonNull("grid", grid);
        Unit unit = source.getAxisUnit();
        InterpolatedGeocentricTransform.ensureGeocentricTranslation(grid, (Unit<Length>)unit);
        this.semiMajor = source.getSemiMajorAxis();
        double semiMinor = source.getSemiMinorAxis();
        this.setContextParameters(this.semiMajor, semiMinor, (Unit<Length>)unit, target);
        this.context.getOrCreate(Molodensky.DIMENSION).setValue(isSource3D ? 3 : 2);
        grid.getParameterValues(this.context);
        this.scale = this.semiMajor / this.context.doubleValue((ParameterDescriptor<? extends Number>)Molodensky.TGT_SEMI_MAJOR);
        if (inverse == null) {
            this.ellipsoidToCentric = new EllipsoidToCentricTransform(this.semiMajor, semiMinor, (Unit<Length>)unit, isSource3D, EllipsoidToCentricTransform.TargetType.CARTESIAN);
            this.centricToEllipsoid = (AbstractMathTransform)new EllipsoidToCentricTransform(target.getSemiMajorAxis(), target.getSemiMinorAxis(), (Unit<Length>)target.getAxisUnit(), isTarget3D, EllipsoidToCentricTransform.TargetType.CARTESIAN).inverse();
        } else {
            try {
                this.ellipsoidToCentric = (AbstractMathTransform)inverse.centricToEllipsoid.inverse();
                this.centricToEllipsoid = (AbstractMathTransform)inverse.ellipsoidToCentric.inverse();
            }
            catch (NoninvertibleTransformException e) {
                throw new IllegalArgumentException(e);
            }
        }
        this.context.getMatrix(ContextualParameters.MatrixRole.NORMALIZATION).setMatrix(this.ellipsoidToCentric.getContextualParameters().getMatrix(ContextualParameters.MatrixRole.NORMALIZATION));
        this.context.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION).setMatrix(this.centricToEllipsoid.getContextualParameters().getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION));
        if (inverse == null) {
            inverse = isSource3D || isTarget3D ? new Inverse(this, source, target) : new InterpolatedGeocentricTransform2D.Inverse(this, source, target);
        }
        this.inverse = inverse;
    }

    private MathTransform completeTransform(MathTransformFactory factory, boolean create) throws FactoryException {
        this.ellipsoidToCentric.getContextualParameters().completeTransform(factory, null);
        this.centricToEllipsoid.getContextualParameters().completeTransform(factory, null);
        return this.context.completeTransform(factory, create ? this : null);
    }

    public static MathTransform createGeodeticTransformation(MathTransformFactory factory, Ellipsoid source, boolean isSource3D, Ellipsoid target, boolean isTarget3D, DatumShiftGrid<Angle, Length> grid) throws FactoryException {
        InterpolatedGeocentricTransform tr = isSource3D || isTarget3D ? new InterpolatedGeocentricTransform(source, isSource3D, target, isTarget3D, grid) : new InterpolatedGeocentricTransform2D(source, target, grid);
        tr.inverse.completeTransform(factory, false);
        return super.completeTransform(factory, true);
    }

    @Override
    public int getSourceDimensions() {
        return this.ellipsoidToCentric.getSourceDimensions();
    }

    @Override
    public int getTargetDimensions() {
        return this.centricToEllipsoid.getTargetDimensions();
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws TransformException {
        double[] vector = new double[3];
        this.grid.interpolateInCell(this.normalizedToGridX(srcPts[srcOff]), this.normalizedToGridY(srcPts[srcOff + 1]), vector);
        double tX = vector[0] / this.semiMajor;
        double tY = vector[1] / this.semiMajor;
        double tZ = vector[2] / this.semiMajor;
        Matrix m1 = this.ellipsoidToCentric.transform(srcPts, srcOff, vector, 0, derivate);
        vector[0] = (vector[0] + tX) * this.scale;
        vector[1] = (vector[1] + tY) * this.scale;
        vector[2] = (vector[2] + tZ) * this.scale;
        Matrix m2 = this.centricToEllipsoid.transform(vector, 0, dstPts, dstOff, derivate);
        if (m1 == null || m2 == null) {
            return null;
        }
        return this.concatenate(m1, m2);
    }

    final Matrix concatenate(Matrix m1, Matrix m2) {
        int i = m1.getNumCol();
        while (--i >= 0) {
            int j = 3;
            while (--j >= 0) {
                m1.setElement(j, i, m1.getElement(j, i) * this.scale);
            }
        }
        return Matrices.multiply(m2, m1);
    }

    @Override
    public MathTransform inverse() {
        return this.inverse;
    }

    static {
        ParameterBuilder builder = (ParameterBuilder)new ParameterBuilder().setRequired(true).setCodeSpace(Citations.SIS, "SIS");
        ParameterDescriptor[] param = new ParameterDescriptor[]{Molodensky.DIMENSION, Molodensky.SRC_SEMI_MAJOR, Molodensky.SRC_SEMI_MINOR, Molodensky.TGT_SEMI_MAJOR, Molodensky.TGT_SEMI_MINOR, FranceGeocentricInterpolation.FILE};
        DESCRIPTOR = ((ParameterBuilder)builder.addName("Geocentric interpolation")).createGroup((GeneralParameterDescriptor[])param);
        INVERSE = ((ParameterBuilder)builder.addName("Geocentric inverse interpolation")).createGroup((GeneralParameterDescriptor[])param);
    }

    static class Inverse
    extends InterpolatedGeocentricTransform {
        private static final long serialVersionUID = -3481207454803064521L;
        private final double tX;
        private final double tY;
        private final double tZ;

        Inverse(InterpolatedGeocentricTransform inverse, Ellipsoid source, Ellipsoid target) {
            super(inverse, source, target);
            this.tX = this.grid.getCellMean(0) / this.semiMajor;
            this.tY = this.grid.getCellMean(1) / this.semiMajor;
            this.tZ = this.grid.getCellMean(2) / this.semiMajor;
        }

        @Override
        public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws TransformException {
            double[] vector = new double[3];
            Matrix m1 = this.ellipsoidToCentric.transform(srcPts, srcOff, vector, 0, derivate);
            double x = vector[0];
            double y = vector[1];
            double z = vector[2];
            vector[0] = x - this.tX;
            vector[1] = y - this.tY;
            vector[2] = z - this.tZ;
            this.centricToEllipsoid.transform(vector, 0, vector, 0, derivate);
            this.grid.interpolateInCell(this.normalizedToGridX(vector[0]), this.normalizedToGridY(vector[1]), vector);
            vector[0] = (x - vector[0] / this.semiMajor) * this.scale;
            vector[1] = (y - vector[1] / this.semiMajor) * this.scale;
            vector[2] = (z - vector[2] / this.semiMajor) * this.scale;
            Matrix m2 = this.centricToEllipsoid.transform(vector, 0, dstPts, dstOff, derivate);
            if (m1 == null || m2 == null) {
                return null;
            }
            return this.concatenate(m1, m2);
        }
    }
}

