/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.apache.sis.internal.referencing.DirectPositionView;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.referencing.provider.GeocentricAffineBetweenGeographic;
import org.apache.sis.internal.referencing.provider.GeocentricToGeographic;
import org.apache.sis.internal.referencing.provider.Geographic3Dto2D;
import org.apache.sis.internal.referencing.provider.GeographicToGeocentric;
import org.apache.sis.internal.referencing.provider.MapProjection;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.DefaultParameterDescriptorGroup;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.ImmutableIdentifier;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.Matrix3;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.referencing.operation.transform.ConcatenatedTransform;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.operation.transform.IterationStrategy;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.SphericalToCartesian;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.opengis.geometry.DirectPosition;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class EllipsoidToCentricTransform
extends AbstractMathTransform
implements Serializable {
    private static final long serialVersionUID = -3352045463953828140L;
    private static ParameterDescriptorGroup DESCRIPTOR;
    private static final double ECCENTRICITY_THRESHOLD = 0.16;
    protected final double eccentricitySquared;
    private transient double axisRatio;
    private transient boolean useIterations;
    final boolean withHeight;
    final ContextualParameters context;
    private final AbstractMathTransform inverse;

    protected EllipsoidToCentricTransform(double semiMajor, double semiMinor, Unit<Length> unit, boolean withHeight, TargetType target) {
        ArgumentChecks.ensureStrictlyPositive("semiMajor", semiMajor);
        ArgumentChecks.ensureStrictlyPositive("semiMinor", semiMinor);
        ArgumentChecks.ensureNonNull("target", (Object)target);
        this.axisRatio = semiMinor / semiMajor;
        this.eccentricitySquared = 1.0 - this.axisRatio * this.axisRatio;
        this.useIterations = this.eccentricitySquared >= 0.0256;
        this.withHeight = withHeight;
        this.context = new ContextualParameters(GeographicToGeocentric.PARAMETERS, withHeight ? 3 : 2, 3);
        this.context.getOrCreate(MapProjection.SEMI_MAJOR).setValue(semiMajor, unit);
        this.context.getOrCreate(MapProjection.SEMI_MINOR).setValue(semiMinor, unit);
        this.context.normalizeGeographicInputs(0.0);
        DoubleDouble a = DoubleDouble.createAndGuessError(semiMajor);
        MatrixSIS denormalize = this.context.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION);
        for (int i = 0; i < 3; ++i) {
            denormalize.convertAfter(i, a, null);
        }
        if (withHeight) {
            a.inverseDivide(1.0);
            MatrixSIS normalize = this.context.getMatrix(ContextualParameters.MatrixRole.NORMALIZATION);
            normalize.convertBefore(2, a, null);
        }
        this.inverse = new Inverse(this);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.useIterations = this.eccentricitySquared >= 0.0256;
        this.axisRatio = Math.sqrt(1.0 - this.eccentricitySquared);
    }

    public static MathTransform createGeodeticConversion(MathTransformFactory factory, double semiMajor, double semiMinor, Unit<Length> unit, boolean withHeight, TargetType target) throws FactoryException {
        if (Math.abs(semiMajor - semiMinor) <= semiMajor * 1.5696105811844188E-9) {
            MatrixSIS translate = Matrices.createDiagonal(4, withHeight ? 4 : 3);
            translate.setElement(2, withHeight ? 3 : 2, semiMajor);
            if (!withHeight) {
                translate.setElement(3, 2, 1.0);
            }
            MathTransform tr = SphericalToCartesian.INSTANCE.completeTransform(factory);
            return factory.createConcatenatedTransform(factory.createAffineTransform((Matrix)translate), tr);
        }
        EllipsoidToCentricTransform tr = new EllipsoidToCentricTransform(semiMajor, semiMinor, unit, withHeight, target);
        return tr.context.completeTransform(factory, tr);
    }

    public static MathTransform createGeodeticConversion(MathTransformFactory factory, Ellipsoid ellipsoid, boolean withHeight) throws FactoryException {
        return EllipsoidToCentricTransform.createGeodeticConversion(factory, ellipsoid.getSemiMajorAxis(), ellipsoid.getSemiMinorAxis(), (Unit<Length>)ellipsoid.getAxisUnit(), withHeight, TargetType.CARTESIAN);
    }

    @Override
    protected ContextualParameters getContextualParameters() {
        return this.context;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        Parameters pg = Parameters.castOrWrap(this.getParameterDescriptors().createValue());
        pg.getOrCreate(MapProjection.ECCENTRICITY).setValue(Math.sqrt(this.eccentricitySquared));
        pg.parameter("target").setValue((Object)this.getTargetType());
        pg.getOrCreate(GeocentricAffineBetweenGeographic.DIMENSION).setValue(this.getSourceDimensions());
        return pg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        Class<EllipsoidToCentricTransform> clazz = EllipsoidToCentricTransform.class;
        synchronized (EllipsoidToCentricTransform.class) {
            if (DESCRIPTOR == null) {
                ParameterBuilder builder = (ParameterBuilder)new ParameterBuilder().setCodeSpace(Citations.SIS, "SIS");
                ParameterDescriptor<TargetType> target = ((ParameterBuilder)builder.setRequired(true).addName("target")).create(TargetType.class, TargetType.CARTESIAN);
                DESCRIPTOR = ((ParameterBuilder)builder.addName("Ellipsoid (radians domain) to centric")).createGroup(1, 1, new GeneralParameterDescriptor[]{MapProjection.ECCENTRICITY, target, GeocentricAffineBetweenGeographic.DIMENSION});
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return DESCRIPTOR;
        }
    }

    @Override
    public final int getSourceDimensions() {
        return this.withHeight ? 3 : 2;
    }

    @Override
    public final int getTargetDimensions() {
        return 3;
    }

    public final TargetType getTargetType() {
        return TargetType.CARTESIAN;
    }

    @Override
    public Matrix derivative(DirectPosition point) throws TransformException {
        double h;
        boolean wh;
        int dim = point.getDimension();
        switch (dim) {
            default: {
                throw EllipsoidToCentricTransform.mismatchedDimension("point", this.getSourceDimensions(), dim);
            }
            case 3: {
                wh = true;
                h = point.getOrdinate(2);
                break;
            }
            case 2: {
                wh = false;
                h = 0.0;
            }
        }
        return this.transform(point.getOrdinate(0), point.getOrdinate(1), h, null, 0, true, wh);
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws TransformException {
        return this.transform(srcPts[srcOff], srcPts[srcOff + 1], this.withHeight ? srcPts[srcOff + 2] : 0.0, dstPts, dstOff, derivate, this.withHeight);
    }

    private Matrix transform(double \u03bb, double \u03c6, double h, double[] dstPts, int dstOff, boolean derivate, boolean wh) {
        double cos\u03bb = Math.cos(\u03bb);
        double sin\u03bb = Math.sin(\u03bb);
        double cos\u03c6 = Math.cos(\u03c6);
        double sin\u03c6 = Math.sin(\u03c6);
        double \u03bd2 = 1.0 / (1.0 - this.eccentricitySquared * (sin\u03c6 * sin\u03c6));
        double \u03bd = Math.sqrt(\u03bd2);
        double r = \u03bd + h;
        double \u03bd\u212f = \u03bd * (1.0 - this.eccentricitySquared);
        if (dstPts != null) {
            double rcos\u03c6 = r * cos\u03c6;
            dstPts[dstOff] = rcos\u03c6 * cos\u03bb;
            dstPts[dstOff + 1] = rcos\u03c6 * sin\u03bb;
            dstPts[dstOff + 2] = (\u03bd\u212f + h) * sin\u03c6;
        }
        if (!derivate) {
            return null;
        }
        double sd\u03c6 = \u03bd\u212f * \u03bd2 + h;
        double dX_dh = cos\u03c6 * cos\u03bb;
        double dY_dh = cos\u03c6 * sin\u03bb;
        double dX_d\u03bb = -r * dY_dh;
        double dY_d\u03bb = r * dX_dh;
        double dX_d\u03c6 = -sd\u03c6 * (sin\u03c6 * cos\u03bb);
        double dY_d\u03c6 = -sd\u03c6 * (sin\u03c6 * sin\u03bb);
        double dZ_d\u03c6 = sd\u03c6 * cos\u03c6;
        if (wh) {
            return new Matrix3(dX_d\u03bb, dX_d\u03c6, dX_dh, dY_d\u03bb, dY_d\u03c6, dY_dh, 0.0, dZ_d\u03c6, sin\u03c6);
        }
        return Matrices.create(3, 2, new double[]{dX_d\u03bb, dX_d\u03c6, dY_d\u03bb, dY_d\u03c6, 0.0, dZ_d\u03c6});
    }

    @Override
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        int srcInc = 0;
        int dstInc = 0;
        if (srcPts == dstPts) {
            int dimSource = this.getSourceDimensions();
            switch (IterationStrategy.suggest(srcOff, dimSource, dstOff, 3, numPts)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    srcOff += (numPts - 1) * dimSource;
                    dstOff += (numPts - 1) * 3;
                    srcInc = -2 * dimSource;
                    dstInc = -6;
                    break;
                }
                default: {
                    srcPts = Arrays.copyOfRange(srcPts, srcOff, srcOff + numPts * dimSource);
                    srcOff = 0;
                }
            }
        }
        while (--numPts >= 0) {
            double \u03bb = srcPts[srcOff++];
            double \u03c6 = srcPts[srcOff++];
            double h = this.withHeight ? srcPts[srcOff++] : 0.0;
            double sin\u03c6 = Math.sin(\u03c6);
            double \u03bd = 1.0 / Math.sqrt(1.0 - this.eccentricitySquared * (sin\u03c6 * sin\u03c6));
            double rcos\u03c6 = (\u03bd + h) * Math.cos(\u03c6);
            dstPts[dstOff++] = rcos\u03c6 * Math.cos(\u03bb);
            dstPts[dstOff++] = rcos\u03c6 * Math.sin(\u03bb);
            dstPts[dstOff++] = (\u03bd * (1.0 - this.eccentricitySquared) + h) * sin\u03c6;
            srcOff += srcInc;
            dstOff += dstInc;
        }
    }

    protected void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        int srcInc = 0;
        int dstInc = 0;
        if (srcPts == dstPts) {
            int dimTarget = this.getSourceDimensions();
            switch (IterationStrategy.suggest(srcOff, 3, dstOff, dimTarget, numPts)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    srcOff += (numPts - 1) * 3;
                    dstOff += (numPts - 1) * dimTarget;
                    srcInc = -6;
                    dstInc = -2 * dimTarget;
                    break;
                }
                default: {
                    dstPts = Arrays.copyOfRange(dstPts, dstOff, dstOff + numPts * dimTarget);
                    dstOff = 0;
                }
            }
        }
        block4: while (--numPts >= 0) {
            double X = srcPts[srcOff++];
            double Y = srcPts[srcOff++];
            double Z = srcPts[srcOff++];
            double p = Math.hypot(X, Y);
            double tanq = Z / (p * this.axisRatio);
            double cos2q = 1.0 / (1.0 + tanq * tanq);
            double sin2q = 1.0 - cos2q;
            double \u03c6 = Math.atan((Z + Math.copySign(this.eccentricitySquared * sin2q * Math.sqrt(sin2q), tanq) / this.axisRatio) / (p - this.eccentricitySquared * cos2q * Math.sqrt(cos2q)));
            if (!this.useIterations) {
                dstPts[dstOff++] = Math.atan2(Y, X);
                dstPts[dstOff++] = \u03c6;
                if (this.withHeight) {
                    double sin\u03c6 = Math.sin(\u03c6);
                    double \u03bd = 1.0 / Math.sqrt(1.0 - this.eccentricitySquared * (sin\u03c6 * sin\u03c6));
                    dstPts[dstOff++] = p / Math.cos(\u03c6) - \u03bd;
                }
                srcOff += srcInc;
                dstOff += dstInc;
                continue;
            }
            for (int it = 18; it >= 0; --it) {
                double sin\u03c6 = Math.sin(\u03c6);
                double \u03bd = 1.0 / Math.sqrt(1.0 - this.eccentricitySquared * (sin\u03c6 * sin\u03c6));
                double \u0394\u03c6 = \u03c6 - (\u03c6 = Math.atan((Z + this.eccentricitySquared * \u03bd * sin\u03c6) / p));
                if (Math.abs(\u0394\u03c6) >= 3.926676682852614E-10) continue;
                dstPts[dstOff++] = Math.atan2(Y, X);
                dstPts[dstOff++] = \u03c6;
                if (this.withHeight) {
                    dstPts[dstOff++] = p / Math.cos(\u03c6) - \u03bd;
                }
                srcOff += srcInc;
                dstOff += dstInc;
                continue block4;
            }
            throw new TransformException(Resources.format((short)46));
        }
    }

    @Override
    public MathTransform inverse() {
        return this.inverse;
    }

    @Override
    protected int computeHashCode() {
        int code = super.computeHashCode() + Double.hashCode(this.axisRatio);
        if (this.withHeight) {
            code += 37;
        }
        return code;
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, mode)) {
            EllipsoidToCentricTransform that = (EllipsoidToCentricTransform)object;
            return this.withHeight == that.withHeight && Numerics.equals(this.axisRatio, that.axisRatio);
        }
        return false;
    }

    @Override
    final int beforeFormat(List<Object> transforms, int index, boolean inverse) {
        index = super.beforeFormat(transforms, index, inverse);
        if (!this.withHeight) {
            transforms.add(index++, new Geographic3Dto2D.WKT(true));
        }
        return index;
    }

    @Override
    protected MathTransform tryConcatenate(boolean applyOtherFirst, MathTransform other, MathTransformFactory factory) throws FactoryException {
        Matrix matrix;
        if (applyOtherFirst && this.withHeight && other instanceof LinearTransform && other.getSourceDimensions() == 2 && (matrix = ((LinearTransform)other).getMatrix()).getElement(2, 0) == 0.0 && matrix.getElement(2, 1) == 0.0 && matrix.getElement(2, 2) == 0.0) {
            matrix = MatrixSIS.castOrCopy(matrix).removeRows(2, 3);
            EllipsoidToCentricTransform tr2D = this.create2D();
            if (factory != null) {
                return factory.createConcatenatedTransform(factory.createAffineTransform(matrix), (MathTransform)tr2D);
            }
            return ConcatenatedTransform.create(MathTransforms.linear(matrix), tr2D, factory);
        }
        return super.tryConcatenate(applyOtherFirst, other, factory);
    }

    final EllipsoidToCentricTransform create2D() {
        ParameterValue<Double> p = this.context.getOrCreate(MapProjection.SEMI_MAJOR);
        Unit unit = p.getUnit().asType(Length.class);
        return new EllipsoidToCentricTransform(p.doubleValue(), this.context.getOrCreate(MapProjection.SEMI_MINOR).doubleValue(unit), (Unit<Length>)unit, false, this.getTargetType());
    }

    private static final class Inverse
    extends AbstractMathTransform.Inverse
    implements Serializable {
        private static final long serialVersionUID = 33004303758761821L;
        private final EllipsoidToCentricTransform forward;

        Inverse(EllipsoidToCentricTransform forward) {
            this.forward = forward;
        }

        @Override
        public MathTransform inverse() {
            return this.forward;
        }

        @Override
        protected ContextualParameters getContextualParameters() {
            return this.forward.context.inverse(GeocentricToGeographic.PARAMETERS);
        }

        @Override
        public ParameterValueGroup getParameterValues() {
            ParameterValueGroup pg = this.getParameterDescriptors().createValue();
            pg.values().addAll(this.forward.getParameterValues().values());
            return pg;
        }

        @Override
        public ParameterDescriptorGroup getParameterDescriptors() {
            return new DefaultParameterDescriptorGroup(Collections.singletonMap("name", new ImmutableIdentifier(Citations.SIS, "SIS", "Centric to ellipsoid (radians domain)")), this.forward.getParameterDescriptors());
        }

        @Override
        public Matrix derivative(DirectPosition point) throws TransformException {
            ArgumentChecks.ensureNonNull("point", point);
            double[] coordinate = point.getCoordinate();
            ArgumentChecks.ensureDimensionMatches("point", 3, coordinate);
            return this.transform(coordinate, 0, coordinate, 0, true);
        }

        @Override
        public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws TransformException {
            int offset;
            double[] point;
            if (derivate && (dstPts == null || !this.forward.withHeight)) {
                point = new double[3];
                offset = 0;
            } else {
                point = dstPts;
                offset = dstOff;
            }
            this.forward.inverseTransform(srcPts, srcOff, point, offset, 1);
            if (!derivate) {
                return null;
            }
            if (dstPts != point && dstPts != null) {
                dstPts[dstOff] = point[0];
                dstPts[dstOff + 1] = point[1];
            }
            Matrix matrix = this.forward.derivative(new DirectPositionView.Double(point, offset, 3));
            matrix = Matrices.inverse(matrix);
            if (!this.forward.withHeight) {
                matrix = MatrixSIS.castOrCopy(matrix).removeRows(2, 3);
            }
            return matrix;
        }

        @Override
        public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
            this.forward.inverseTransform(srcPts, srcOff, dstPts, dstOff, numPts);
        }

        @Override
        protected MathTransform tryConcatenate(boolean applyOtherFirst, MathTransform other, MathTransformFactory factory) throws FactoryException {
            Matrix matrix;
            if (!applyOtherFirst && this.forward.withHeight && other instanceof LinearTransform && other.getTargetDimensions() == 2 && (matrix = ((LinearTransform)other).getMatrix()).getElement(0, 2) == 0.0 && matrix.getElement(1, 2) == 0.0 && matrix.getElement(2, 2) == 0.0) {
                matrix = MatrixSIS.castOrCopy(matrix).removeColumns(2, 3);
                MathTransform tr2D = this.forward.create2D().inverse();
                if (factory != null) {
                    return factory.createConcatenatedTransform(tr2D, factory.createAffineTransform(matrix));
                }
                return ConcatenatedTransform.create(tr2D, MathTransforms.linear(matrix), factory);
            }
            return super.tryConcatenate(applyOtherFirst, other, factory);
        }

        @Override
        final int beforeFormat(List<Object> transforms, int index, boolean inverse) {
            index = super.beforeFormat(transforms, index, inverse);
            if (!this.forward.withHeight) {
                transforms.add(++index, new Geographic3Dto2D.WKT(false));
            }
            return index;
        }
    }

    public static enum TargetType {
        CARTESIAN;

    }
}

