/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.measure.IncommensurableException;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.apache.sis.internal.referencing.CoordinateOperations;
import org.apache.sis.internal.referencing.LazySet;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.referencing.j2d.ParameterizedAffine;
import org.apache.sis.internal.referencing.provider.AbstractProvider;
import org.apache.sis.internal.referencing.provider.Providers;
import org.apache.sis.internal.referencing.provider.VerticalOffset;
import org.apache.sis.io.wkt.Parser;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.DefaultParameterValueGroup;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.referencing.factory.InvalidGeodeticParameterException;
import org.apache.sis.referencing.operation.DefaultOperationMethod;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.ConcatenatedTransform;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.operation.transform.CoordinateSystemTransform;
import org.apache.sis.referencing.operation.transform.MathTransformProvider;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.OperationMethodSet;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Classes;
import org.apache.sis.util.collection.WeakHashSet;
import org.apache.sis.util.iso.AbstractFactory;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.util.FactoryException;
import org.opengis.util.NoSuchIdentifierException;

public class DefaultMathTransformFactory
extends AbstractFactory
implements MathTransformFactory,
Parser {
    private static final double ELLIPSOID_PRECISION = 0.01;
    private static volatile Constructor<? extends Parser> parserConstructor;
    private final Iterable<? extends OperationMethod> methods;
    private final ConcurrentMap<String, OperationMethod> methodsByName;
    private final Map<Class<?>, OperationMethodSet> methodsByType;
    private final ThreadLocal<OperationMethod> lastMethod;
    private final WeakHashSet<MathTransform> pool;
    private final AtomicReference<Parser> parser;

    public DefaultMathTransformFactory() {
        this(new Providers());
    }

    public DefaultMathTransformFactory(Iterable<? extends OperationMethod> methods) {
        ArgumentChecks.ensureNonNull("methods", methods);
        this.methods = methods;
        this.methodsByName = new ConcurrentHashMap<String, OperationMethod>();
        this.methodsByType = new IdentityHashMap();
        this.lastMethod = new ThreadLocal();
        this.pool = new WeakHashSet<MathTransform>(MathTransform.class);
        this.parser = new AtomicReference();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OperationMethod> getAvailableMethods(Class<? extends SingleOperation> type) {
        OperationMethodSet set;
        ArgumentChecks.ensureNonNull("type", type);
        Object object = this.methodsByType;
        synchronized (object) {
            set = this.methodsByType.get(type);
        }
        if (set == null) {
            OperationMethodSet previous;
            object = this.methods;
            synchronized (object) {
                set = new OperationMethodSet(type, this.methods);
            }
            Map<Class<?>, OperationMethodSet> map = this.methodsByType;
            synchronized (map) {
                previous = this.methodsByType.putIfAbsent(type, set);
            }
            if (previous != null) {
                set = previous;
            }
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationMethod getOperationMethod(String identifier) throws NoSuchIdentifierException {
        identifier = CharSequences.trimWhitespaces(identifier);
        ArgumentChecks.ensureNonEmpty("identifier", identifier);
        OperationMethod method = (OperationMethod)this.methodsByName.get(identifier);
        if (method == null) {
            Iterable<? extends OperationMethod> iterable = this.methods;
            synchronized (iterable) {
                method = CoordinateOperations.getOperationMethod(this.methods, identifier);
            }
            if (method == null) {
                throw new NoSuchIdentifierException(Resources.format((short)50, identifier), identifier);
            }
            OperationMethod previous = this.methodsByName.putIfAbsent(identifier.intern(), method);
            if (previous != null) {
                method = previous;
            }
        }
        return method;
    }

    public ParameterValueGroup getDefaultParameters(String method) throws NoSuchIdentifierException {
        return this.getOperationMethod(method).getParameters().createValue();
    }

    @Deprecated
    public MathTransform createParameterizedTransform(ParameterValueGroup parameters) throws NoSuchIdentifierException, FactoryException {
        return this.createParameterizedTransform(parameters, null);
    }

    public MathTransform createParameterizedTransform(ParameterValueGroup parameters, Context context) throws NoSuchIdentifierException, FactoryException {
        MathTransform transform;
        OperationMethod method = null;
        RuntimeException failure = null;
        try {
            ArgumentChecks.ensureNonNull("parameters", parameters);
            ParameterDescriptorGroup descriptor = parameters.getDescriptor();
            String methodName = descriptor.getName().getCode();
            String methodIdentifier = IdentifiedObjects.toString(IdentifiedObjects.getIdentifier((IdentifiedObject)descriptor, Citations.EPSG));
            if (methodIdentifier == null) {
                methodIdentifier = methodName;
            }
            try {
                method = this.getOperationMethod(methodIdentifier);
            }
            catch (NoSuchIdentifierException exception) {
                if (methodIdentifier.equals(methodName)) {
                    throw exception;
                }
                method = this.getOperationMethod(methodName);
                Logging.recoverableException(Logging.getLogger("org.apache.sis.referencing.operation"), DefaultMathTransformFactory.class, "createParameterizedTransform", exception);
            }
            if (!(method instanceof MathTransformProvider)) {
                throw new NoSuchIdentifierException(Errors.format((short)160, Classes.getClass(method)), methodName);
            }
            try {
                if (context != null) {
                    failure = context.completeParameters(this, method, parameters);
                    parameters = context.parameters;
                    method = context.provider;
                }
                transform = ((MathTransformProvider)method).createMathTransform(this, parameters);
            }
            catch (IllegalArgumentException | IllegalStateException exception) {
                throw new InvalidGeodeticParameterException(exception.getLocalizedMessage(), exception);
            }
            transform = this.unique(transform);
            method = DefaultOperationMethod.redimension(method, transform.getSourceDimensions(), transform.getTargetDimensions());
            if (context != null) {
                transform = this.swapAndScaleAxes(transform, context);
            }
            this.lastMethod.set(method);
            if (context != null) {
                context.provider = null;
            }
        }
        catch (FactoryException e) {
            try {
                if (failure != null) {
                    e.addSuppressed(failure);
                }
                throw e;
            }
            catch (Throwable throwable) {
                this.lastMethod.set(method);
                if (context != null) {
                    context.provider = null;
                }
                throw throwable;
            }
        }
        return transform;
    }

    public MathTransform swapAndScaleAxes(MathTransform parameterized, Context context) throws FactoryException {
        int targetDim;
        int sourceDim;
        int numTrailingCoordinates;
        ArgumentChecks.ensureNonNull("parameterized", parameterized);
        ArgumentChecks.ensureNonNull("context", context);
        Matrix swap1 = context.getMatrix(ContextualParameters.MatrixRole.NORMALIZATION);
        Matrix swap3 = context.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION);
        MathTransform step1 = swap1 != null ? this.createAffineTransform(swap1) : MathTransforms.identity(parameterized.getSourceDimensions());
        MathTransform step3 = swap3 != null ? this.createAffineTransform(swap3) : MathTransforms.identity(parameterized.getTargetDimensions());
        MathTransform step2 = parameterized;
        if (context.provider instanceof VerticalOffset) {
            step2 = VerticalOffset.postCreate(step2, swap3);
        }
        if ((numTrailingCoordinates = step3.getSourceDimensions() - step2.getTargetDimensions()) > 0) {
            step2 = this.createPassThroughTransform(0, step2, numTrailingCoordinates);
        }
        if ((sourceDim = step1.getTargetDimensions()) > (targetDim = step2.getSourceDimensions())) {
            MatrixSIS drop = Matrices.createDiagonal(targetDim + 1, sourceDim + 1);
            drop.setElement(targetDim, sourceDim, 1.0);
            step1 = this.createConcatenatedTransform(this.createAffineTransform(drop), step1);
        }
        MathTransform mt = this.createConcatenatedTransform(this.createConcatenatedTransform(step1, step2), step3);
        if (parameterized instanceof ParameterizedAffine && !(mt instanceof ParameterizedAffine)) {
            mt = ((ParameterizedAffine)parameterized).newTransform(mt);
        }
        return mt;
    }

    @Deprecated
    public MathTransform createBaseToDerived(CoordinateReferenceSystem baseCRS, ParameterValueGroup parameters, CoordinateSystem derivedCS) throws NoSuchIdentifierException, FactoryException {
        ArgumentChecks.ensureNonNull("baseCRS", baseCRS);
        ArgumentChecks.ensureNonNull("parameters", parameters);
        ArgumentChecks.ensureNonNull("derivedCS", derivedCS);
        Context context = ReferencingUtilities.createTransformContext(baseCRS, null, null);
        context.setTarget(derivedCS);
        return this.createParameterizedTransform(parameters, context);
    }

    public MathTransform createCoordinateSystemChange(CoordinateSystem source, CoordinateSystem target, Ellipsoid ellipsoid) throws FactoryException {
        boolean isEllipsoidalSource;
        ArgumentChecks.ensureNonNull("source", source);
        ArgumentChecks.ensureNonNull("target", target);
        if (ellipsoid != null && (isEllipsoidalSource = source instanceof EllipsoidalCS) != target instanceof EllipsoidalCS && (isEllipsoidalSource ? target : source) instanceof CartesianCS) {
            EllipsoidalCS cs;
            String operation;
            Context context = new Context();
            if (isEllipsoidalSource) {
                operation = "Ellipsoid_To_Geocentric";
                cs = (EllipsoidalCS)source;
                context.setSource(cs, ellipsoid);
                context.setTarget(target);
            } else {
                operation = "Geocentric_To_Ellipsoid";
                context.setSource(source);
                cs = (EllipsoidalCS)target;
                context.setTarget(cs, ellipsoid);
            }
            ParameterValueGroup pg = this.getDefaultParameters(operation);
            if (cs.getDimension() < 3) {
                pg.parameter("dim").setValue(2);
            }
            return this.createParameterizedTransform(pg, context);
        }
        return CoordinateSystemTransform.create(this, source, target);
    }

    public MathTransform createAffineTransform(Matrix matrix) throws FactoryException {
        this.lastMethod.remove();
        return this.unique(MathTransforms.linear(matrix));
    }

    public MathTransform createConcatenatedTransform(MathTransform tr1, MathTransform tr2) throws FactoryException {
        MathTransform tr;
        this.lastMethod.remove();
        ArgumentChecks.ensureNonNull("tr1", tr1);
        ArgumentChecks.ensureNonNull("tr2", tr2);
        try {
            tr = ConcatenatedTransform.create(tr1, tr2, this);
        }
        catch (IllegalArgumentException exception) {
            throw new InvalidGeodeticParameterException(exception.getLocalizedMessage(), exception);
        }
        assert (MathTransforms.isValid(MathTransforms.getSteps(tr))) : tr;
        return this.unique(tr);
    }

    public MathTransform createPassThroughTransform(int firstAffectedCoordinate, MathTransform subTransform, int numTrailingCoordinates) throws FactoryException {
        MathTransform tr;
        this.lastMethod.remove();
        try {
            tr = MathTransforms.passThrough(firstAffectedCoordinate, subTransform, numTrailingCoordinates);
        }
        catch (IllegalArgumentException exception) {
            throw new InvalidGeodeticParameterException(exception.getLocalizedMessage(), exception);
        }
        return this.unique(tr);
    }

    @Deprecated
    public MathTransform createFromXML(String xml) throws FactoryException {
        this.lastMethod.remove();
        throw new FactoryException(Errors.format((short)162, "createFromXML"));
    }

    public MathTransform createFromWKT(String text) throws FactoryException {
        Object object;
        this.lastMethod.remove();
        Parser p = this.parser.getAndSet(null);
        if (p == null) {
            try {
                Constructor<? extends Parser> c = parserConstructor;
                if (c == null) {
                    Constructor<? extends Parser> cp = c = Class.forName("org.apache.sis.io.wkt.MathTransformParser").asSubclass(Parser.class).getConstructor(MathTransformFactory.class);
                    AccessController.doPrivileged(() -> {
                        cp.setAccessible(true);
                        return null;
                    });
                    parserConstructor = c;
                }
                p = c.newInstance(this);
            }
            catch (ReflectiveOperationException e) {
                throw new FactoryException((Throwable)e);
            }
        }
        try {
            object = p.createFromWKT(text);
        }
        catch (FactoryException e) {
            for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                if (!(cause instanceof ParameterNotFoundException)) continue;
                throw new InvalidGeodeticParameterException(e.getLocalizedMessage(), cause);
            }
            throw e;
        }
        this.parser.set(p);
        return (MathTransform)object;
    }

    private MathTransform unique(MathTransform tr) {
        return this.pool.unique(tr);
    }

    public OperationMethod getLastMethodUsed() {
        return this.lastMethod.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        Iterable<? extends OperationMethod> iterable = this.methods;
        synchronized (iterable) {
            this.methodsByName.clear();
            Iterable<? extends OperationMethod> m = this.methods;
            if (m instanceof LazySet) {
                ((LazySet)m).reload();
            }
            if (m instanceof ServiceLoader) {
                ((ServiceLoader)m).reload();
            }
            Map<Class<?>, OperationMethodSet> map = this.methodsByType;
            synchronized (map) {
                for (OperationMethodSet c : this.methodsByType.values()) {
                    c.reset();
                }
            }
            this.pool.clear();
        }
    }

    public static class Context
    implements Serializable {
        private static final long serialVersionUID = 6963581151055917955L;
        private CoordinateSystem sourceCS;
        private CoordinateSystem targetCS;
        private Ellipsoid sourceEllipsoid;
        private Ellipsoid targetEllipsoid;
        OperationMethod provider;
        ParameterValueGroup parameters;

        public void setSource(CoordinateSystem cs) {
            this.sourceCS = cs;
            this.sourceEllipsoid = null;
        }

        public void setSource(EllipsoidalCS cs, Ellipsoid ellipsoid) {
            this.sourceCS = cs;
            this.sourceEllipsoid = ellipsoid;
        }

        public void setTarget(CoordinateSystem cs) {
            this.targetCS = cs;
            this.targetEllipsoid = null;
        }

        public void setTarget(EllipsoidalCS cs, Ellipsoid ellipsoid) {
            this.targetCS = cs;
            this.targetEllipsoid = ellipsoid;
        }

        public CoordinateSystem getSourceCS() {
            return this.sourceCS;
        }

        public Ellipsoid getSourceEllipsoid() {
            return this.sourceEllipsoid;
        }

        public CoordinateSystem getTargetCS() {
            return this.targetCS;
        }

        public Ellipsoid getTargetEllipsoid() {
            return this.targetEllipsoid;
        }

        public Matrix getMatrix(ContextualParameters.MatrixRole role) throws FactoryException {
            CoordinateSystem specified;
            boolean inverse = false;
            switch (role) {
                default: {
                    throw new IllegalArgumentException(Errors.format((short)45, "role", (Object)role));
                }
                case INVERSE_NORMALIZATION: {
                    inverse = true;
                }
                case NORMALIZATION: {
                    specified = this.getSourceCS();
                    break;
                }
                case INVERSE_DENORMALIZATION: {
                    inverse = true;
                }
                case DENORMALIZATION: {
                    inverse = !inverse;
                    specified = this.getTargetCS();
                }
            }
            if (specified == null) {
                return null;
            }
            CoordinateSystem normalized = CoordinateSystems.replaceAxes(specified, AxesConvention.NORMALIZED);
            try {
                if (inverse) {
                    return CoordinateSystems.swapAndScaleAxes(normalized, specified);
                }
                return CoordinateSystems.swapAndScaleAxes(specified, normalized);
            }
            catch (IllegalArgumentException | IncommensurableException cause) {
                throw new InvalidGeodeticParameterException(cause.getLocalizedMessage(), cause);
            }
        }

        public ParameterValueGroup getCompletedParameters() {
            if (this.parameters != null) {
                return this.parameters;
            }
            throw new IllegalStateException(Resources.format((short)70));
        }

        private void ensureCompatibleParameters(boolean writable) throws IllegalArgumentException {
            ParameterDescriptorGroup expected = this.provider.getParameters();
            if (this.parameters.getDescriptor() != expected || writable && this.parameters instanceof Parameters && !(this.parameters instanceof DefaultParameterValueGroup)) {
                ParameterValueGroup copy = expected.createValue();
                Parameters.copy(this.parameters, copy);
                this.parameters = copy;
            }
        }

        private static double getValue(ParameterValue<?> parameter, Unit<Length> unit) {
            return parameter.getValue() != null ? parameter.doubleValue(unit) : Double.NaN;
        }

        private static boolean ensureSet(ParameterValue<?> parameter, double actual, double expected, Unit<?> unit, double tolerance) {
            if (Math.abs(actual - expected) <= tolerance) {
                return false;
            }
            if (Double.isNaN(actual)) {
                parameter.setValue(expected, unit);
                return false;
            }
            return true;
        }

        private RuntimeException setEllipsoid(Ellipsoid ellipsoid, String semiMajor, String semiMinor, boolean inverseFlattening, RuntimeException failure) {
            if (ellipsoid != null) {
                boolean isIvfDefinitive;
                this.ensureCompatibleParameters(true);
                ParameterValue mismatchedParam = null;
                double mismatchedValue = 0.0;
                try {
                    ParameterValue ap = this.parameters.parameter(semiMajor);
                    ParameterValue bp = this.parameters.parameter(semiMinor);
                    Unit unit = ellipsoid.getAxisUnit();
                    double a = Context.getValue(ap, (Unit<Length>)unit);
                    double b = Context.getValue(bp, (Unit<Length>)unit);
                    double tol = Units.METRE.getConverterTo(unit).convert(0.01);
                    if (Context.ensureSet(ap, a, ellipsoid.getSemiMajorAxis(), unit, tol)) {
                        mismatchedParam = ap;
                        mismatchedValue = a;
                    }
                    if (Context.ensureSet(bp, b, ellipsoid.getSemiMinorAxis(), unit, tol)) {
                        mismatchedParam = bp;
                        mismatchedValue = b;
                    }
                }
                catch (IllegalArgumentException | IllegalStateException e) {
                    if (failure == null) {
                        failure = e;
                    }
                    failure.addSuppressed(e);
                }
                if (mismatchedParam != null) {
                    LogRecord record = Resources.forLocale(null).getLogRecord(Level.WARNING, (short)33, ellipsoid.getName().getCode(), mismatchedParam.getDescriptor().getName().getCode(), mismatchedValue);
                    record.setLoggerName("org.apache.sis.referencing.operation");
                    Logging.log(DefaultMathTransformFactory.class, "createParameterizedTransform", record);
                    isIvfDefinitive = false;
                } else {
                    boolean bl = isIvfDefinitive = inverseFlattening && ellipsoid.isIvfDefinitive();
                }
                if (isIvfDefinitive) {
                    try {
                        this.parameters.parameter("inverse_flattening").setValue(ellipsoid.getInverseFlattening());
                    }
                    catch (ParameterNotFoundException e) {
                        Logging.recoverableException(Logging.getLogger("org.apache.sis.referencing.operation"), DefaultMathTransformFactory.class, "createParameterizedTransform", e);
                    }
                }
            }
            return failure;
        }

        final RuntimeException completeParameters(DefaultMathTransformFactory factory, OperationMethod method, ParameterValueGroup userParams) throws FactoryException, IllegalArgumentException {
            int n;
            String alt;
            if (method instanceof AbstractProvider && (alt = ((AbstractProvider)method).resolveAmbiguity(this)) != null) {
                method = factory.getOperationMethod(alt);
            }
            this.provider = method;
            this.parameters = userParams;
            if (method instanceof DefaultOperationMethod && method.getClass() != DefaultOperationMethod.class) {
                Integer sourceDim = this.sourceCS != null ? this.sourceCS.getDimension() : method.getSourceDimensions().intValue();
                Integer targetDim = this.targetCS != null ? this.targetCS.getDimension() : method.getTargetDimensions().intValue();
                if (sourceDim != null && targetDim != null && (method = ((DefaultOperationMethod)method).redimension(sourceDim, targetDim)) instanceof MathTransformProvider) {
                    this.provider = method;
                }
            }
            this.ensureCompatibleParameters(false);
            if (this.provider instanceof AbstractProvider) {
                n = ((AbstractProvider)this.provider).getEllipsoidsMask();
            } else {
                n = 0;
                if (this.sourceEllipsoid != null) {
                    n = 1;
                }
                if (this.targetEllipsoid != null) {
                    n |= 2;
                }
            }
            switch (n) {
                case 0: {
                    return null;
                }
                case 1: {
                    return this.setEllipsoid(this.getSourceEllipsoid(), "semi_major", "semi_minor", true, null);
                }
                case 2: {
                    return this.setEllipsoid(this.getTargetEllipsoid(), "semi_major", "semi_minor", true, null);
                }
                case 3: {
                    RuntimeException failure = null;
                    if (this.sourceCS != null) {
                        try {
                            this.ensureCompatibleParameters(true);
                            ParameterValue p = this.parameters.parameter("dim");
                            if (p.getValue() == null) {
                                p.setValue(this.sourceCS.getDimension());
                            }
                        }
                        catch (IllegalArgumentException | IllegalStateException e) {
                            failure = e;
                        }
                    }
                    failure = this.setEllipsoid(this.getSourceEllipsoid(), "src_semi_major", "src_semi_minor", false, failure);
                    failure = this.setEllipsoid(this.getTargetEllipsoid(), "tgt_semi_major", "tgt_semi_minor", false, failure);
                    return failure;
                }
            }
            throw new AssertionError(n);
        }
    }
}

