/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.awt.Shape;
import java.awt.geom.Point2D;
import org.apache.sis.geometry.DirectPosition2D;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform2D;
import org.apache.sis.referencing.operation.transform.ConcatenatedTransform;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

final class ConcatenatedTransform2D
extends ConcatenatedTransform
implements MathTransform2D {
    private static final long serialVersionUID = -7307709788564866500L;

    ConcatenatedTransform2D(MathTransform transform1, MathTransform transform2) {
        super(transform1, transform2);
    }

    @Override
    boolean isValid() {
        return super.isValid() && this.getSourceDimensions() == 2 && this.getTargetDimensions() == 2;
    }

    public Point2D transform(Point2D ptSrc, Point2D ptDst) throws TransformException {
        double[] ord = new double[]{ptSrc.getX(), ptSrc.getY()};
        this.transform(ord, 0, ord, 0, false);
        if (ptDst != null) {
            ptDst.setLocation(ord[0], ord[1]);
            return ptDst;
        }
        return new Point2D.Double(ord[0], ord[1]);
    }

    public Shape createTransformedShape(Shape shape) throws TransformException {
        return AbstractMathTransform2D.createTransformedShape(this, shape, null, null, false);
    }

    public Matrix derivative(Point2D point) throws TransformException {
        return super.derivative((DirectPosition)(point instanceof DirectPosition ? (DirectPosition)point : new DirectPosition2D(point.getX(), point.getY())));
    }

    public MathTransform2D inverse() throws NoninvertibleTransformException {
        return (MathTransform2D)super.inverse();
    }
}

