/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import org.apache.sis.referencing.operation.matrix.Matrix1;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

public abstract class AbstractMathTransform1D
extends AbstractMathTransform
implements MathTransform1D {
    protected AbstractMathTransform1D() {
    }

    @Override
    public final int getSourceDimensions() {
        return 1;
    }

    @Override
    public final int getTargetDimensions() {
        return 1;
    }

    public abstract double transform(double var1) throws TransformException;

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws TransformException {
        double coordinate = srcPts[srcOff];
        if (dstPts != null) {
            dstPts[dstOff] = this.transform(coordinate);
        }
        return derivate ? new Matrix1(this.derivative(coordinate)) : null;
    }

    public abstract double derivative(double var1) throws TransformException;

    @Override
    public Matrix derivative(DirectPosition point) throws TransformException {
        double coordinate;
        if (point == null) {
            coordinate = Double.NaN;
        } else {
            ArgumentChecks.ensureDimensionMatches("point", 1, point);
            coordinate = point.getOrdinate(0);
        }
        return new Matrix1(this.derivative(coordinate));
    }

    public MathTransform1D inverse() throws NoninvertibleTransformException {
        return (MathTransform1D)super.inverse();
    }

    protected static abstract class Inverse
    extends AbstractMathTransform.Inverse
    implements MathTransform1D {
        protected Inverse() {
        }

        public abstract MathTransform1D inverse();

        @Override
        public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws TransformException {
            double coordinate = srcPts[srcOff];
            if (dstPts != null) {
                dstPts[dstOff] = this.transform(coordinate);
            }
            return derivate ? new Matrix1(this.derivative(coordinate)) : null;
        }

        @Override
        public Matrix derivative(DirectPosition point) throws TransformException {
            double coordinate;
            if (point == null) {
                coordinate = Double.NaN;
            } else {
                ArgumentChecks.ensureDimensionMatches("point", 1, point);
                coordinate = point.getOrdinate(0);
            }
            return new Matrix1(this.derivative(coordinate));
        }
    }
}

