/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;

abstract class MeridianArcBased
extends NormalizedProjection {
    private static final long serialVersionUID = 6105123637473385555L;
    private final double cf0;
    private final double cf1;
    private final double cf2;
    private final double cf3;
    private final double cf4;
    private final double ci1;
    private final double ci2;
    private final double ci3;
    private final double ci4;
    private final double r\u00b5;

    MeridianArcBased(Initializer initializer) {
        super(initializer);
        double e2 = this.eccentricitySquared;
        double e4 = e2 * e2;
        double e6 = e2 * e4;
        double e8 = e4 * e4;
        double e10 = e2 * e8;
        this.cf0 = -0.0067291259765625 * e10 + -0.01068115234375 * e8 + -0.01953125 * e6 + -0.046875 * e4 + -0.25 * e2 + 1.0;
        this.cf1 = 0.01201629638671875 * e10 + 0.01068115234375 * e8 + 0.01953125 * e6 + 0.046875 * e4 + -0.75 * e2;
        this.cf2 = -0.080108642578125 * e10 + 0.007120768229166667 * e8 + 0.013020833333333334 * e6 + -0.46875 * e4;
        this.cf3 = 0.35888671875 * e10 + 0.005696614583333333 * e8 + -0.3645833333333333 * e6;
        this.cf4 = -0.538330078125 * e10 + -0.3076171875 * e8;
        this.r\u00b5 = 1.0 - 0.25 * e2 - 0.046875 * e4 - 0.01953125 * e6;
        DoubleDouble e1 = initializer.axisLengthRatio();
        e1.ratio_1m_1p();
        double ei = e1.doubleValue();
        double ei2 = ei * ei;
        double ei3 = ei * ei2;
        double ei4 = ei2 * ei2;
        this.ci1 = 10.265625 * ei4 + 7.75 * ei3 + 5.25 * ei2 + 3.0 * ei;
        this.ci2 = -157.65625 * ei4 + -50.333333333333336 * ei3 + -10.5 * ei2;
        this.ci3 = 411.375 * ei4 + 50.333333333333336 * ei3;
        this.ci4 = -274.25 * ei4;
    }

    MeridianArcBased(MeridianArcBased other) {
        super(other);
        this.cf0 = other.cf0;
        this.cf1 = other.cf1;
        this.cf2 = other.cf2;
        this.cf3 = other.cf3;
        this.cf4 = other.cf4;
        this.ci1 = other.ci1;
        this.ci2 = other.ci2;
        this.ci3 = other.ci3;
        this.ci4 = other.ci4;
        this.r\u00b5 = other.r\u00b5;
    }

    final double distance(double \u03c6, double sin\u03c6, double cos\u03c6) {
        double sin\u03c62 = sin\u03c6 * sin\u03c6;
        return this.cf0 * \u03c6 + cos\u03c6 * sin\u03c6 * (this.cf1 + sin\u03c62 * (this.cf2 + sin\u03c62 * (this.cf3 + sin\u03c62 * this.cf4)));
    }

    final double dM_d\u03c6(double sin\u03c62) {
        return ((((7.0 - 8.0 * sin\u03c62) * this.cf4 - 6.0 * this.cf3) * sin\u03c62 + 5.0 * this.cf3 - 4.0 * this.cf2) * sin\u03c62 + 3.0 * this.cf2 - 2.0 * this.cf1) * sin\u03c62 + this.cf1 + this.cf0;
    }

    final double latitude(double distance) {
        double \u03c6 = distance / this.r\u00b5;
        double sin\u03c6 = Math.sin(\u03c6);
        double sin\u03c62 = sin\u03c6 * sin\u03c6;
        \u03c6 += Math.cos(\u03c6) * sin\u03c6 * (this.ci1 + sin\u03c62 * (this.ci2 + sin\u03c62 * (this.ci3 + sin\u03c62 * this.ci4)));
        return \u03c6;
    }
}

