/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.matrix;

import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.matrix.MismatchedMatrixSizeException;
import org.opengis.referencing.operation.Matrix;

public final class Matrix4
extends MatrixSIS {
    private static final long serialVersionUID = 5685762518066856310L;
    public static final int SIZE = 4;
    public double m00;
    public double m01;
    public double m02;
    public double m03;
    public double m10;
    public double m11;
    public double m12;
    public double m13;
    public double m20;
    public double m21;
    public double m22;
    public double m23;
    public double m30;
    public double m31;
    public double m32;
    public double m33;

    public Matrix4() {
        this.m33 = 1.0;
        this.m22 = 1.0;
        this.m11 = 1.0;
        this.m00 = 1.0;
    }

    Matrix4(boolean ignore) {
    }

    public Matrix4(double m00, double m01, double m02, double m03, double m10, double m11, double m12, double m13, double m20, double m21, double m22, double m23, double m30, double m31, double m32, double m33) {
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m03 = m03;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
        this.m13 = m13;
        this.m20 = m20;
        this.m21 = m21;
        this.m22 = m22;
        this.m23 = m23;
        this.m30 = m30;
        this.m31 = m31;
        this.m32 = m32;
        this.m33 = m33;
    }

    public Matrix4(double[] elements) throws IllegalArgumentException {
        this.setElements(elements);
    }

    Matrix4(Matrix matrix) throws IllegalArgumentException {
        for (int j = 0; j < 4; ++j) {
            for (int i = 0; i < 4; ++i) {
                this.setElement(j, i, matrix.getElement(j, i));
            }
        }
    }

    public static Matrix4 castOrCopy(Matrix matrix) throws MismatchedMatrixSizeException {
        if (matrix == null || matrix instanceof Matrix4) {
            return (Matrix4)matrix;
        }
        Matrix4.ensureSizeMatch(4, 4, matrix);
        return new Matrix4(matrix);
    }

    public final int getNumRow() {
        return 4;
    }

    public final int getNumCol() {
        return 4;
    }

    @Override
    public final double getElement(int row, int column) {
        if (row >= 0 && row < 4 && column >= 0 && column < 4) {
            switch (row * 4 + column) {
                case 0: {
                    return this.m00;
                }
                case 1: {
                    return this.m01;
                }
                case 2: {
                    return this.m02;
                }
                case 3: {
                    return this.m03;
                }
                case 4: {
                    return this.m10;
                }
                case 5: {
                    return this.m11;
                }
                case 6: {
                    return this.m12;
                }
                case 7: {
                    return this.m13;
                }
                case 8: {
                    return this.m20;
                }
                case 9: {
                    return this.m21;
                }
                case 10: {
                    return this.m22;
                }
                case 11: {
                    return this.m23;
                }
                case 12: {
                    return this.m30;
                }
                case 13: {
                    return this.m31;
                }
                case 14: {
                    return this.m32;
                }
                case 15: {
                    return this.m33;
                }
            }
        }
        throw Matrix4.indexOutOfBounds(row, column);
    }

    public final void setElement(int row, int column, double value) {
        if (row >= 0 && row < 4 && column >= 0 && column < 4) {
            switch (row * 4 + column) {
                case 0: {
                    this.m00 = value;
                    return;
                }
                case 1: {
                    this.m01 = value;
                    return;
                }
                case 2: {
                    this.m02 = value;
                    return;
                }
                case 3: {
                    this.m03 = value;
                    return;
                }
                case 4: {
                    this.m10 = value;
                    return;
                }
                case 5: {
                    this.m11 = value;
                    return;
                }
                case 6: {
                    this.m12 = value;
                    return;
                }
                case 7: {
                    this.m13 = value;
                    return;
                }
                case 8: {
                    this.m20 = value;
                    return;
                }
                case 9: {
                    this.m21 = value;
                    return;
                }
                case 10: {
                    this.m22 = value;
                    return;
                }
                case 11: {
                    this.m23 = value;
                    return;
                }
                case 12: {
                    this.m30 = value;
                    return;
                }
                case 13: {
                    this.m31 = value;
                    return;
                }
                case 14: {
                    this.m32 = value;
                    return;
                }
                case 15: {
                    this.m33 = value;
                    return;
                }
            }
        }
        throw Matrix4.indexOutOfBounds(row, column);
    }

    @Override
    public final double[] getElements() {
        double[] elements = new double[16];
        this.getElements(elements);
        return elements;
    }

    @Override
    final void getElements(double[] elements) {
        elements[0] = this.m00;
        elements[1] = this.m01;
        elements[2] = this.m02;
        elements[3] = this.m03;
        elements[4] = this.m10;
        elements[5] = this.m11;
        elements[6] = this.m12;
        elements[7] = this.m13;
        elements[8] = this.m20;
        elements[9] = this.m21;
        elements[10] = this.m22;
        elements[11] = this.m23;
        elements[12] = this.m30;
        elements[13] = this.m31;
        elements[14] = this.m32;
        elements[15] = this.m33;
    }

    @Override
    public final void setElements(double[] elements) {
        Matrix4.ensureLengthMatch(16, elements);
        this.m00 = elements[0];
        this.m01 = elements[1];
        this.m02 = elements[2];
        this.m03 = elements[3];
        this.m10 = elements[4];
        this.m11 = elements[5];
        this.m12 = elements[6];
        this.m13 = elements[7];
        this.m20 = elements[8];
        this.m21 = elements[9];
        this.m22 = elements[10];
        this.m23 = elements[11];
        this.m30 = elements[12];
        this.m31 = elements[13];
        this.m32 = elements[14];
        this.m33 = elements[15];
    }

    @Override
    public final boolean isAffine() {
        return this.m30 == 0.0 && this.m31 == 0.0 && this.m32 == 0.0 && this.m33 == 1.0;
    }

    @Override
    public final boolean isIdentity() {
        return this.m00 == 1.0 && this.m01 == 0.0 && this.m02 == 0.0 && this.m03 == 0.0 && this.m10 == 0.0 && this.m11 == 1.0 && this.m12 == 0.0 && this.m13 == 0.0 && this.m20 == 0.0 && this.m21 == 0.0 && this.m22 == 1.0 && this.m23 == 0.0 && this.isAffine();
    }

    @Override
    public void transpose() {
        double swap = this.m01;
        this.m01 = this.m10;
        this.m10 = swap;
        swap = this.m02;
        this.m02 = this.m20;
        this.m20 = swap;
        swap = this.m03;
        this.m03 = this.m30;
        this.m30 = swap;
        swap = this.m12;
        this.m12 = this.m21;
        this.m21 = swap;
        swap = this.m13;
        this.m13 = this.m31;
        this.m31 = swap;
        swap = this.m23;
        this.m23 = this.m32;
        this.m32 = swap;
    }
}

