/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.matrix;

import org.apache.sis.internal.util.Numerics;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.matrix.MismatchedMatrixSizeException;
import org.opengis.referencing.operation.Matrix;

public final class Matrix2
extends MatrixSIS {
    private static final long serialVersionUID = 7116561372481474290L;
    public static final int SIZE = 2;
    public double m00;
    public double m01;
    public double m10;
    public double m11;

    public Matrix2() {
        this.m11 = 1.0;
        this.m00 = 1.0;
    }

    Matrix2(boolean ignore) {
    }

    public Matrix2(double m00, double m01, double m10, double m11) {
        this.m00 = m00;
        this.m01 = m01;
        this.m10 = m10;
        this.m11 = m11;
    }

    public Matrix2(double[] elements) throws IllegalArgumentException {
        this.setElements(elements);
    }

    Matrix2(Matrix matrix) {
        this.m00 = matrix.getElement(0, 0);
        this.m01 = matrix.getElement(0, 1);
        this.m10 = matrix.getElement(1, 0);
        this.m11 = matrix.getElement(1, 1);
    }

    public static Matrix2 castOrCopy(Matrix matrix) throws MismatchedMatrixSizeException {
        if (matrix == null || matrix instanceof Matrix2) {
            return (Matrix2)matrix;
        }
        Matrix2.ensureSizeMatch(2, 2, matrix);
        return new Matrix2(matrix);
    }

    public final int getNumRow() {
        return 2;
    }

    public final int getNumCol() {
        return 2;
    }

    @Override
    public final double getElement(int row, int column) {
        if (row >= 0 && row < 2 && column >= 0 && column < 2) {
            switch (row * 2 + column) {
                case 0: {
                    return this.m00;
                }
                case 1: {
                    return this.m01;
                }
                case 2: {
                    return this.m10;
                }
                case 3: {
                    return this.m11;
                }
            }
        }
        throw Matrix2.indexOutOfBounds(row, column);
    }

    public final void setElement(int row, int column, double value) {
        if (row >= 0 && row < 2 && column >= 0 && column < 2) {
            switch (row * 2 + column) {
                case 0: {
                    this.m00 = value;
                    return;
                }
                case 1: {
                    this.m01 = value;
                    return;
                }
                case 2: {
                    this.m10 = value;
                    return;
                }
                case 3: {
                    this.m11 = value;
                    return;
                }
            }
        }
        throw Matrix2.indexOutOfBounds(row, column);
    }

    @Override
    public final double[] getElements() {
        double[] elements = new double[4];
        this.getElements(elements);
        return elements;
    }

    @Override
    final void getElements(double[] elements) {
        elements[0] = this.m00;
        elements[1] = this.m01;
        elements[2] = this.m10;
        elements[3] = this.m11;
    }

    @Override
    public final void setElements(double[] elements) {
        Matrix2.ensureLengthMatch(4, elements);
        this.m00 = elements[0];
        this.m01 = elements[1];
        this.m10 = elements[2];
        this.m11 = elements[3];
    }

    @Override
    public final boolean isAffine() {
        return this.m10 == 0.0 && this.m11 == 1.0;
    }

    @Override
    public final boolean isIdentity() {
        return this.m00 == 1.0 && this.m10 == 0.0 && this.m01 == 0.0 && this.m11 == 1.0;
    }

    @Override
    public void transpose() {
        double swap = this.m10;
        this.m10 = this.m01;
        this.m01 = swap;
    }

    @Override
    public void normalizeColumns() {
        double m = Math.hypot(this.m00, this.m10);
        this.m00 /= m;
        this.m10 /= m;
        m = Math.hypot(this.m01, this.m11);
        this.m01 /= m;
        this.m11 /= m;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof Matrix2) {
            Matrix2 that = (Matrix2)object;
            return Numerics.equals(this.m00, that.m00) && Numerics.equals(this.m01, that.m01) && Numerics.equals(this.m10, that.m10) && Numerics.equals(this.m11, that.m11);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Long.hashCode(0x62C31ADCF5064EF2L ^ Double.doubleToLongBits(this.m00) + 31L * Double.doubleToLongBits(this.m01) + 31L * Double.doubleToLongBits(this.m10) + 31L * Double.doubleToLongBits(this.m11));
    }
}

