/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.matrix;

import java.util.Arrays;
import org.apache.sis.internal.referencing.ExtendedPrecisionMatrix;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.matrix.MismatchedMatrixSizeException;
import org.apache.sis.referencing.operation.matrix.NonSquareMatrix;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.operation.Matrix;

class GeneralMatrix
extends MatrixSIS
implements ExtendedPrecisionMatrix {
    private static final long serialVersionUID = 8447482612423035360L;
    private static final double ZERO_THRESHOLD = 1.0E-14;
    final double[] elements;
    short numRow;
    short numCol;

    GeneralMatrix(int numRow, int numCol, boolean setToIdentity, int precision) {
        GeneralMatrix.ensureValidSize(numRow, numCol);
        this.numRow = (short)numRow;
        this.numCol = (short)numCol;
        this.elements = new double[numRow * numCol * precision];
        if (setToIdentity) {
            int stop = Math.min(numRow, numCol) * numCol;
            for (int i = 0; i < stop; i += numCol + 1) {
                this.elements[i] = 1.0;
            }
        }
    }

    GeneralMatrix(int numRow, int numCol, double[] elements) {
        GeneralMatrix.ensureValidSize(numRow, numCol);
        GeneralMatrix.ensureLengthMatch(numRow * numCol, elements);
        this.numRow = (short)numRow;
        this.numCol = (short)numCol;
        this.elements = (double[])elements.clone();
    }

    GeneralMatrix(Matrix matrix) {
        int numRow = matrix.getNumRow();
        int numCol = matrix.getNumCol();
        GeneralMatrix.ensureValidSize(numRow, numCol);
        this.numRow = (short)numRow;
        this.numCol = (short)numCol;
        if (matrix instanceof ExtendedPrecisionMatrix) {
            this.elements = ((ExtendedPrecisionMatrix)matrix).getExtendedElements();
            assert (this.elements.length % (numRow * numCol) == 0);
        } else {
            this.elements = new double[numRow * numCol];
            GeneralMatrix.getElements(matrix, numRow, numCol, this.elements);
        }
    }

    GeneralMatrix(GeneralMatrix matrix) {
        this.numRow = matrix.numRow;
        this.numCol = matrix.numCol;
        this.elements = (double[])matrix.elements.clone();
    }

    static GeneralMatrix createExtendedPrecision(int numRow, int numCol, boolean setToIdentity) {
        if (numRow == numCol) {
            return new GeneralMatrix(numRow, numCol, setToIdentity, 2);
        }
        return new NonSquareMatrix(numRow, numCol, setToIdentity, 2);
    }

    static void inferErrors(double[] elements) {
        int length;
        for (int i = length = elements.length / 2; i < elements.length; ++i) {
            elements[i] = DoubleDouble.errorForWellKnownValue(elements[i - length]);
        }
    }

    static int indexOfErrors(int numRow, int numCol, double[] elements) {
        assert (elements.length % (numRow * numCol) == 0);
        return numRow * numCol % elements.length;
    }

    private static void ensureValidSize(int numRow, int numCol) {
        ArgumentChecks.ensureBetween("numRow", 1, Short.MAX_VALUE, numRow);
        ArgumentChecks.ensureBetween("numCol", 1, Short.MAX_VALUE, numCol);
    }

    public final int getNumRow() {
        return this.numRow;
    }

    public final int getNumCol() {
        return this.numCol;
    }

    @Override
    final boolean isExtendedPrecision() {
        return this.elements.length > this.numRow * this.numCol;
    }

    @Override
    final void get(int row, int column, DoubleDouble dd) {
        int i = row * this.numCol + column;
        dd.value = this.elements[i];
        if ((i += this.numRow * this.numCol) < this.elements.length) {
            dd.error = this.elements[i];
            assert (dd.equals(this.getNumber(row, column)));
        } else {
            dd.error = DoubleDouble.errorForWellKnownValue(dd.value);
        }
    }

    @Override
    final void set(int row, int column, DoubleDouble dd) {
        int iv = row * this.numCol + column;
        int ie = iv + this.numRow * this.numCol;
        if (ie < this.elements.length) {
            this.elements[iv] = dd.value;
            this.elements[ie] = dd.error;
            assert (dd.equals(this.getNumber(row, column)));
        } else {
            this.elements[iv] = dd.doubleValue();
        }
    }

    @Override
    public Number getNumber(int row, int column) {
        if (row >= 0 && row < this.numRow && column >= 0 && column < this.numCol) {
            int i = row * this.numCol + column;
            double value = this.elements[i];
            if ((i += this.numRow * this.numCol) < this.elements.length) {
                return new DoubleDouble(value, this.elements[i]);
            }
            return value;
        }
        throw GeneralMatrix.indexOutOfBounds(row, column);
    }

    @Override
    public final double getElement(int row, int column) {
        if (row >= 0 && row < this.numRow && column >= 0 && column < this.numCol) {
            return this.elements[row * this.numCol + column];
        }
        throw GeneralMatrix.indexOutOfBounds(row, column);
    }

    public final void setElement(int row, int column, double value) {
        if (row >= 0 && row < this.numRow && column >= 0 && column < this.numCol) {
            int i = row * this.numCol + column;
            this.elements[i] = value;
            if ((i += this.numRow * this.numCol) < this.elements.length) {
                this.elements[i] = DoubleDouble.errorForWellKnownValue(value);
            }
        } else {
            throw GeneralMatrix.indexOutOfBounds(row, column);
        }
    }

    static double[] getExtendedElements(Matrix matrix, int numRow, int numCol, boolean copy) {
        double[] elements;
        int length = numRow * numCol * 2;
        if (matrix instanceof GeneralMatrix) {
            elements = ((GeneralMatrix)matrix).elements;
            if (elements.length == length) {
                if (copy) {
                    elements = (double[])elements.clone();
                }
                return elements;
            }
            elements = Arrays.copyOf(elements, length);
        } else if (matrix instanceof ExtendedPrecisionMatrix) {
            elements = ((ExtendedPrecisionMatrix)matrix).getExtendedElements();
            if (elements.length == length) {
                return elements;
            }
            elements = Arrays.copyOf(elements, length);
        } else {
            elements = new double[length];
            GeneralMatrix.getElements(matrix, numRow, numCol, elements);
        }
        GeneralMatrix.inferErrors(elements);
        return elements;
    }

    @Override
    public final double[] getExtendedElements() {
        return (double[])this.elements.clone();
    }

    @Override
    public final double[] getElements() {
        return Arrays.copyOf(this.elements, this.numRow * this.numCol);
    }

    @Override
    final void getElements(double[] dest) {
        System.arraycopy(this.elements, 0, dest, 0, this.numRow * this.numCol);
    }

    @Override
    public final void setElements(double[] newValues) {
        GeneralMatrix.ensureLengthMatch(this.numRow * this.numCol, newValues);
        System.arraycopy(newValues, 0, this.elements, 0, newValues.length);
        if (this.elements.length != newValues.length) {
            GeneralMatrix.inferErrors(newValues);
        }
    }

    final boolean setElements(Number[] newValues) {
        short numRow = this.numRow;
        short numCol = this.numCol;
        int length = numRow * numCol;
        if (newValues.length != length) {
            throw new IllegalArgumentException(Errors.format((short)133, length, newValues.length));
        }
        boolean isExtended = false;
        for (int i = 0; i < length; ++i) {
            double error;
            double element;
            Number value = newValues[i];
            if (DoubleDouble.shouldConvert(value)) {
                value = new DoubleDouble(value);
            }
            this.elements[i] = element = value.doubleValue();
            if (value instanceof DoubleDouble) {
                error = ((DoubleDouble)value).error;
                if (!isExtended) {
                    isExtended = true;
                    for (int j = 0; j < i; ++j) {
                        this.elements[j + length] = DoubleDouble.errorForWellKnownValue(this.elements[j]);
                    }
                }
            } else {
                if (!isExtended) continue;
                error = DoubleDouble.errorForWellKnownValue(element);
            }
            this.elements[i + length] = error;
        }
        return isExtended;
    }

    @Override
    public void setMatrix(Matrix matrix) throws MismatchedMatrixSizeException {
        if (matrix instanceof GeneralMatrix) {
            GeneralMatrix gm = (GeneralMatrix)matrix;
            GeneralMatrix.ensureSizeMatch(this.numRow, this.numCol, matrix);
            int length = gm.elements.length;
            if (this.elements.length <= length) {
                System.arraycopy(gm.elements, 0, this.elements, 0, this.elements.length);
            } else {
                System.arraycopy(gm.elements, 0, this.elements, 0, length);
                GeneralMatrix.inferErrors(this.elements);
            }
        } else {
            super.setMatrix(matrix);
        }
    }

    @Override
    public final boolean isAffine() {
        return this.isAffine(true);
    }

    final boolean isAffine(boolean square) {
        short numRow = this.numRow;
        short numCol = this.numCol;
        if (numRow == numCol || !square) {
            int i = numRow * numCol;
            if (this.elements[--i] == 1.0) {
                int base = (numRow - 1) * numCol;
                while (--i >= base) {
                    if (this.elements[i] == 0.0) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public final boolean isIdentity() {
        short numRow = this.numRow;
        short numCol = this.numCol;
        if (numRow != numCol) {
            return false;
        }
        int di = 0;
        int length = numRow * numCol;
        for (int i = 0; i < length; ++i) {
            double element = this.elements[i];
            if (i == di) {
                if (element != 1.0) {
                    return false;
                }
                di += numCol + 1;
                continue;
            }
            if (element == 0.0) continue;
            return false;
        }
        return true;
    }

    @Override
    public void transpose() {
        int numRow = this.numRow;
        short numCol = this.numCol;
        int errors = GeneralMatrix.indexOfErrors(numRow, numCol, this.elements);
        for (int j = 0; j < numRow; ++j) {
            for (int i = 0; i < j; ++i) {
                int lo = j * numCol + i;
                int up = i * numCol + j;
                ArraysExt.swap(this.elements, lo, up);
                if (errors == 0) continue;
                ArraysExt.swap(this.elements, lo + errors, up + errors);
            }
        }
    }

    final void setToProduct(Matrix A, Matrix B) {
        int numRow = this.numRow;
        int numCol = this.numCol;
        int nc = A.getNumCol();
        assert (B.getNumRow() == nc);
        assert (numRow == A.getNumRow() && numCol == B.getNumCol());
        double[] eltA = GeneralMatrix.getExtendedElements(A, numRow, nc, false);
        double[] eltB = GeneralMatrix.getExtendedElements(B, nc, numCol, false);
        int errorOffset = numRow * numCol;
        int errA = numRow * nc;
        int errB = nc * numCol;
        DoubleDouble dot = new DoubleDouble();
        DoubleDouble sum = new DoubleDouble();
        int k = 0;
        for (int j = 0; j < numRow; ++j) {
            for (int i = 0; i < numCol; ++i) {
                int iA;
                sum.clear();
                double max = 0.0;
                int iB = i;
                int nextRow = iA + nc;
                for (iA = j * nc; iA < nextRow; ++iA) {
                    dot.setFrom(eltA, iA, errA);
                    if (!dot.isZero()) {
                        double vB = eltB[iB];
                        double eB = eltB[iB + errB];
                        if (vB != 0.0 || eB != 0.0) {
                            dot.multiply(vB, eB);
                            sum.add(dot);
                            double value = Math.abs(dot.value);
                            if (value > max) {
                                max = value;
                            }
                        }
                    }
                    iB += numCol;
                }
                if (Math.abs(sum.value) < Math.ulp(max) * 1.0E-14) {
                    sum.clear();
                }
                sum.storeTo(this.elements, k++, errorOffset);
            }
        }
    }

    @Override
    public final boolean equals(Object object) {
        if (object instanceof GeneralMatrix) {
            GeneralMatrix that = (GeneralMatrix)object;
            return this.numRow == that.numRow && this.numCol == that.numCol && Arrays.equals(this.elements, that.elements);
        }
        return false;
    }

    @Override
    public final int hashCode() {
        return (this.numRow << 16 | this.numCol) ^ Arrays.hashCode(this.elements) ^ 0xE7C389E0;
    }

    @Override
    public MatrixSIS clone() {
        return new GeneralMatrix(this);
    }
}

