/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.builder;

import java.util.Arrays;
import java.util.function.Function;
import javax.measure.quantity.Dimensionless;
import org.apache.sis.internal.referencing.WKTUtilities;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.math.Statistics;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.Units;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.datum.DatumShiftGrid;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.operation.Matrix;

final class ResidualGrid
extends DatumShiftGrid<Dimensionless, Dimensionless> {
    private static final long serialVersionUID = 5207799661806374259L;
    static final int SOURCE_DIMENSION = 2;
    private static final ParameterDescriptorGroup PARAMETERS;
    private final int nx;
    private final float[] offsets;
    final LinearTransform gridToTarget;
    private final double accuracy;

    @Override
    public void getParameterValues(Parameters parameters) {
        Matrix denormalization = this.gridToTarget.getMatrix();
        if (parameters instanceof ContextualParameters) {
            MatrixSIS m = ((ContextualParameters)parameters).getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION);
            m.setMatrix(denormalization);
        }
        int[] size = this.getGridSize();
        parameters.parameter("num_row").setValue(size[1]);
        parameters.parameter("num_col").setValue(size[0]);
        parameters.parameter("grid_x").setValue((Object)new Data(0, denormalization));
        parameters.parameter("grid_y").setValue((Object)new Data(1, denormalization));
    }

    ResidualGrid(LinearTransform sourceToGrid, LinearTransform gridToTarget, int nx, int ny, float[] residuals, double precision) {
        super(Units.UNITY, sourceToGrid, new int[]{nx, ny}, true, Units.UNITY);
        this.gridToTarget = gridToTarget;
        this.offsets = residuals;
        this.accuracy = precision;
        this.nx = nx;
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return PARAMETERS;
    }

    @Override
    public int getTranslationDimensions() {
        return 2;
    }

    @Override
    public double getCellPrecision() {
        return this.accuracy;
    }

    @Override
    public double getCellValue(int dim, int gridX, int gridY) {
        return this.offsets[(gridX + gridY * this.nx) * 2 + dim];
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (super.equals(other)) {
            ResidualGrid that = (ResidualGrid)other;
            return Numerics.equals(this.accuracy, that.accuracy) && this.gridToTarget.equals(that.gridToTarget) && Arrays.equals(this.offsets, that.offsets);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Arrays.hashCode(this.offsets) + 37 * this.gridToTarget.hashCode();
    }

    static {
        ParameterBuilder builder = new ParameterBuilder().setRequired(true);
        ParameterDescriptor[] grids = new ParameterDescriptor[]{((ParameterBuilder)builder.addName("num_row")).createBounded(Integer.class, Integer.valueOf(2), null, null), ((ParameterBuilder)builder.addName("num_col")).createBounded(Integer.class, Integer.valueOf(2), null, null), ((ParameterBuilder)builder.addName("grid_x")).create(Matrix.class, null), ((ParameterBuilder)builder.addName("grid_y")).create(Matrix.class, null)};
        PARAMETERS = ((ParameterBuilder)builder.addName("Localization grid")).createGroup((GeneralParameterDescriptor[])grids);
    }

    private final class Data
    extends FormattableObject
    implements Matrix,
    Function<int[], Number> {
        private final double c0;
        private final double c1;
        private final double c2;

        Data(int dim, Matrix denormalization) {
            this.c0 = denormalization.getElement(dim, 0);
            this.c1 = denormalization.getElement(dim, 1);
            this.c2 = denormalization.getElement(dim, 2);
        }

        public Matrix clone() {
            return this;
        }

        public boolean isIdentity() {
            return false;
        }

        public int getNumCol() {
            return ResidualGrid.this.nx;
        }

        public int getNumRow() {
            return ResidualGrid.this.getGridSize()[1];
        }

        @Override
        public Number apply(int[] p) {
            return this.getElement(p[1], p[0]);
        }

        public void setElement(int y, int x, double v) {
            throw new UnsupportedOperationException();
        }

        public double getElement(int y, int x) {
            return this.c0 * ((double)x + ResidualGrid.this.getCellValue(0, x, y)) + this.c1 * ((double)y + ResidualGrid.this.getCellValue(1, x, y)) + this.c2;
        }

        @Override
        public String toString() {
            int[] size = ResidualGrid.this.getGridSize();
            return new StringBuilder(80).append('[').append(this.getElement(0, 0)).append(", \u2026, ").append(this.getElement(size[1] - 1, size[0] - 1)).append(']').toString();
        }

        @Override
        protected String formatTo(Formatter formatter) {
            Object[] numbers = WKTUtilities.cornersAndCenter(this, ResidualGrid.this.getGridSize(), 3);
            Vector[] rows = new Vector[numbers.length];
            Statistics stats = new Statistics(null);
            Vector before = null;
            for (int j = 0; j < rows.length; ++j) {
                Vector row = Vector.create(numbers[j], false);
                Number right = null;
                int i = row.size();
                while (--i >= 0) {
                    Number n = row.get(i);
                    if (n != null) {
                        Number up;
                        double value = n.doubleValue();
                        if (right != null) {
                            stats.accept(Math.abs(right.doubleValue() - value));
                        }
                        if (before != null && (up = before.get(i)) != null) {
                            stats.accept(Math.abs(up.doubleValue() - value));
                        }
                    }
                    right = n;
                }
                before = row;
                rows[j] = row;
            }
            int accuracy = Numerics.suggestFractionDigits(stats);
            formatter.newLine();
            formatter.append(rows, Math.max(0, accuracy));
            formatter.setInvalidWKT(Matrix.class, null);
            return "Matrix";
        }
    }
}

