/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.referencing.PositionalAccuracyConstant;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.operation.AbstractCoordinateOperation;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.metadata.extent.Extent;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.ConcatenatedOperation;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.referencing.operation.Transformation;
import org.opengis.util.FactoryException;

@XmlType(name="ConcatenatedOperationType")
@XmlRootElement(name="ConcatenatedOperation")
final class DefaultConcatenatedOperation
extends AbstractCoordinateOperation
implements ConcatenatedOperation {
    private static final long serialVersionUID = 4199619838029045700L;
    private List<SingleOperation> operations;

    public DefaultConcatenatedOperation(Map<String, ?> properties, CoordinateOperation[] operations, MathTransformFactory mtFactory) throws FactoryException {
        super(properties);
        ArgumentChecks.ensureNonNull("operations", operations);
        if (operations.length < 2) {
            throw new IllegalArgumentException(Errors.getResources(properties).getString((short)128, 2, CoordinateOperation.class));
        }
        this.initialize(properties, operations, mtFactory);
        this.checkDimensions(properties);
    }

    private void initialize(Map<String, ?> properties, CoordinateOperation[] operations, MathTransformFactory mtFactory) throws FactoryException {
        ArrayList<CoordinateOperation> flattened = new ArrayList<CoordinateOperation>(operations.length);
        CoordinateReferenceSystem crs = this.initialize(properties, operations, flattened, mtFactory, this.sourceCRS == null, this.coordinateOperationAccuracy == null, this.domainOfValidity == null);
        if (this.targetCRS == null) {
            this.targetCRS = crs;
        }
        this.operations = UnmodifiableArrayList.wrap(flattened.toArray(new SingleOperation[flattened.size()]));
    }

    private CoordinateReferenceSystem initialize(Map<String, ?> properties, CoordinateOperation[] operations, List<CoordinateOperation> flattened, MathTransformFactory mtFactory, boolean setSource, boolean setAccuracy, boolean setDomain) throws FactoryException {
        CoordinateReferenceSystem previous = null;
        for (int i = 0; i < operations.length; ++i) {
            Extent domain;
            int dim2;
            int dim1;
            CoordinateOperation op = operations[i];
            ArgumentChecks.ensureNonNullElement("operations", i, op);
            CoordinateReferenceSystem next = op.getSourceCRS();
            if (previous != null && next != null && (dim1 = previous.getCoordinateSystem().getDimension()) != (dim2 = next.getCoordinateSystem().getDimension())) {
                throw new MismatchedDimensionException(Errors.getResources(properties).getString((short)81, "operations[" + i + "].sourceCRS", dim1, dim2));
            }
            if (setSource) {
                setSource = false;
                this.sourceCRS = next;
            }
            previous = op.getTargetCRS();
            MathTransform step = op.getMathTransform();
            if (op instanceof ConcatenatedOperation) {
                List children = ((ConcatenatedOperation)op).getOperations();
                CoordinateOperation[] asArray = children.toArray(new CoordinateOperation[children.size()]);
                this.initialize(properties, asArray, flattened, (MathTransformFactory)(step == null ? mtFactory : null), false, setAccuracy, setDomain);
            } else if (!step.isIdentity()) {
                flattened.add(op);
            }
            if (mtFactory != null && step != null) {
                MathTransform mathTransform = this.transform = this.transform != null ? mtFactory.createConcatenatedTransform(this.transform, step) : step;
            }
            if (setAccuracy && (op instanceof Transformation || op instanceof ConcatenatedOperation) && PositionalAccuracyConstant.getLinearAccuracy(op) != 0.0) {
                if (this.coordinateOperationAccuracy == null) {
                    this.coordinateOperationAccuracy = op.getCoordinateOperationAccuracy();
                } else {
                    this.coordinateOperationAccuracy = null;
                    setAccuracy = false;
                }
            }
            if (!setDomain || (domain = op.getDomainOfValidity()) == null) continue;
            if (this.domainOfValidity == null) {
                this.domainOfValidity = domain;
                continue;
            }
            if (domain.equals(this.domainOfValidity)) continue;
            this.domainOfValidity = null;
            setDomain = false;
        }
        return previous;
    }

    protected DefaultConcatenatedOperation(ConcatenatedOperation operation) {
        super((CoordinateOperation)operation);
        this.operations = operation.getOperations();
    }

    public static DefaultConcatenatedOperation castOrCopy(ConcatenatedOperation object) {
        return object == null || object instanceof DefaultConcatenatedOperation ? (DefaultConcatenatedOperation)object : new DefaultConcatenatedOperation(object);
    }

    public Class<? extends ConcatenatedOperation> getInterface() {
        return ConcatenatedOperation.class;
    }

    public List<SingleOperation> getOperations() {
        return this.operations;
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, mode)) {
            if (mode == ComparisonMode.STRICT) {
                return Objects.equals(this.operations, ((DefaultConcatenatedOperation)object).operations);
            }
            return Utilities.deepEquals(this.getOperations(), ((ConcatenatedOperation)object).getOperations(), mode);
        }
        return false;
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)(37 * Objects.hashCode(this.operations));
    }

    @Override
    protected String formatTo(Formatter formatter) {
        super.formatTo(formatter);
        for (CoordinateOperation coordinateOperation : this.operations) {
            formatter.newLine();
            formatter.append(DefaultConcatenatedOperation.castOrCopy(coordinateOperation));
        }
        formatter.setInvalidWKT(this, null);
        return "ConcatenatedOperation";
    }

    private DefaultConcatenatedOperation() {
        this.operations = Collections.emptyList();
    }

    @XmlElement(name="coordOperation", required=true)
    private CoordinateOperation[] getSteps() {
        List<SingleOperation> operations = this.getOperations();
        return operations != null ? operations.toArray(new CoordinateOperation[operations.size()]) : null;
    }

    private void setSteps(CoordinateOperation[] steps) throws FactoryException {
        this.initialize(null, steps, DefaultFactories.forBuildin(MathTransformFactory.class));
    }
}

