/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.measure.IncommensurableException;
import org.apache.sis.internal.referencing.CoordinateOperations;
import org.apache.sis.internal.referencing.DeferredCoordinateOperation;
import org.apache.sis.internal.referencing.EllipsoidalHeightCombiner;
import org.apache.sis.internal.referencing.PositionalAccuracyConstant;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.referencing.provider.Affine;
import org.apache.sis.internal.system.Semaphores;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.referencing.factory.GeodeticAuthorityFactory;
import org.apache.sis.referencing.factory.IdentifiedObjectFinder;
import org.apache.sis.referencing.factory.InvalidGeodeticParameterException;
import org.apache.sis.referencing.factory.MissingFactoryResourceException;
import org.apache.sis.referencing.factory.NoSuchAuthorityFactoryException;
import org.apache.sis.referencing.operation.AbstractCoordinateOperation;
import org.apache.sis.referencing.operation.CRSPair;
import org.apache.sis.referencing.operation.CoordinateOperationContext;
import org.apache.sis.referencing.operation.CoordinateOperationFinder;
import org.apache.sis.referencing.operation.CoordinateOperationSorter;
import org.apache.sis.referencing.operation.DefaultCoordinateOperationFactory;
import org.apache.sis.referencing.operation.DefaultOperationMethod;
import org.apache.sis.referencing.operation.InverseOperationMethod;
import org.apache.sis.referencing.operation.SubTypes;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.transform.DefaultMathTransformFactory;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Deprecable;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.quality.PositionalAccuracy;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.operation.ConcatenatedOperation;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.referencing.operation.Transformation;
import org.opengis.util.FactoryException;
import org.opengis.util.NoSuchIdentifierException;

class CoordinateOperationRegistry {
    static final Identifier IDENTITY = CoordinateOperationRegistry.createIdentifier((short)48);
    static final Identifier AXIS_CHANGES = CoordinateOperationRegistry.createIdentifier((short)8);
    static final Identifier ELLIPSOID_CHANGE = CoordinateOperationRegistry.createIdentifier((short)40);
    static final Identifier DATUM_SHIFT = CoordinateOperationRegistry.createIdentifier((short)26);
    static final Identifier GEOCENTRIC_CONVERSION = CoordinateOperationRegistry.createIdentifier((short)43);
    private static final Identifier INVERSE_OPERATION = CoordinateOperationRegistry.createIdentifier((short)53);
    private final IdentifiedObjectFinder codeFinder;
    protected final CoordinateOperationAuthorityFactory registry;
    protected final CoordinateOperationFactory factory;
    final DefaultCoordinateOperationFactory factorySIS;
    protected Extent areaOfInterest;
    protected double desiredAccuracy;
    boolean stopAtFirst;
    private Predicate<CoordinateOperation> filter;

    private static Identifier createIdentifier(short key) {
        return new NamedIdentifier(Citations.SIS, (CharSequence)Vocabulary.formatInternational(key));
    }

    CoordinateOperationRegistry(CoordinateOperationAuthorityFactory registry, CoordinateOperationFactory factory, CoordinateOperationContext context) throws FactoryException {
        ArgumentChecks.ensureNonNull("factory", factory);
        this.registry = registry;
        this.factory = factory;
        this.factorySIS = factory instanceof DefaultCoordinateOperationFactory ? (DefaultCoordinateOperationFactory)factory : CoordinateOperations.factory();
        IdentifiedObjectFinder codeFinder = null;
        if (registry != null) {
            if (registry instanceof GeodeticAuthorityFactory) {
                codeFinder = ((GeodeticAuthorityFactory)registry).newIdentifiedObjectFinder();
            } else {
                try {
                    codeFinder = IdentifiedObjects.newFinder(Citations.toCodeSpace(registry.getAuthority()));
                }
                catch (NoSuchAuthorityFactoryException e) {
                    Logging.recoverableException(Logging.getLogger("org.apache.sis.referencing.operation"), CoordinateOperationRegistry.class, "<init>", (Throwable)((Object)e));
                }
            }
            if (codeFinder != null) {
                codeFinder.setIgnoringAxes(true);
            }
        }
        this.codeFinder = codeFinder;
        if (context != null) {
            this.areaOfInterest = context.getAreaOfInterest();
            this.desiredAccuracy = context.getDesiredAccuracy();
            this.filter = context.getOperationFilter();
        }
    }

    final <T extends IdentifiedObject> T toAuthorityDefinition(Class<T> type, T object) throws FactoryException {
        if (this.codeFinder != null) {
            this.codeFinder.setIgnoringAxes(false);
            IdentifiedObject candidate = this.codeFinder.findSingleton(object);
            this.codeFinder.setIgnoringAxes(true);
            if (Utilities.equalsIgnoreMetadata(object, candidate)) {
                return (T)((IdentifiedObject)type.cast(candidate));
            }
        }
        return object;
    }

    private List<String> findCode(CoordinateReferenceSystem crs) throws FactoryException {
        ArrayList<String> codes = new ArrayList<String>();
        if (this.codeFinder != null) {
            for (IdentifiedObject candidate : this.codeFinder.find((IdentifiedObject)crs)) {
                Identifier identifier = IdentifiedObjects.getIdentifier(candidate, this.registry.getAuthority());
                if (identifier == null) continue;
                String code = identifier.getCode();
                if (Utilities.deepEquals(candidate, crs, ComparisonMode.APPROXIMATE)) {
                    codes.add(0, code);
                    continue;
                }
                codes.add(code);
            }
        }
        return codes;
    }

    public List<CoordinateOperation> createOperations(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) throws FactoryException {
        CoordinateReferenceSystem source = sourceCRS;
        CoordinateReferenceSystem target = targetCRS;
        int combine = 0;
        while (true) {
            block17: {
                switch (combine) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        target = CRS.getHorizontalComponent(targetCRS);
                        if (target != targetCRS) break;
                        break block17;
                    }
                    case 2: {
                        source = CRS.getHorizontalComponent(sourceCRS);
                        if (source != sourceCRS) break;
                        break block17;
                    }
                    case 3: {
                        if (source != sourceCRS && target != targetCRS) {
                            target = targetCRS;
                            break;
                        }
                        break block17;
                    }
                    default: {
                        return Collections.emptyList();
                    }
                }
                if (source != null && target != null) {
                    try {
                        List<CoordinateOperation> operations = this.search(source, target);
                        if (operations != null) {
                            if (combine != 0) {
                                int i = operations.size();
                                while (--i >= 0) {
                                    CoordinateOperation operation = operations.get(i);
                                    operation = this.propagateVertical(sourceCRS, source != sourceCRS, targetCRS, target != targetCRS, operation);
                                    if (operation != null) {
                                        operation = this.complete(operation, sourceCRS, targetCRS);
                                        operations.set(i, operation);
                                        continue;
                                    }
                                    operations.remove(i);
                                }
                            }
                            if (!operations.isEmpty()) {
                                return operations;
                            }
                        }
                    }
                    catch (IllegalArgumentException | IncommensurableException e) {
                        String message = Resources.format((short)5, new CRSPair(sourceCRS, targetCRS));
                        String details = e.getLocalizedMessage();
                        if (details != null) {
                            message = message + ' ' + details;
                        }
                        throw new FactoryException(message, e);
                    }
                }
            }
            ++combine;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CoordinateOperation> search(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) throws IllegalArgumentException, IncommensurableException, FactoryException {
        List<String> sources = this.findCode(sourceCRS);
        if (sources.isEmpty()) {
            return null;
        }
        List<String> targets = this.findCode(targetCRS);
        if (targets.isEmpty()) {
            return null;
        }
        ArrayList<CoordinateOperation> operations = new ArrayList<CoordinateOperation>();
        boolean foundDirectOperations = false;
        boolean useDeprecatedOperations = false;
        for (String sourceID : sources) {
            block13: for (String targetID : targets) {
                Set authoritatives;
                boolean mdOnly;
                block28: {
                    block29: {
                        if (sourceID.equals(targetID)) {
                            return null;
                        }
                        mdOnly = Semaphores.queryAndSet(2);
                        authoritatives = this.registry.createFromCoordinateReferenceSystemCodes(sourceID, targetID);
                        boolean inverse = Containers.isNullOrEmpty(authoritatives);
                        if (!inverse) break block28;
                        if (!foundDirectOperations) break block29;
                        if (mdOnly) continue;
                        Semaphores.clear(2);
                        continue;
                    }
                    authoritatives = this.registry.createFromCoordinateReferenceSystemCodes(targetID, sourceID);
                    if (Containers.isNullOrEmpty(authoritatives)) {
                        continue;
                    }
                }
                try {
                    try {
                        if (!foundDirectOperations) {
                            foundDirectOperations = true;
                            operations.clear();
                        }
                    }
                    catch (MissingFactoryResourceException | NoSuchAuthorityCodeException e) {
                        CoordinateOperationRegistry.log(null, (Exception)e);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (mdOnly) continue;
                    Semaphores.clear(2);
                    continue;
                }
                {
                    try {
                        for (CoordinateOperation candidate : authoritatives) {
                            if (candidate == null) continue;
                            if (candidate instanceof Deprecable && ((Deprecable)candidate).isDeprecated()) {
                                if (!useDeprecatedOperations && !operations.isEmpty()) continue block13;
                                useDeprecatedOperations = true;
                            } else if (useDeprecatedOperations) {
                                useDeprecatedOperations = false;
                                operations.clear();
                            }
                            operations.add(candidate);
                        }
                    }
                    catch (BackingStoreException exception) {
                        throw exception.unwrapOrRethrow(FactoryException.class);
                    }
                }
            }
        }
        CoordinateOperationSorter.sort(operations, Extents.getGeographicBoundingBox(this.areaOfInterest));
        ListIterator<CoordinateOperation> it = operations.listIterator();
        while (it.hasNext()) {
            CoordinateOperation operation;
            block30: {
                operation = (CoordinateOperation)it.next();
                try {
                    if (operation instanceof DeferredCoordinateOperation) {
                        operation = ((DeferredCoordinateOperation)operation).create();
                    }
                    if (operation instanceof SingleOperation && operation.getMathTransform() == null && (operation = this.fromDefiningConversion((SingleOperation)operation, foundDirectOperations ? sourceCRS : targetCRS, foundDirectOperations ? targetCRS : sourceCRS)) == null) {
                        it.remove();
                        continue;
                    }
                    if (foundDirectOperations) break block30;
                    operation = this.inverse(operation);
                }
                catch (MissingFactoryResourceException | NoninvertibleTransformException e) {
                    CoordinateOperationRegistry.log(null, (Exception)e);
                    it.remove();
                    continue;
                }
            }
            operation = this.complete(operation, sourceCRS, targetCRS);
            if (this.filter(operation)) {
                if (this.stopAtFirst) {
                    operations.clear();
                    operations.add(operation);
                    break;
                }
                it.set(operation);
                continue;
            }
            it.remove();
        }
        return operations;
    }

    final boolean filter(CoordinateOperation op) {
        return this.filter == null || this.filter.test(op);
    }

    final CoordinateOperation inverse(SingleOperation op) throws NoninvertibleTransformException, FactoryException {
        CoordinateReferenceSystem sourceCRS = op.getSourceCRS();
        CoordinateReferenceSystem targetCRS = op.getTargetCRS();
        MathTransform transform = op.getMathTransform().inverse();
        OperationMethod method = InverseOperationMethod.create(op.getMethod());
        Map<String, Object> properties = CoordinateOperationRegistry.properties(INVERSE_OPERATION);
        InverseOperationMethod.properties(op, properties);
        Class<Transformation> type = null;
        if (op instanceof Transformation) {
            type = Transformation.class;
        } else if (op instanceof Conversion) {
            type = Conversion.class;
        }
        return this.createFromMathTransform(properties, targetCRS, sourceCRS, transform, method, null, type);
    }

    private CoordinateOperation inverse(CoordinateOperation operation) throws NoninvertibleTransformException, FactoryException {
        if (SubTypes.isSingleOperation(operation)) {
            return this.inverse((SingleOperation)operation);
        }
        if (operation instanceof ConcatenatedOperation) {
            List operations = ((ConcatenatedOperation)operation).getOperations();
            CoordinateOperation[] inverted = new CoordinateOperation[operations.size()];
            int i = 0;
            while (i < inverted.length) {
                CoordinateOperation op = this.inverse((CoordinateOperation)operations.get(i));
                if (op == null) {
                    return null;
                }
                inverted[inverted.length - ++i] = op;
            }
            return this.factory.createConcatenatedOperation(CoordinateOperationRegistry.properties(INVERSE_OPERATION), inverted);
        }
        return null;
    }

    private CoordinateOperation complete(CoordinateOperation operation, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) throws IllegalArgumentException, IncommensurableException, FactoryException {
        CoordinateReferenceSystem source = operation.getSourceCRS();
        CoordinateReferenceSystem target = operation.getTargetCRS();
        MathTransformFactory mtFactory = this.factorySIS.getMathTransformFactory();
        MathTransform prepend = CoordinateOperationRegistry.swapAndScaleAxes(sourceCRS, source, mtFactory);
        MathTransform append = CoordinateOperationRegistry.swapAndScaleAxes(target, targetCRS, mtFactory);
        if (prepend != null) {
            source = sourceCRS;
        }
        if (append != null) {
            target = targetCRS;
        }
        return this.transform(source, prepend, operation, append, target, mtFactory);
    }

    private static MathTransform swapAndScaleAxes(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, MathTransformFactory mtFactory) throws IllegalArgumentException, IncommensurableException, FactoryException {
        assert (ReferencingUtilities.getDimension(sourceCRS) != ReferencingUtilities.getDimension(targetCRS) || Utilities.deepEquals(sourceCRS, targetCRS, ComparisonMode.ALLOW_VARIANT));
        Matrix m = CoordinateSystems.swapAndScaleAxes(sourceCRS.getCoordinateSystem(), targetCRS.getCoordinateSystem());
        return m.isIdentity() ? null : mtFactory.createAffineTransform(m);
    }

    private CoordinateOperation transform(CoordinateReferenceSystem sourceCRS, MathTransform prepend, CoordinateOperation operation, MathTransform append, CoordinateReferenceSystem targetCRS, MathTransformFactory mtFactory) throws IllegalArgumentException, FactoryException {
        if ((prepend == null || prepend.isIdentity()) && (append == null || append.isIdentity())) {
            return operation;
        }
        if (operation instanceof ConcatenatedOperation) {
            List c = ((ConcatenatedOperation)operation).getOperations();
            CoordinateOperation[] op = c.toArray(new CoordinateOperation[c.size()]);
            switch (op.length) {
                case 0: {
                    break;
                }
                case 1: {
                    operation = op[0];
                    break;
                }
                default: {
                    int n = op.length - 1;
                    CoordinateOperation first = op[0];
                    CoordinateOperation last = op[n];
                    op[0] = this.transform(sourceCRS, prepend, first, null, first.getTargetCRS(), mtFactory);
                    op[n] = this.transform(last.getSourceCRS(), null, last, append, targetCRS, mtFactory);
                    return this.factory.createConcatenatedOperation(CoordinateOperationRegistry.derivedFrom((IdentifiedObject)operation), op);
                }
            }
        }
        MathTransform transform = operation.getMathTransform();
        if (prepend != null) {
            transform = mtFactory.createConcatenatedTransform(prepend, transform);
        }
        if (append != null) {
            transform = mtFactory.createConcatenatedTransform(transform, append);
        }
        assert (!transform.equals(operation.getMathTransform())) : transform;
        return this.recreate(operation, sourceCRS, targetCRS, transform, null);
    }

    private CoordinateOperation recreate(CoordinateOperation operation, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, MathTransform transform, OperationMethod method) throws IllegalArgumentException, FactoryException {
        CoordinateReferenceSystem crs = operation.getSourceCRS();
        if (Utilities.equalsApproximately(sourceCRS, crs)) {
            sourceCRS = crs;
        }
        if (Utilities.equalsApproximately(targetCRS, crs = operation.getTargetCRS())) {
            targetCRS = crs;
        }
        HashMap properties = new HashMap(CoordinateOperationRegistry.derivedFrom((IdentifiedObject)operation));
        Class<Object> type = operation instanceof AbstractIdentifiedObject ? ((AbstractIdentifiedObject)operation).getInterface() : Classes.getLeafInterfaces(operation.getClass(), CoordinateOperation.class)[0];
        properties.put("operationType", type);
        if (SubTypes.isSingleOperation(operation)) {
            SingleOperation single = (SingleOperation)operation;
            properties.put("parameters", single.getParameterValues());
            if (method == null) {
                int sourceDimensions = transform.getSourceDimensions();
                int targetDimensions = transform.getTargetDimensions();
                method = single.getMethod();
                try {
                    method = DefaultOperationMethod.redimension(method, sourceDimensions, targetDimensions);
                }
                catch (IllegalArgumentException ex) {
                    try {
                        method = this.factorySIS.getOperationMethod(method.getName().getCode());
                        method = DefaultOperationMethod.redimension(method, sourceDimensions, targetDimensions);
                    }
                    catch (IllegalArgumentException | NoSuchIdentifierException se) {
                        ex.addSuppressed(se);
                        throw ex;
                    }
                }
            }
        }
        return this.factorySIS.createSingleOperation(properties, sourceCRS, targetCRS, AbstractCoordinateOperation.getInterpolationCRS(operation), method, transform);
    }

    private CoordinateOperation fromDefiningConversion(SingleOperation operation, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) throws FactoryException {
        ParameterValueGroup parameters = operation.getParameterValues();
        if (parameters != null) {
            MathTransformFactory mtFactory;
            CoordinateReferenceSystem crs = operation.getSourceCRS();
            if (Utilities.equalsApproximately(sourceCRS, crs)) {
                sourceCRS = crs;
            }
            if (Utilities.equalsApproximately(targetCRS, crs = operation.getTargetCRS())) {
                targetCRS = crs;
            }
            if ((mtFactory = this.factorySIS.getMathTransformFactory()) instanceof DefaultMathTransformFactory) {
                MathTransform mt = ((DefaultMathTransformFactory)mtFactory).createParameterizedTransform(parameters, ReferencingUtilities.createTransformContext(sourceCRS, targetCRS, null));
                return this.factorySIS.createSingleOperation(IdentifiedObjects.getProperties((IdentifiedObject)operation, new String[0]), sourceCRS, targetCRS, null, operation.getMethod(), mt);
            }
        } else {
            CoordinateOperationRegistry.log(Resources.forLocale(null).getLogRecord(Level.WARNING, (short)74, IdentifiedObjects.getIdentifierOrName((IdentifiedObject)operation)), null);
        }
        return null;
    }

    private CoordinateOperation propagateVertical(CoordinateReferenceSystem sourceCRS, boolean source3D, CoordinateReferenceSystem targetCRS, boolean target3D, CoordinateOperation operation) throws IllegalArgumentException, FactoryException {
        ArrayList<CoordinateOperation> operations = new ArrayList<CoordinateOperation>();
        if (operation instanceof ConcatenatedOperation) {
            operations.addAll(((ConcatenatedOperation)operation).getOperations());
        } else {
            operations.add(operation);
        }
        if (source3D && !this.propagateVertical(sourceCRS, targetCRS, operations.listIterator(), true) || target3D && !this.propagateVertical(sourceCRS, targetCRS, operations.listIterator(operations.size()), false)) {
            return null;
        }
        switch (operations.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (CoordinateOperation)operations.get(0);
            }
        }
        return this.factory.createConcatenatedOperation(CoordinateOperationRegistry.derivedFrom((IdentifiedObject)operation), operations.toArray(new CoordinateOperation[operations.size()]));
    }

    private boolean propagateVertical(CoordinateReferenceSystem source3D, CoordinateReferenceSystem target3D, ListIterator<CoordinateOperation> operations, boolean forward) throws IllegalArgumentException, FactoryException {
        CoordinateReferenceSystem targetCRS;
        CoordinateOperation op;
        CoordinateReferenceSystem sourceCRS;
        while ((forward ? operations.hasNext() : operations.hasPrevious()) && (sourceCRS = (op = forward ? operations.next() : operations.previous()).getSourceCRS()) instanceof GeodeticCRS && (targetCRS = op.getTargetCRS()) instanceof GeodeticCRS && sourceCRS.getCoordinateSystem() instanceof EllipsoidalCS && targetCRS.getCoordinateSystem() instanceof EllipsoidalCS) {
            boolean is2D;
            Matrix matrix = MathTransforms.getMatrix(op.getMathTransform());
            if (matrix == null) {
                MathTransform mt;
                MathTransformFactory mtFactory;
                if (!SubTypes.isSingleOperation(op) || !((mtFactory = this.factorySIS.getMathTransformFactory()) instanceof DefaultMathTransformFactory)) break;
                if (forward) {
                    sourceCRS = this.toGeodetic3D(sourceCRS, source3D);
                } else {
                    targetCRS = this.toGeodetic3D(targetCRS, target3D);
                }
                try {
                    mt = ((DefaultMathTransformFactory)mtFactory).createParameterizedTransform(((SingleOperation)op).getParameterValues(), ReferencingUtilities.createTransformContext(sourceCRS, targetCRS, null));
                }
                catch (InvalidGeodeticParameterException e) {
                    CoordinateOperationRegistry.log(null, (Exception)((Object)e));
                    break;
                }
                operations.set(this.recreate(op, sourceCRS, targetCRS, mt, mtFactory.getLastMethodUsed()));
                return true;
            }
            int numRow = matrix.getNumRow();
            int numCol = matrix.getNumCol();
            boolean bl = is2D = numCol == 3 && numRow == 3;
            if (!is2D && !(forward ? numCol == 3 && numRow == 4 : numCol == 4 && numRow == 3)) break;
            if ((matrix = Matrices.resizeAffine(matrix, 4, 4)).isIdentity()) {
                operations.remove();
            } else {
                MathTransform mt = this.factorySIS.getMathTransformFactory().createAffineTransform(matrix);
                operations.set(this.recreate(op, this.toGeodetic3D(sourceCRS, source3D), this.toGeodetic3D(targetCRS, target3D), mt, null));
            }
            if (is2D) continue;
            return true;
        }
        return false;
    }

    private CoordinateReferenceSystem toGeodetic3D(CoordinateReferenceSystem crs, CoordinateReferenceSystem candidate) throws FactoryException {
        assert (crs instanceof GeodeticCRS && crs.getCoordinateSystem() instanceof EllipsoidalCS) : crs;
        if (crs.getCoordinateSystem().getDimension() != 2) {
            return crs;
        }
        if (crs.getClass() == candidate.getClass() && candidate.getCoordinateSystem().getDimension() == 3 && Utilities.equalsIgnoreMetadata(((SingleCRS)crs).getDatum(), ((SingleCRS)candidate).getDatum())) {
            return candidate;
        }
        EllipsoidalHeightCombiner c = new EllipsoidalHeightCombiner(this.factorySIS.getCRSFactory(), this.factorySIS.getCSFactory(), this.factory);
        return this.toAuthorityDefinition(CoordinateReferenceSystem.class, c.createCompoundCRS(CoordinateOperationRegistry.derivedFrom((IdentifiedObject)crs), new CoordinateReferenceSystem[]{crs, CommonCRS.Vertical.ELLIPSOIDAL.crs()}));
    }

    private static Map<String, ?> derivedFrom(IdentifiedObject object) {
        return IdentifiedObjects.getProperties(object, "identifiers");
    }

    static Map<String, Object> properties(Identifier name) {
        HashMap<String, Object> properties = new HashMap<String, Object>(4);
        properties.put("name", name);
        if (name == DATUM_SHIFT || name == ELLIPSOID_CHANGE) {
            properties.put("coordinateOperationAccuracy", new PositionalAccuracy[]{name == DATUM_SHIFT ? PositionalAccuracyConstant.DATUM_SHIFT_APPLIED : PositionalAccuracyConstant.DATUM_SHIFT_OMITTED});
        }
        return properties;
    }

    final CoordinateOperation createFromMathTransform(Map<String, Object> properties, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, MathTransform transform, OperationMethod method, ParameterValueGroup parameters, Class<? extends CoordinateOperation> type) throws FactoryException {
        CoordinateOperation operation;
        if (transform instanceof CoordinateOperation && Objects.equals((operation = (CoordinateOperation)transform).getSourceCRS(), sourceCRS) && Objects.equals(operation.getTargetCRS(), targetCRS) && Objects.equals(operation.getMathTransform(), transform) && (method == null || !(operation instanceof SingleOperation) || Objects.equals(((SingleOperation)operation).getMethod(), method))) {
            return operation;
        }
        if (type == null) {
            Class clazz = type = properties.containsKey("coordinateOperationAccuracy") ? Transformation.class : Conversion.class;
        }
        if (method == null) {
            Matrix matrix = MathTransforms.getMatrix(transform);
            if (matrix != null) {
                method = Affine.getProvider(transform.getSourceDimensions(), transform.getTargetDimensions(), Matrices.isAffine(matrix));
            } else {
                ParameterDescriptorGroup descriptor = AbstractCoordinateOperation.getParameterDescriptors(transform);
                if (descriptor != null) {
                    ReferenceIdentifier name = descriptor.getName();
                    if (name != null) {
                        method = this.factorySIS.getOperationMethod(name.getCode());
                    }
                    if (method == null) {
                        method = this.factorySIS.createOperationMethod(properties, sourceCRS.getCoordinateSystem().getDimension(), targetCRS.getCoordinateSystem().getDimension(), descriptor);
                    }
                }
            }
        }
        if (parameters != null) {
            properties.put("parameters", parameters);
        }
        properties.put("operationType", type);
        if (Conversion.class.isAssignableFrom(type) && transform.isIdentity()) {
            properties.replace("name", AXIS_CHANGES, IDENTITY);
        }
        return this.factorySIS.createSingleOperation(properties, sourceCRS, targetCRS, null, method, transform);
    }

    private static void log(LogRecord record, Exception exception) {
        if (record == null) {
            record = new LogRecord(Level.WARNING, exception.getLocalizedMessage());
        }
        record.setLoggerName("org.apache.sis.referencing.operation");
        if (exception instanceof NoninvertibleTransformException) {
            record.setThrown(exception);
        }
        Logging.log(CoordinateOperationFinder.class, "createOperations", record);
    }
}

