/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.gazetteer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.referencing.WKTUtilities;
import org.apache.sis.io.wkt.ElementKind;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.metadata.iso.citation.AbstractParty;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.referencing.AbstractReferenceSystem;
import org.apache.sis.referencing.gazetteer.AbstractLocationType;
import org.apache.sis.referencing.gazetteer.ModifiableLocationType;
import org.apache.sis.referencing.gazetteer.ModifiableLocationTypeAdapter;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.util.InternationalString;

@XmlTransient
public class ReferencingByIdentifiers
extends AbstractReferenceSystem {
    public static final String THEME_KEY = "theme";
    public static final String OVERALL_OWNER_KEY = "overallOwner";
    private static final long serialVersionUID = 5353942546043471933L;
    private final InternationalString theme;
    private final AbstractParty overallOwner;
    final List<AbstractLocationType> locationTypes;

    public ReferencingByIdentifiers(Map<String, ?> properties, ModifiableLocationType ... types) {
        super(properties);
        this.theme = Types.toInternationalString(properties, THEME_KEY);
        this.overallOwner = Containers.property(properties, OVERALL_OWNER_KEY, AbstractParty.class);
        this.locationTypes = AbstractLocationType.snapshot(this, types);
    }

    static Map<String, Object> properties(Object name, AbstractParty party) {
        HashMap<String, Object> properties = new HashMap<String, Object>(6);
        properties.put("name", name);
        properties.put("domainOfValidity", Extents.WORLD);
        properties.put(THEME_KEY, Vocabulary.formatInternational((short)127));
        properties.put(OVERALL_OWNER_KEY, party);
        return properties;
    }

    public InternationalString getTheme() {
        return this.theme;
    }

    public AbstractParty getOverallOwner() {
        return this.overallOwner;
    }

    public List<? extends ModifiableLocationType> getLocationTypes() {
        return ModifiableLocationTypeAdapter.copy(this.locationTypes);
    }

    final AbstractLocationType rootType() {
        return this.locationTypes.get(0);
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        ReferencingByIdentifiers that;
        if (!super.equals(object, mode)) {
            return false;
        }
        switch (mode) {
            case STRICT: {
                ReferencingByIdentifiers that2 = (ReferencingByIdentifiers)object;
                return Objects.equals(this.theme, that2.theme) && Objects.equals(this.overallOwner, that2.overallOwner) && this.locationTypes.equals(that2.locationTypes);
            }
            case BY_CONTRACT: {
                that = (ReferencingByIdentifiers)object;
                if (Utilities.deepEquals(this.getTheme(), that.getTheme(), mode) && Utilities.deepEquals(this.getOverallOwner(), that.getOverallOwner(), mode)) break;
                return false;
            }
        }
        that = (ReferencingByIdentifiers)object;
        return Utilities.deepEquals(this.locationTypes, that.locationTypes, mode);
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)Objects.hash(this.theme, this.overallOwner, this.locationTypes);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        WKTUtilities.appendName(this, formatter, ElementKind.NAME);
        if (this.theme != null) {
            formatter.newLine();
            formatter.append(new SubElement("Theme", this.theme));
        }
        if (this.overallOwner != null) {
            formatter.newLine();
            formatter.append(new SubElement("Owner", this.overallOwner.getName()));
        }
        for (AbstractLocationType type : this.locationTypes) {
            formatter.newLine();
            formatter.append(new SubElement("LocationType", type.getName()));
        }
        return "ReferenceSystemUsingIdentifiers";
    }

    private static final class SubElement
    extends FormattableObject {
        private final String name;
        private final InternationalString value;

        SubElement(String name, InternationalString value) {
            this.name = name;
            this.value = value;
        }

        @Override
        protected String formatTo(Formatter formatter) {
            formatter.append(this.value != null ? this.value.toString(formatter.getLocale()) : null, null);
            return this.name;
        }
    }
}

