/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.gazetteer;

import java.io.IOException;
import java.math.RoundingMode;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.measure.Unit;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.io.TableAppender;
import org.apache.sis.io.TabularFormat;
import org.apache.sis.measure.Angle;
import org.apache.sis.measure.AngleFormat;
import org.apache.sis.measure.Latitude;
import org.apache.sis.measure.Longitude;
import org.apache.sis.measure.Range;
import org.apache.sis.measure.UnitFormat;
import org.apache.sis.metadata.iso.citation.AbstractParty;
import org.apache.sis.metadata.iso.extent.DefaultExtent;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.gazetteer.AbstractLocation;
import org.apache.sis.referencing.gazetteer.AbstractLocationType;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.coordinate.Position;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;
import org.opengis.util.InternationalString;

public class LocationFormat
extends TabularFormat<AbstractLocation> {
    private static final long serialVersionUID = -3440801316594167279L;
    static final LocationFormat INSTANCE = new LocationFormat(Locale.getDefault(), TimeZone.getDefault());
    private static final short[] BOUND_KEY = new short[]{140, 141, 133, 138, 141, 137};

    public LocationFormat(Locale locale, TimeZone timezone) {
        super(locale, timezone);
    }

    @Override
    public Class<AbstractLocation> getValueType() {
        return AbstractLocation.class;
    }

    private static CoordinateReferenceSystem normalize(CoordinateReferenceSystem crs) {
        AbstractCRS normalized;
        if (crs != null && (normalized = AbstractCRS.castOrCopy(crs)) != (normalized = normalized.forConvention(AxesConvention.DISPLAY_ORIENTED))) {
            return normalized;
        }
        return crs;
    }

    private static DirectPosition transform(DirectPosition position, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) throws FactoryException, TransformException {
        if (sourceCRS != targetCRS) {
            position = CRS.findOperation(sourceCRS, targetCRS, null).getMathTransform().transform(position, null);
        }
        return position;
    }

    private static DirectPosition position(Position p) {
        return p != null ? p.getDirectPosition() : null;
    }

    private static String toString(InternationalString i18n, Locale locale) {
        return i18n != null ? i18n.toString(locale) : null;
    }

    private String toString(Date date) {
        return date != null ? this.getFormat(Date.class).format(date) : null;
    }

    @Override
    public void format(AbstractLocation location, Appendable toAppendTo) throws IOException {
        AbstractParty administrator;
        DefaultExtent extent;
        Range<Date> time;
        ArgumentChecks.ensureNonNull("location", location);
        Locale locale = this.getLocale(Locale.Category.DISPLAY);
        Vocabulary vocabulary = Vocabulary.getResources(locale);
        TableAppender table = new TableAppender(toAppendTo, "\u2502 ", this.columnSeparator, " \u2502");
        table.setMultiLinesCells(true);
        table.appendHorizontalSeparator();
        AbstractLocationType type = location.type();
        if (type != null) {
            this.append(table, vocabulary, (short)136, LocationFormat.toString(type.getName(), locale));
        }
        this.append(table, vocabulary, (short)135, LocationFormat.toString(location.getGeographicIdentifier(), locale));
        Collection<? extends InternationalString> alt = location.getAlternativeGeographicIdentifiers();
        if (alt != null && !alt.isEmpty()) {
            boolean isFirst = true;
            vocabulary.appendLabel((short)131, table);
            this.nextColumn(table);
            for (InternationalString internationalString : alt) {
                if (!isFirst) {
                    isFirst = false;
                    table.append(this.lineSeparator);
                }
                table.append((CharSequence)internationalString);
            }
            table.nextLine();
        }
        if ((time = Extents.getTimeRange(extent = new DefaultExtent(null, location.getGeographicExtent(), null, location.getTemporalExtent()))) != null) {
            this.append(table, vocabulary, (short)139, this.toString(time.getMinValue()));
            this.append(table, vocabulary, (short)134, this.toString(time.getMaxValue()));
        }
        GeographicBoundingBox geographicBoundingBox = Extents.getGeographicBoundingBox(extent);
        Envelope envelope = location.getEnvelope();
        DirectPosition position = LocationFormat.position(location.getPosition());
        DirectPosition geopos = null;
        CoordinateReferenceSystem crs = null;
        CoordinateReferenceSystem normCRS = null;
        Throwable warning = null;
        try {
            if (envelope != null && (normCRS = LocationFormat.normalize(crs = envelope.getCoordinateReferenceSystem())) != crs) {
                envelope = Envelopes.transform(envelope, normCRS);
            }
            if (position != null) {
                GeographicCRS geogCRS;
                CoordinateReferenceSystem posCRS = position.getCoordinateReferenceSystem();
                if (normCRS == null && (normCRS = LocationFormat.normalize(crs = posCRS)) != crs) {
                    envelope = Envelopes.transform(envelope, normCRS);
                }
                if (geographicBoundingBox != null && (geogCRS = ReferencingUtilities.toNormalizedGeographicCRS(posCRS, false, false)) != null) {
                    geopos = LocationFormat.transform(position, posCRS, (CoordinateReferenceSystem)geogCRS);
                }
                position = LocationFormat.transform(position, posCRS, normCRS);
            }
        }
        catch (TransformException | FactoryException e) {
            envelope = null;
            position = null;
            warning = e;
        }
        if (geographicBoundingBox != null || envelope != null) {
            CoordinateSystem cs = crs != null ? crs.getCoordinateSystem() : null;
            Object[] geographic = null;
            Object[] projected = null;
            Object[] unitSymbol = null;
            AngleFormat geogFormat = null;
            NumberFormat projFormat = null;
            UnitFormat unitFormat = null;
            int maxGeogLength = 0;
            int maxProjLength = 0;
            int maxUnitLength = 0;
            boolean showProj = false;
            if (geographicBoundingBox != null || geopos != null) {
                geogFormat = (AngleFormat)this.getFormat(Angle.class);
                geographic = new String[BOUND_KEY.length];
                Arrays.fill(geographic, "");
            }
            if (envelope != null || position != null) {
                projFormat = (NumberFormat)this.getFormat(Number.class);
                unitFormat = (UnitFormat)this.getFormat(Unit.class);
                projected = new String[BOUND_KEY.length];
                unitSymbol = new String[BOUND_KEY.length];
                Arrays.fill(projected, "");
                Arrays.fill(unitSymbol, "");
            }
            for (int i = 0; i < BOUND_KEY.length; ++i) {
                int length;
                RoundingMode rounding = RoundingMode.FLOOR;
                double g = Double.NaN;
                double p = Double.NaN;
                int dimension = 0;
                switch (i) {
                    case 0: {
                        if (geographicBoundingBox != null) {
                            g = geographicBoundingBox.getWestBoundLongitude();
                        }
                        if (envelope == null) break;
                        p = envelope.getMinimum(0);
                        break;
                    }
                    case 2: {
                        if (geographicBoundingBox != null) {
                            g = geographicBoundingBox.getEastBoundLongitude();
                        }
                        if (envelope != null) {
                            p = envelope.getMaximum(0);
                        }
                        rounding = RoundingMode.CEILING;
                        break;
                    }
                    case 3: {
                        if (geographicBoundingBox != null) {
                            g = geographicBoundingBox.getSouthBoundLatitude();
                        }
                        if (envelope != null) {
                            p = envelope.getMinimum(1);
                        }
                        dimension = 1;
                        break;
                    }
                    case 5: {
                        if (geographicBoundingBox != null) {
                            g = geographicBoundingBox.getNorthBoundLatitude();
                        }
                        if (envelope != null) {
                            p = envelope.getMaximum(1);
                        }
                        rounding = RoundingMode.CEILING;
                        dimension = 1;
                        break;
                    }
                    case 4: {
                        dimension = 1;
                    }
                    case 1: {
                        if (geopos != null) {
                            g = geopos.getOrdinate(dimension);
                        }
                        if (position != null) {
                            p = position.getOrdinate(dimension);
                        }
                        rounding = RoundingMode.HALF_EVEN;
                    }
                }
                if (!Double.isNaN(p)) {
                    Unit unit232;
                    showProj |= g != p;
                    if (cs != null && (unit232 = cs.getAxis(dimension).getUnit()) != null && (length = ((String)(unitSymbol[i] = unitFormat.format(unit232))).length()) > maxUnitLength) {
                        maxUnitLength = length;
                    }
                    try {
                        projFormat.setRoundingMode(rounding);
                    }
                    catch (UnsupportedOperationException unit232) {
                        // empty catch block
                    }
                    projected[i] = projFormat.format(p);
                    int length2 = ((String)projected[i]).length();
                    if (length2 > maxProjLength) {
                        maxProjLength = length2;
                    }
                }
                if (Double.isNaN(g)) continue;
                geogFormat.setRoundingMode(rounding);
                Angle angle = dimension == 0 ? new Longitude(g) : new Latitude(g);
                geographic[i] = geogFormat.format(angle);
                length = ((String)geographic[i]).length();
                if (length <= maxGeogLength) continue;
                maxGeogLength = length;
            }
            if (!showProj) {
                projected = null;
                unitSymbol = null;
                maxProjLength = 0;
                maxUnitLength = 0;
            } else if (maxProjLength != 0) {
                if (maxUnitLength != 0) {
                    ++maxUnitLength;
                }
                maxGeogLength += 4;
            }
            String separator = projected != null && geographic != null ? "    \u2014" : "";
            for (int i = 0; i < BOUND_KEY.length; ++i) {
                String g;
                String p = projected != null ? projected[i] : "";
                String u = unitSymbol != null ? unitSymbol[i] : "";
                String string = g = geographic != null ? geographic[i] : "";
                if (p.isEmpty() && g.isEmpty()) continue;
                vocabulary.appendLabel(BOUND_KEY[i], table);
                this.nextColumn(table);
                table.append(CharSequences.spaces(maxProjLength - p.length())).append(p);
                table.append(CharSequences.spaces(maxUnitLength - u.length())).append(u).append(separator);
                table.append(CharSequences.spaces(maxGeogLength - g.length())).append(g);
                table.nextLine();
            }
        }
        if (crs != null) {
            this.append(table, vocabulary, (short)132, IdentifiedObjects.getName((IdentifiedObject)crs, null));
        }
        if ((administrator = location.getAdministrator()) != null) {
            this.append(table, vocabulary, (short)130, LocationFormat.toString(administrator.getName(), locale));
        }
        table.appendHorizontalSeparator();
        table.flush();
        if (warning != null) {
            vocabulary.appendLabel((short)117, toAppendTo);
            toAppendTo.append(warning.toString()).append(this.lineSeparator);
        }
    }

    @Override
    protected Format createFormat(Class<?> valueType) {
        Format f = super.createFormat(valueType);
        if (f instanceof NumberFormat) {
            NumberFormat nf = (NumberFormat)f;
            nf.setMinimumFractionDigits(0);
            nf.setMaximumFractionDigits(0);
        } else if (f instanceof AngleFormat) {
            ((AngleFormat)f).applyPattern("D\u00b0MM\u2032SS\u2033");
        }
        return f;
    }

    private void append(TableAppender table, Vocabulary vocabulary, short key, String value) throws IOException {
        if (value != null) {
            vocabulary.appendLabel(key, table);
            this.nextColumn(table);
            table.append(value).nextLine();
        }
    }

    private void nextColumn(TableAppender table) {
        table.append(this.beforeFill).nextColumn(this.fillCharacter);
    }

    @Override
    public AbstractLocation parse(CharSequence text, ParsePosition pos) throws ParseException {
        throw new ParseException(Errors.format((short)162, "parse"), pos.getIndex());
    }

    @Override
    public LocationFormat clone() {
        return (LocationFormat)super.clone();
    }
}

