/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.gazetteer;

import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.measure.Latitude;
import org.apache.sis.measure.Longitude;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.crs.DefaultGeographicCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.gazetteer.AbstractLocation;
import org.apache.sis.referencing.gazetteer.GazetteerException;
import org.apache.sis.referencing.gazetteer.ModifiableLocationType;
import org.apache.sis.referencing.gazetteer.ReferencingByIdentifiers;
import org.apache.sis.referencing.gazetteer.SimpleLocation;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

@XmlTransient
public class GeohashReferenceSystem
extends ReferencingByIdentifiers {
    private static final long serialVersionUID = 9162259764027168776L;
    final Format format;
    final DefaultGeographicCRS normalizedCRS;
    final CoordinateOperation denormalize;

    public GeohashReferenceSystem(Format format, GeographicCRS crs) throws GazetteerException {
        super(GeohashReferenceSystem.properties("Geohash", null), GeohashReferenceSystem.types());
        ArgumentChecks.ensureNonNull("format", (Object)format);
        ArgumentChecks.ensureNonNull("crs", crs);
        ArgumentChecks.ensureDimensionMatches("crs", 2, (CoordinateReferenceSystem)crs);
        this.format = format;
        this.normalizedCRS = DefaultGeographicCRS.castOrCopy(crs).forConvention(AxesConvention.NORMALIZED);
        try {
            this.denormalize = CRS.findOperation(this.normalizedCRS, (CoordinateReferenceSystem)crs, null);
        }
        catch (FactoryException e) {
            throw new GazetteerException(e.getLocalizedMessage(), e);
        }
    }

    private static ModifiableLocationType[] types() {
        ModifiableLocationType gzd = new ModifiableLocationType("Geohash");
        gzd.addIdentification((CharSequence)Vocabulary.formatInternational((short)128));
        return new ModifiableLocationType[]{gzd};
    }

    public Format getFormat() {
        return this.format;
    }

    public Coder createCoder() {
        return new Coder();
    }

    private final class Decoder
    extends SimpleLocation {
        Decoder(CharSequence geohash, double[] coordinates) throws TransformException {
            int nc;
            super(GeohashReferenceSystem.this.rootType(), geohash);
            int length = geohash.length();
            int highestOneBit = GeohashReferenceSystem.this.format.highestOneBit;
            byte[] decodingLowerCase = GeohashReferenceSystem.this.format.decodingLowerCase;
            byte[] decodingUpperCase = GeohashReferenceSystem.this.format.decodingUpperCase;
            boolean isEven = true;
            this.minX = -180.0;
            this.maxX = 180.0;
            this.minY = -90.0;
            this.maxY = 90.0;
            for (int i = 0; i < length; i += nc) {
                int c = Character.codePointAt(geohash, i);
                nc = Character.charCount(c);
                if (c >= 48 && c <= 57) {
                    c -= 48;
                } else if ((c = c >= 97 && c <= 122 ? decodingLowerCase[c - 97] : (c >= 65 && c <= 90 ? decodingUpperCase[c - 65] : 0)) == 0) {
                    throw new GazetteerException(Errors.format((short)155, "GeoHash", geohash, geohash.subSequence(i, i + nc)));
                }
                int mask = highestOneBit;
                do {
                    double mid;
                    if (isEven) {
                        mid = (this.minX + this.maxX) / 2.0;
                        if ((c & mask) != 0) {
                            this.minX = mid;
                        } else {
                            this.maxX = mid;
                        }
                    } else {
                        mid = (this.minY + this.maxY) / 2.0;
                        if ((c & mask) != 0) {
                            this.minY = mid;
                        } else {
                            this.maxY = mid;
                        }
                    }
                    boolean bl = isEven = !isEven;
                } while ((mask >>>= 1) != 0);
            }
            if (coordinates != null) {
                this.convert(GeohashReferenceSystem.this.denormalize.getMathTransform(), coordinates);
            }
        }

        @Override
        public CoordinateReferenceSystem getCoordinateReferenceSystem() {
            return GeohashReferenceSystem.this.denormalize.getTargetCRS();
        }
    }

    public class Coder {
        private byte length = (byte)12;
        private transient char[] buffer;
        private transient CoordinateOperation lastOp;
        private final transient double[] coordinates;

        protected Coder() {
            this.coordinates = GeohashReferenceSystem.this.denormalize.getMathTransform().isIdentity() ? null : new double[8];
        }

        public int getHashLength() {
            return this.length;
        }

        public void setHashLength(int length) {
            ArgumentChecks.ensureBetween("length", 1, 255, length);
            this.length = (byte)length;
            this.buffer = null;
        }

        public String encode(double \u03c6, double \u03bb) throws TransformException {
            \u03c6 = Latitude.clamp(\u03c6);
            \u03bb = Longitude.normalize(\u03bb);
            byte[] encoding = GeohashReferenceSystem.this.format.encoding;
            int highestOneBit = GeohashReferenceSystem.this.format.highestOneBit;
            char[] geohash = this.buffer;
            if (geohash == null) {
                this.buffer = geohash = new char[Byte.toUnsignedInt(this.length)];
            }
            boolean isEven = true;
            double xmin = -180.0;
            double ymin = -90.0;
            double xmax = 180.0;
            double ymax = 90.0;
            int ch = 0;
            int bit = highestOneBit;
            int i = 0;
            while (i < geohash.length) {
                double mid;
                if (isEven) {
                    mid = (xmin + xmax) / 2.0;
                    if (\u03bb > mid) {
                        ch |= bit;
                        xmin = mid;
                    } else {
                        xmax = mid;
                    }
                } else {
                    mid = (ymin + ymax) / 2.0;
                    if (\u03c6 > mid) {
                        ch |= bit;
                        ymin = mid;
                    } else {
                        ymax = mid;
                    }
                }
                boolean bl = isEven = !isEven;
                if ((bit >>>= 1) != 0) continue;
                geohash[i++] = (char)encoding[ch];
                bit = highestOneBit;
                ch = 0;
            }
            return new String(geohash);
        }

        public String encode(DirectPosition position) throws TransformException {
            ArgumentChecks.ensureNonNull("position", position);
            CoordinateReferenceSystem ps = position.getCoordinateReferenceSystem();
            if (ps != null && !GeohashReferenceSystem.this.normalizedCRS.equals(ps, ComparisonMode.IGNORE_METADATA)) {
                if (this.lastOp == null || !Utilities.equalsIgnoreMetadata(this.lastOp.getSourceCRS(), ps)) {
                    try {
                        this.lastOp = CRS.findOperation(ps, GeohashReferenceSystem.this.normalizedCRS, null);
                    }
                    catch (FactoryException e) {
                        throw new GazetteerException(e.getLocalizedMessage(), e);
                    }
                }
                position = this.lastOp.getMathTransform().transform(position, null);
            }
            return this.encode(position.getOrdinate(1), position.getOrdinate(0));
        }

        public AbstractLocation decode(CharSequence geohash) throws TransformException {
            ArgumentChecks.ensureNonEmpty("geohash", geohash);
            return new Decoder(geohash, this.coordinates);
        }
    }

    public static enum Format {
        BASE32(16, new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 98, 99, 100, 101, 102, 103, 104, 106, 107, 109, 110, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122});

        final int highestOneBit;
        final byte[] encoding;
        final byte[] decodingLowerCase;
        final byte[] decodingUpperCase;

        private Format(int highestOneBit, byte[] encoding) {
            this.highestOneBit = highestOneBit;
            this.encoding = encoding;
            byte[] decoding = new byte[26];
            for (int i = 10; i < encoding.length; i = (int)((byte)(i + 1))) {
                decoding[encoding[i] - 97] = i;
            }
            this.decodingLowerCase = decoding;
            this.decodingUpperCase = decoding;
        }
    }
}

