/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.measure.Unit;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Length;
import javax.xml.bind.JAXBException;
import org.apache.sis.internal.referencing.MergedProperties;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.io.wkt.Parser;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.crs.DefaultCompoundCRS;
import org.apache.sis.referencing.crs.DefaultDerivedCRS;
import org.apache.sis.referencing.crs.DefaultEngineeringCRS;
import org.apache.sis.referencing.crs.DefaultGeocentricCRS;
import org.apache.sis.referencing.crs.DefaultGeographicCRS;
import org.apache.sis.referencing.crs.DefaultImageCRS;
import org.apache.sis.referencing.crs.DefaultParametricCRS;
import org.apache.sis.referencing.crs.DefaultProjectedCRS;
import org.apache.sis.referencing.crs.DefaultTemporalCRS;
import org.apache.sis.referencing.crs.DefaultVerticalCRS;
import org.apache.sis.referencing.cs.DefaultAffineCS;
import org.apache.sis.referencing.cs.DefaultCartesianCS;
import org.apache.sis.referencing.cs.DefaultCoordinateSystemAxis;
import org.apache.sis.referencing.cs.DefaultCylindricalCS;
import org.apache.sis.referencing.cs.DefaultEllipsoidalCS;
import org.apache.sis.referencing.cs.DefaultLinearCS;
import org.apache.sis.referencing.cs.DefaultParametricCS;
import org.apache.sis.referencing.cs.DefaultPolarCS;
import org.apache.sis.referencing.cs.DefaultSphericalCS;
import org.apache.sis.referencing.cs.DefaultTimeCS;
import org.apache.sis.referencing.cs.DefaultUserDefinedCS;
import org.apache.sis.referencing.cs.DefaultVerticalCS;
import org.apache.sis.referencing.datum.DefaultEllipsoid;
import org.apache.sis.referencing.datum.DefaultEngineeringDatum;
import org.apache.sis.referencing.datum.DefaultGeodeticDatum;
import org.apache.sis.referencing.datum.DefaultImageDatum;
import org.apache.sis.referencing.datum.DefaultParametricDatum;
import org.apache.sis.referencing.datum.DefaultPrimeMeridian;
import org.apache.sis.referencing.datum.DefaultTemporalDatum;
import org.apache.sis.referencing.datum.DefaultVerticalDatum;
import org.apache.sis.referencing.factory.InvalidGeodeticParameterException;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.collection.WeakHashSet;
import org.apache.sis.util.iso.AbstractFactory;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Messages;
import org.apache.sis.xml.XML;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.referencing.ObjectFactory;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AffineCS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.CylindricalCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.LinearCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.UserDefinedCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.util.FactoryException;

public class GeodeticObjectFactory
extends AbstractFactory
implements CRSFactory,
CSFactory,
DatumFactory,
Parser {
    private static final Logger LOGGER = Logging.getLogger("org.apache.sis.referencing.factory");
    private static volatile Constructor<? extends Parser> parserConstructor;
    private final Map<String, ?> defaultProperties;
    private volatile MathTransformFactory mtFactory;
    private final WeakHashSet<AbstractIdentifiedObject> pool;
    private final AtomicReference<Parser> parser;

    public GeodeticObjectFactory() {
        this(null);
    }

    public GeodeticObjectFactory(Map<String, ?> properties) {
        properties = properties == null || properties.isEmpty() ? Collections.emptyMap() : CollectionsExt.compact(new HashMap(properties));
        this.defaultProperties = properties;
        this.pool = new WeakHashSet<AbstractIdentifiedObject>(AbstractIdentifiedObject.class);
        this.parser = new AtomicReference();
    }

    protected Map<String, ?> complete(Map<String, ?> properties) {
        ArgumentChecks.ensureNonNull("properties", properties);
        return new MergedProperties(properties, this.defaultProperties){

            @Override
            protected Object invisibleEntry(Object key) {
                if ("mtFactory".equals(key)) {
                    return GeodeticObjectFactory.this.getMathTransformFactory();
                }
                return super.invisibleEntry(key);
            }
        };
    }

    final MathTransformFactory getMathTransformFactory() {
        MathTransformFactory factory = this.mtFactory;
        if (factory == null) {
            this.mtFactory = factory = DefaultFactories.forBuildin(MathTransformFactory.class);
        }
        return factory;
    }

    private <T extends AbstractIdentifiedObject> T unique(String caller, T object) {
        T c = this.pool.unique(object);
        if (c == object && LOGGER.isLoggable(Level.FINE)) {
            String id = IdentifiedObjects.toString(IdentifiedObjects.getIdentifier(c, null));
            LogRecord record = Messages.getResources(null).getLogRecord(Level.FINE, id != null ? (short)9 : 10, c.getInterface(), c.getName().getCode(), id);
            record.setSourceClassName(GeodeticObjectFactory.class.getCanonicalName());
            record.setSourceMethodName(caller);
            record.setLoggerName(LOGGER.getName());
            LOGGER.log(record);
        }
        return c;
    }

    public GeocentricCRS createGeocentricCRS(Map<String, ?> properties, GeodeticDatum datum, CartesianCS cs) throws FactoryException {
        DefaultGeocentricCRS crs;
        try {
            crs = new DefaultGeocentricCRS(this.complete(properties), datum, cs);
        }
        catch (IllegalArgumentException exception) {
            throw new InvalidGeodeticParameterException(exception);
        }
        return this.unique("createGeocentricCRS", crs);
    }

    public CartesianCS createCartesianCS(Map<String, ?> properties, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1, CoordinateSystemAxis axis2) throws FactoryException {
        DefaultCartesianCS cs;
        try {
            cs = new DefaultCartesianCS(this.complete(properties), axis0, axis1, axis2);
        }
        catch (IllegalArgumentException exception) {
            throw new InvalidGeodeticParameterException(exception);
        }
        return this.unique("createCartesianCS", cs);
    }

    public GeocentricCRS createGeocentricCRS(Map<String, ?> properties, GeodeticDatum datum, SphericalCS cs) throws FactoryException {
        DefaultGeocentricCRS crs;
        try {
            crs = new DefaultGeocentricCRS(this.complete(properties), datum, cs);
        }
        catch (IllegalArgumentException exception) {
            throw new InvalidGeodeticParameterException(exception);
        }
        return this.unique("createGeocentricCRS", crs);
    }

    public SphericalCS createSphericalCS(Map<String, ?> properties, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1, CoordinateSystemAxis axis2) throws FactoryException {
        DefaultSphericalCS cs;
        try {
            cs = new DefaultSphericalCS(this.complete(properties), axis0, axis1, axis2);
        }
        catch (IllegalArgumentException exception) {
            throw new InvalidGeodeticParameterException(exception);
        }
        return this.unique("createSphericalCS", cs);
    }

    public GeographicCRS createGeographicCRS(Map<String, ?> properties, GeodeticDatum datum, EllipsoidalCS cs) throws FactoryException {
        DefaultGeographicCRS crs;
        try {
            crs = new DefaultGeographicCRS(this.complete(properties), datum, cs);
        }
        catch (IllegalArgumentException exception) {
            throw new InvalidGeodeticParameterException(exception);
        }
        return this.unique("createGeographicCRS", crs);
    }

    public GeodeticDatum createGeodeticDatum(Map<String, ?> properties, Ellipsoid ellipsoid, PrimeMeridian primeMeridian) throws FactoryException {
        DefaultGeodeticDatum datum;
        try {
            datum = new DefaultGeodeticDatum(this.complete(properties), ellipsoid, primeMeridian);
        }
        catch (IllegalArgumentException exception) {
            throw new InvalidGeodeticParameterException(exception);
        }
        return this.unique("createGeodeticDatum", datum);
    }

    public PrimeMeridian createPrimeMeridian(Map<String, ?> properties, double longitude, Unit<Angle> angularUnit) throws FactoryException {
        DefaultPrimeMeridian meridian;
        try {
            meridian = new DefaultPrimeMeridian(this.complete(properties), longitude, angularUnit);
        }
        catch (IllegalArgumentException exception) {
            throw new InvalidGeodeticParameterException(exception);
        }
        return this.unique("createPrimeMeridian", meridian);
    }

    public EllipsoidalCS createEllipsoidalCS(Map<String, ?> properties, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1) throws FactoryException {
        DefaultEllipsoidalCS cs;
        try {
            cs = new DefaultEllipsoidalCS(this.complete(properties), axis0, axis1);
        }
        catch (IllegalArgumentException exception) {
            throw new InvalidGeodeticParameterException(exception);
        }
        return this.unique("createEllipsoidalCS", cs);
    }

    public EllipsoidalCS createEllipsoidalCS(Map<String, ?> properties, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1, CoordinateSystemAxis axis2) throws FactoryException {
        DefaultEllipsoidalCS cs;
        try {
            cs = new DefaultEllipsoidalCS(this.complete(properties), axis0, axis1, axis2);
        }
        catch (IllegalArgumentException exception) {
            throw new InvalidGeodeticParameterException(exception);
        }
        return this.unique("createEllipsoidalCS", cs);
    }

    public Ellipsoid createEllipsoid(Map<String, ?> properties, double semiMajorAxis, double semiMinorAxis, Unit<Length> unit) throws FactoryException {
        DefaultEllipsoid ellipsoid;
        try {
            ellipsoid = DefaultEllipsoid.createEllipsoid(this.complete(properties), semiMajorAxis, semiMinorAxis, unit);
        }
        catch (IllegalArgumentException exception) {
            throw new InvalidGeodeticParameterException(exception);
        }
        return this.unique("createEllipsoid", ellipsoid);
    }

    public Ellipsoid createFlattenedSphere(Map<String, ?> properties, double semiMajorAxis, double inverseFlattening, Unit<Length> unit) throws FactoryException {
        DefaultEllipsoid ellipsoid;
        try {
            ellipsoid = DefaultEllipsoid.createFlattenedSphere(this.complete(properties), semiMajorAxis, inverseFlattening, unit);
        }
        catch (IllegalArgumentException exception) {
            throw new InvalidGeodeticParameterException(exception);
        }
        return this.unique("createFlattenedSphere", ellipsoid);
    }

    public ProjectedCRS createProjectedCRS(Map<String, ?> properties, GeographicCRS baseCRS, Conversion conversion, CartesianCS derivedCS) throws FactoryException {
        DefaultProjectedCRS crs;
        try {
            crs = new DefaultProjectedCRS(this.complete(properties), baseCRS, conversion, derivedCS);
        }
        catch (IllegalArgumentException exception) {
            Throwable cause = exception.getCause();
            if (cause instanceof FactoryException) {
                throw (FactoryException)cause;
            }
            throw new InvalidGeodeticParameterException(exception);
        }
        return this.unique("createProjectedCRS", crs);
    }

    public CartesianCS createCartesianCS(Map<String, ?> properties, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1) throws FactoryException {
        DefaultCartesianCS cs;
        try {
            cs = new DefaultCartesianCS(this.complete(properties), axis0, axis1);
        }
        catch (IllegalArgumentException exception) {
            throw new InvalidGeodeticParameterException(exception);
        }
        return this.unique("createCartesianCS", cs);
    }

    public DerivedCRS createDerivedCRS(Map<String, ?> properties, CoordinateReferenceSystem baseCRS, Conversion conversion, CoordinateSystem derivedCS) throws FactoryException {
        DefaultDerivedCRS crs;
        ArgumentChecks.ensureCanCast("baseCRS", SingleCRS.class, baseCRS);
        try {
            crs = DefaultDerivedCRS.create(this.complete(properties), (SingleCRS)baseCRS, conversion, derivedCS);
        }
        catch (IllegalArgumentException exception) {
            Throwable cause = exception.getCause();
            if (cause instanceof FactoryException) {
                throw (FactoryException)cause;
            }
            throw new InvalidGeodeticParameterException(exception);
        }
        return this.unique("createDerivedCRS", crs);
    }

    public VerticalCRS createVerticalCRS(Map<String, ?> properties, VerticalDatum datum, VerticalCS cs) throws FactoryException {
        DefaultVerticalCRS crs;
        try {
            crs = new DefaultVerticalCRS(this.complete(properties), datum, cs);
        }
        catch (IllegalArgumentException exception) {
            throw new InvalidGeodeticParameterException(exception);
        }
        return this.unique("createVerticalCRS", crs);
    }

    public VerticalDatum createVerticalDatum(Map<String, ?> properties, VerticalDatumType type) throws FactoryException {
        DefaultVerticalDatum datum;
        try {
            datum = new DefaultVerticalDatum(this.complete(properties), type);
        }
        catch (IllegalArgumentException exception) {
            throw new InvalidGeodeticParameterException(exception);
        }
        return this.unique("createVerticalDatum", datum);
    }

    public VerticalCS createVerticalCS(Map<String, ?> properties, CoordinateSystemAxis axis) throws FactoryException {
        DefaultVerticalCS cs;
        try {
            cs = new DefaultVerticalCS(this.complete(properties), axis);
        }
        catch (IllegalArgumentException exception) {
            throw new InvalidGeodeticParameterException(exception);
        }
        return this.unique("createVerticalCS", cs);
    }

    public TemporalCRS createTemporalCRS(Map<String, ?> properties, TemporalDatum datum, TimeCS cs) throws FactoryException {
        DefaultTemporalCRS crs;
        try {
            crs = new DefaultTemporalCRS(this.complete(properties), datum, cs);
        }
        catch (IllegalArgumentException exception) {
            throw new InvalidGeodeticParameterException(exception);
        }
        return this.unique("createTemporalCRS", crs);
    }

    public TemporalDatum createTemporalDatum(Map<String, ?> properties, Date origin) throws FactoryException {
        DefaultTemporalDatum datum;
        try {
            datum = new DefaultTemporalDatum(this.complete(properties), origin);
        }
        catch (IllegalArgumentException exception) {
            throw new InvalidGeodeticParameterException(exception);
        }
        return this.unique("createTemporalDatum", datum);
    }

    public TimeCS createTimeCS(Map<String, ?> properties, CoordinateSystemAxis axis) throws FactoryException {
        DefaultTimeCS cs;
        try {
            cs = new DefaultTimeCS(this.complete(properties), axis);
        }
        catch (IllegalArgumentException exception) {
            throw new InvalidGeodeticParameterException(exception);
        }
        return this.unique("createTimeCS", cs);
    }

    public DefaultParametricCRS createParametricCRS(Map<String, ?> properties, DefaultParametricDatum datum, DefaultParametricCS cs) throws FactoryException {
        DefaultParametricCRS crs;
        try {
            crs = new DefaultParametricCRS(this.complete(properties), datum, cs);
        }
        catch (IllegalArgumentException exception) {
            throw new InvalidGeodeticParameterException(exception);
        }
        return this.unique("createParametricCRS", crs);
    }

    public DefaultParametricDatum createParametricDatum(Map<String, ?> properties) throws FactoryException {
        DefaultParametricDatum datum;
        try {
            datum = new DefaultParametricDatum(this.complete(properties));
        }
        catch (IllegalArgumentException exception) {
            throw new InvalidGeodeticParameterException(exception);
        }
        return this.unique("createParametricDatum", datum);
    }

    public DefaultParametricCS createParametricCS(Map<String, ?> properties, CoordinateSystemAxis axis) throws FactoryException {
        DefaultParametricCS cs;
        try {
            cs = new DefaultParametricCS(this.complete(properties), axis);
        }
        catch (IllegalArgumentException exception) {
            throw new InvalidGeodeticParameterException(exception);
        }
        return this.unique("createParametricCS", cs);
    }

    public CompoundCRS createCompoundCRS(Map<String, ?> properties, CoordinateReferenceSystem ... components) throws FactoryException {
        DefaultCompoundCRS crs;
        try {
            crs = new DefaultCompoundCRS(this.complete(properties), components);
        }
        catch (IllegalArgumentException exception) {
            throw new InvalidGeodeticParameterException(exception);
        }
        return this.unique("createCompoundCRS", crs);
    }

    public ImageCRS createImageCRS(Map<String, ?> properties, ImageDatum datum, AffineCS cs) throws FactoryException {
        DefaultImageCRS crs;
        try {
            crs = new DefaultImageCRS(this.complete(properties), datum, cs);
        }
        catch (IllegalArgumentException exception) {
            throw new InvalidGeodeticParameterException(exception);
        }
        return this.unique("createImageCRS", crs);
    }

    public ImageDatum createImageDatum(Map<String, ?> properties, PixelInCell pixelInCell) throws FactoryException {
        DefaultImageDatum datum;
        try {
            datum = new DefaultImageDatum(this.complete(properties), pixelInCell);
        }
        catch (IllegalArgumentException exception) {
            throw new InvalidGeodeticParameterException(exception);
        }
        return this.unique("createImageDatum", datum);
    }

    public AffineCS createAffineCS(Map<String, ?> properties, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1) throws FactoryException {
        DefaultAffineCS cs;
        try {
            cs = new DefaultAffineCS(this.complete(properties), axis0, axis1);
        }
        catch (IllegalArgumentException exception) {
            throw new InvalidGeodeticParameterException(exception);
        }
        return this.unique("createAffineCS", cs);
    }

    public EngineeringCRS createEngineeringCRS(Map<String, ?> properties, EngineeringDatum datum, CoordinateSystem cs) throws FactoryException {
        DefaultEngineeringCRS crs;
        try {
            crs = new DefaultEngineeringCRS(this.complete(properties), datum, cs);
        }
        catch (IllegalArgumentException exception) {
            throw new InvalidGeodeticParameterException(exception);
        }
        return this.unique("createEngineeringCRS", crs);
    }

    public EngineeringDatum createEngineeringDatum(Map<String, ?> properties) throws FactoryException {
        DefaultEngineeringDatum datum;
        try {
            datum = new DefaultEngineeringDatum(this.complete(properties));
        }
        catch (IllegalArgumentException exception) {
            throw new InvalidGeodeticParameterException(exception);
        }
        return this.unique("createEngineeringDatum", datum);
    }

    public AffineCS createAffineCS(Map<String, ?> properties, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1, CoordinateSystemAxis axis2) throws FactoryException {
        DefaultAffineCS cs;
        try {
            cs = new DefaultAffineCS(this.complete(properties), axis0, axis1, axis2);
        }
        catch (IllegalArgumentException exception) {
            throw new InvalidGeodeticParameterException(exception);
        }
        return this.unique("createAffineCS", cs);
    }

    public CylindricalCS createCylindricalCS(Map<String, ?> properties, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1, CoordinateSystemAxis axis2) throws FactoryException {
        DefaultCylindricalCS cs;
        try {
            cs = new DefaultCylindricalCS(this.complete(properties), axis0, axis1, axis2);
        }
        catch (IllegalArgumentException exception) {
            throw new InvalidGeodeticParameterException(exception);
        }
        return this.unique("createCylindricalCS", cs);
    }

    public PolarCS createPolarCS(Map<String, ?> properties, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1) throws FactoryException {
        DefaultPolarCS cs;
        try {
            cs = new DefaultPolarCS(this.complete(properties), axis0, axis1);
        }
        catch (IllegalArgumentException exception) {
            throw new InvalidGeodeticParameterException(exception);
        }
        return this.unique("createPolarCS", cs);
    }

    public LinearCS createLinearCS(Map<String, ?> properties, CoordinateSystemAxis axis) throws FactoryException {
        DefaultLinearCS cs;
        try {
            cs = new DefaultLinearCS(this.complete(properties), axis);
        }
        catch (IllegalArgumentException exception) {
            throw new InvalidGeodeticParameterException(exception);
        }
        return this.unique("createLinearCS", cs);
    }

    public UserDefinedCS createUserDefinedCS(Map<String, ?> properties, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1) throws FactoryException {
        DefaultUserDefinedCS cs;
        try {
            cs = new DefaultUserDefinedCS(this.complete(properties), axis0, axis1);
        }
        catch (IllegalArgumentException exception) {
            throw new InvalidGeodeticParameterException(exception);
        }
        return this.unique("createUserDefinedCS", cs);
    }

    public UserDefinedCS createUserDefinedCS(Map<String, ?> properties, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1, CoordinateSystemAxis axis2) throws FactoryException {
        DefaultUserDefinedCS cs;
        try {
            cs = new DefaultUserDefinedCS(this.complete(properties), axis0, axis1, axis2);
        }
        catch (IllegalArgumentException exception) {
            throw new InvalidGeodeticParameterException(exception);
        }
        return this.unique("createUserDefinedCS", cs);
    }

    public CoordinateSystemAxis createCoordinateSystemAxis(Map<String, ?> properties, String abbreviation, AxisDirection direction, Unit<?> unit) throws FactoryException {
        DefaultCoordinateSystemAxis axis;
        try {
            axis = new DefaultCoordinateSystemAxis(this.complete(properties), abbreviation, direction, unit);
        }
        catch (IllegalArgumentException exception) {
            throw new InvalidGeodeticParameterException(exception);
        }
        return this.unique("createCoordinateSystemAxis", axis);
    }

    public CoordinateReferenceSystem createFromXML(String xml) throws FactoryException {
        Object object;
        try {
            object = XML.unmarshal(xml);
        }
        catch (JAXBException e) {
            String message = e.getLocalizedMessage();
            Throwable cause = e.getCause();
            if (cause instanceof Exception) {
                if ((cause = Exceptions.unwrap((Exception)cause)) instanceof JAXBException) {
                    e = (JAXBException)cause;
                }
                if (message == null) {
                    message = cause.getLocalizedMessage();
                }
            }
            throw new FactoryException(message, (Throwable)e);
        }
        if (object instanceof CoordinateReferenceSystem) {
            return (CoordinateReferenceSystem)object;
        }
        throw new FactoryException(Errors.getResources(this.defaultProperties).getString((short)50, CoordinateReferenceSystem.class, object.getClass()));
    }

    public CoordinateReferenceSystem createFromWKT(String text) throws FactoryException {
        Object object;
        Parser p = this.parser.getAndSet(null);
        if (p == null) {
            try {
                Constructor<? extends Parser> c = parserConstructor;
                if (c == null) {
                    Constructor<? extends Parser> cp = c = Class.forName("org.apache.sis.io.wkt.GeodeticObjectParser").asSubclass(Parser.class).getConstructor(Map.class, ObjectFactory.class, MathTransformFactory.class);
                    AccessController.doPrivileged(() -> {
                        cp.setAccessible(true);
                        return null;
                    });
                    parserConstructor = c;
                }
                p = c.newInstance(this.defaultProperties, this, this.getMathTransformFactory());
            }
            catch (ReflectiveOperationException e) {
                throw new FactoryException((Throwable)e);
            }
        }
        try {
            object = p.createFromWKT(text);
        }
        catch (FactoryException e) {
            for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                if (!(cause instanceof ParameterNotFoundException)) continue;
                throw new InvalidGeodeticParameterException(e.getLocalizedMessage(), cause);
            }
            throw e;
        }
        this.parser.set(p);
        if (object instanceof CoordinateReferenceSystem) {
            return (CoordinateReferenceSystem)object;
        }
        throw new FactoryException(Errors.getResources(this.defaultProperties).getString((short)50, CoordinateReferenceSystem.class, object.getClass()));
    }
}

