/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory;

import java.io.Console;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Classes;
import org.opengis.referencing.IdentifiedObject;

final class CacheRecord
implements Comparable<CacheRecord> {
    private final String key;
    private final String value;
    private final String identity;
    private final int code;

    private CacheRecord(Object key, Object value) {
        int code;
        this.identity = Classes.getShortClassName(value) + '@' + Integer.toHexString(System.identityHashCode(value));
        if (value instanceof Collection) {
            Iterator it = ((Collection)value).iterator();
            value = it.hasNext() ? it.next() : null;
        }
        String text = value instanceof IdentifiedObject ? String.valueOf(((IdentifiedObject)value).getName()) : null;
        this.value = text;
        this.key = text = String.valueOf(key);
        int i = (text = text.substring(text.indexOf(91) + 1)).indexOf(32);
        if (i >= 1) {
            text = text.substring(0, i);
        }
        try {
            code = Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            code = Integer.MAX_VALUE;
        }
        this.code = code;
    }

    @Override
    public int compareTo(CacheRecord other) {
        if (this.code < other.code) {
            return -1;
        }
        if (this.code > other.code) {
            return 1;
        }
        return this.key.compareTo(other.key);
    }

    static void printCacheContent(Map<?, ?> cache, PrintWriter out) {
        ArrayList<CacheRecord> list = new ArrayList<CacheRecord>(cache.size() + 10);
        int codeLength = 0;
        int identityLength = 0;
        for (Map.Entry<?, ?> entry : cache.entrySet()) {
            CacheRecord record = new CacheRecord(entry.getKey(), entry.getValue());
            int length = record.key.length();
            if (length > codeLength) {
                codeLength = length;
            }
            if ((length = record.identity.length()) > identityLength) {
                identityLength = length;
            }
            list.add(record);
        }
        codeLength += 2;
        identityLength += 2;
        Object[] records = list.toArray(new CacheRecord[list.size()]);
        Arrays.sort(records);
        if (out == null) {
            Console c = System.console();
            out = c != null ? c.writer() : new PrintWriter(System.out);
        }
        for (Object record : records) {
            out.print(((CacheRecord)record).key);
            out.print(CharSequences.spaces(codeLength - ((CacheRecord)record).key.length()));
            out.print(((CacheRecord)record).identity);
            if (((CacheRecord)record).value != null) {
                out.print(CharSequences.spaces(identityLength - ((CacheRecord)record).identity.length()));
                out.println(((CacheRecord)record).value);
                continue;
            }
            out.println();
        }
        out.flush();
    }
}

