/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.datum;

import java.util.Date;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.internal.jaxb.gml.UniversalTimeAdapter;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.datum.AbstractDatum;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.TemporalDatum;

@XmlType(name="TemporalDatumType")
@XmlRootElement(name="TemporalDatum")
public class DefaultTemporalDatum
extends AbstractDatum
implements TemporalDatum {
    private static final long serialVersionUID = 3357241732140076884L;
    private long origin;

    public DefaultTemporalDatum(Map<String, ?> properties, Date origin) {
        super(properties);
        ArgumentChecks.ensureNonNull("origin", origin);
        this.origin = origin.getTime();
    }

    protected DefaultTemporalDatum(TemporalDatum datum) {
        super((Datum)datum);
        this.origin = MetadataUtilities.toMilliseconds(datum.getOrigin());
    }

    public static DefaultTemporalDatum castOrCopy(TemporalDatum object) {
        return object == null || object instanceof DefaultTemporalDatum ? (DefaultTemporalDatum)object : new DefaultTemporalDatum(object);
    }

    public Class<? extends TemporalDatum> getInterface() {
        return TemporalDatum.class;
    }

    @XmlSchemaType(name="dateTime")
    @XmlElement(name="origin", required=true)
    @XmlJavaTypeAdapter(value=UniversalTimeAdapter.class)
    public Date getOrigin() {
        return MetadataUtilities.toDate(this.origin);
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object, mode)) {
            return false;
        }
        switch (mode) {
            case STRICT: {
                return this.origin == ((DefaultTemporalDatum)object).origin;
            }
        }
        return Objects.equals(this.getOrigin(), ((TemporalDatum)object).getOrigin());
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + this.origin;
    }

    @Override
    protected String formatTo(Formatter formatter) {
        super.formatTo(formatter);
        formatter.append(new Origin(this.getOrigin()));
        if (formatter.getConvention().majorVersion() == 1) {
            formatter.setInvalidWKT(this, null);
        }
        return formatter.shortOrLong("TDatum", "TimeDatum");
    }

    private DefaultTemporalDatum() {
        this.origin = Long.MIN_VALUE;
    }

    private void setOrigin(Date value) {
        if (this.origin == Long.MIN_VALUE) {
            this.origin = value.getTime();
        } else {
            MetadataUtilities.propertyAlreadySet(DefaultTemporalDatum.class, "setOrigin", "origin");
        }
    }

    private static final class Origin
    extends FormattableObject {
        private final Date origin;

        Origin(Date origin) {
            this.origin = origin;
        }

        @Override
        protected String formatTo(Formatter formatter) {
            formatter.append(this.origin);
            return "TimeOrigin";
        }
    }
}

