/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.datum;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.Matrix4;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.extent.Extent;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.operation.Matrix;

public class BursaWolfParameters
extends FormattableObject
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 754825592343010900L;
    static final double PPM = 1000000.0;
    public double tX;
    public double tY;
    public double tZ;
    public double rX;
    public double rY;
    public double rZ;
    public double dS;
    private final GeodeticDatum targetDatum;
    private final Extent domainOfValidity;

    public BursaWolfParameters(GeodeticDatum targetDatum, Extent domainOfValidity) {
        this.targetDatum = targetDatum;
        this.domainOfValidity = domainOfValidity;
    }

    void verify(PrimeMeridian pm) throws IllegalArgumentException {
        PrimeMeridian actual;
        if (this.targetDatum != null && (actual = this.targetDatum.getPrimeMeridian()).getGreenwichLongitude() != 0.0 && !Utilities.equalsIgnoreMetadata(pm, actual)) {
            throw new IllegalArgumentException(Resources.format((short)36, IdentifiedObjects.getName((IdentifiedObject)pm, null), IdentifiedObjects.getName((IdentifiedObject)actual, null)));
        }
        ArgumentChecks.ensureFinite("tX", this.tX);
        ArgumentChecks.ensureFinite("tY", this.tY);
        ArgumentChecks.ensureFinite("tZ", this.tZ);
        ArgumentChecks.ensureFinite("rX", this.rX);
        ArgumentChecks.ensureFinite("rY", this.rY);
        ArgumentChecks.ensureFinite("rZ", this.rZ);
        ArgumentChecks.ensureBetween("dS", -1000000.0, 1000000.0, this.dS);
    }

    public GeodeticDatum getTargetDatum() {
        return this.targetDatum;
    }

    public double[] getValues() {
        double[] elements = new double[this.dS != 0.0 ? 7 : (this.rZ != 0.0 || this.rY != 0.0 || this.rX != 0.0 ? 6 : 3)];
        switch (elements.length) {
            default: {
                elements[6] = this.dS;
            }
            case 6: {
                elements[5] = this.rZ;
                elements[4] = this.rY;
                elements[3] = this.rX;
            }
            case 3: 
        }
        elements[2] = this.tZ;
        elements[1] = this.tY;
        elements[0] = this.tX;
        return elements;
    }

    public void setValues(double ... elements) {
        switch (elements.length) {
            default: {
                this.dS = elements[6];
            }
            case 6: {
                this.rZ = elements[5];
            }
            case 5: {
                this.rY = elements[4];
            }
            case 4: {
                this.rX = elements[3];
            }
            case 3: {
                this.tZ = elements[2];
            }
            case 2: {
                this.tY = elements[1];
            }
            case 1: {
                this.tX = elements[0];
            }
            case 0: 
        }
    }

    final boolean isToWGS84() {
        return this.targetDatum != null && IdentifiedObjects.isHeuristicMatchForName((IdentifiedObject)this.targetDatum, "WGS84");
    }

    public boolean isIdentity() {
        return this.tX == 0.0 && this.tY == 0.0 && this.tZ == 0.0 && this.isTranslation();
    }

    public boolean isTranslation() {
        return this.rX == 0.0 && this.rY == 0.0 && this.rZ == 0.0 && this.dS == 0.0;
    }

    public void reverseRotation() {
        this.rX = -this.rX;
        this.rY = -this.rY;
        this.rZ = -this.rZ;
    }

    public void invert() {
        double[] values = this.getValues();
        for (int i = 0; i < values.length; ++i) {
            values[i] = -values[i];
        }
        this.setValues(values);
    }

    DoubleDouble period(Date time) {
        return null;
    }

    DoubleDouble param(int index, DoubleDouble period) {
        double p;
        switch (index) {
            case 0: {
                p = this.tX;
                break;
            }
            case 1: {
                p = this.tY;
                break;
            }
            case 2: {
                p = this.tZ;
                break;
            }
            case 3: {
                p = this.rX;
                break;
            }
            case 4: {
                p = this.rY;
                break;
            }
            case 5: {
                p = this.rZ;
                break;
            }
            case 6: {
                p = this.dS;
                break;
            }
            default: {
                throw new AssertionError(index);
            }
        }
        return DoubleDouble.createAndGuessError(p);
    }

    public Matrix getPositionVectorTransformation(Date time) {
        DoubleDouble period = this.period(time);
        if (period == null && this.isTranslation()) {
            Matrix4 matrix = new Matrix4();
            matrix.m03 = this.tX;
            matrix.m13 = this.tY;
            matrix.m23 = this.tZ;
            return matrix;
        }
        DoubleDouble RS = DoubleDouble.createSecondsToRadians();
        DoubleDouble S = this.param(6, period);
        S.divide(1000000.0);
        S.add(1.0);
        RS.multiply(S);
        DoubleDouble X = this.param(3, period);
        X.multiply(RS);
        DoubleDouble Y = this.param(4, period);
        Y.multiply(RS);
        DoubleDouble Z = this.param(5, period);
        Z.multiply(RS);
        DoubleDouble mX = new DoubleDouble(X);
        mX.negate();
        DoubleDouble mY = new DoubleDouble(Y);
        mY.negate();
        DoubleDouble mZ = new DoubleDouble(Z);
        mZ.negate();
        Integer O = 0;
        return Matrices.create(4, 4, new Number[]{S, mZ, Y, this.param(0, period), Z, S, mX, this.param(1, period), mY, X, S, this.param(2, period), O, O, O, 1});
    }

    public void setPositionVectorTransformation(Matrix matrix, double tolerance) throws IllegalArgumentException {
        int numRow = matrix.getNumRow();
        int numCol = matrix.getNumCol();
        if (numRow != 4 || numCol != 4) {
            Integer n = 4;
            throw new IllegalArgumentException(Errors.format((short)83, n, n, numRow, numCol));
        }
        if (!Matrices.isAffine(matrix)) {
            throw new IllegalArgumentException(Resources.format((short)59));
        }
        this.tX = matrix.getElement(0, 3);
        this.tY = matrix.getElement(1, 3);
        this.tZ = matrix.getElement(2, 3);
        if (Matrices.isTranslation(matrix)) {
            return;
        }
        DoubleDouble S = DoubleDouble.castOrCopy(BursaWolfParameters.getNumber(matrix, 0, 0));
        S.addGuessError(BursaWolfParameters.getNumber(matrix, 1, 1));
        S.addGuessError(BursaWolfParameters.getNumber(matrix, 2, 2));
        S.divide(3.0);
        DoubleDouble RS = DoubleDouble.createSecondsToRadians();
        RS.multiply(S);
        S.add(-1.0);
        S.multiply(1000000.0);
        this.dS = S.doubleValue();
        for (int j = 0; j < 3; ++j) {
            if (!(Math.abs((matrix.getElement(j, j) - 1.0) * 1000000.0 - this.dS) <= tolerance)) {
                throw new IllegalArgumentException(Resources.format((short)57));
            }
            block6: for (int i = j + 1; i < 3; ++i) {
                S.setFrom(RS);
                S.inverseDivideGuessError(BursaWolfParameters.getNumber(matrix, j, i));
                double value = S.value;
                double error = S.error;
                S.setFrom(RS);
                S.inverseDivideGuessError(BursaWolfParameters.getNumber(matrix, i, j));
                if (!(Math.abs(value + S.value) <= tolerance)) {
                    throw new IllegalArgumentException(Resources.format((short)58));
                }
                S.subtract(value, error);
                S.multiply(0.5);
                value = S.doubleValue();
                switch (j * 4 + i) {
                    case 1: {
                        this.rZ = value;
                        continue block6;
                    }
                    case 2: {
                        this.rY = -value;
                        continue block6;
                    }
                    case 6: {
                        this.rX = value;
                    }
                }
            }
        }
    }

    private static Number getNumber(Matrix matrix, int row, int column) {
        if (matrix instanceof MatrixSIS) {
            return ((MatrixSIS)matrix).getNumber(row, column);
        }
        return matrix.getElement(row, column);
    }

    public Extent getDomainOfValidity() {
        if (this.domainOfValidity == null && this.targetDatum != null) {
            return this.targetDatum.getDomainOfValidity();
        }
        return this.domainOfValidity;
    }

    public BursaWolfParameters clone() {
        try {
            return (BursaWolfParameters)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new AssertionError((Object)exception);
        }
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            BursaWolfParameters that = (BursaWolfParameters)object;
            return Arrays.equals(this.getValues(), that.getValues()) && Objects.equals(this.targetDatum, that.targetDatum) && Objects.equals(this.domainOfValidity, that.domainOfValidity);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.getValues()) ^ 0x82FA9E54;
    }

    @Override
    protected String formatTo(Formatter formatter) {
        double[] values;
        for (double value : values = this.getValues()) {
            formatter.append(value);
        }
        if (this.isToWGS84()) {
            if (values.length > 7) {
                formatter.setInvalidWKT(BursaWolfParameters.class, null);
            }
            return "ToWGS84";
        }
        formatter.setInvalidWKT(BursaWolfParameters.class, null);
        String name = IdentifiedObjects.getSimpleNameOrIdentifier((IdentifiedObject)this.getTargetDatum());
        if (name == null) {
            name = "Unknown";
        }
        return "To" + name;
    }
}

