/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.cs;

import java.util.Arrays;
import java.util.Objects;
import javax.measure.IncommensurableException;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Length;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.measure.Angle;
import org.apache.sis.measure.ElevationAngle;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.cs.AxisFilter;
import org.apache.sis.referencing.cs.Codes;
import org.apache.sis.referencing.cs.DirectionAlongMeridian;
import org.apache.sis.referencing.cs.Normalizer;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Static;
import org.apache.sis.util.logging.Logging;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.RangeMeaning;
import org.opengis.referencing.operation.Matrix;

public final class CoordinateSystems
extends Static {
    private CoordinateSystems() {
    }

    public static AxisDirection parseAxisDirection(String name) throws IllegalArgumentException {
        ArgumentChecks.ensureNonNull("name", name);
        name = CharSequences.trimWhitespaces(name);
        AxisDirection candidate = AxisDirections.valueOf(name);
        if (candidate != null) {
            return candidate;
        }
        DirectionAlongMeridian meridian = DirectionAlongMeridian.parse(name);
        if (meridian != null) {
            candidate = meridian.getDirection();
            assert (candidate == AxisDirections.valueOf(meridian.toString()));
            return candidate;
        }
        throw new IllegalArgumentException(Resources.format((short)67, name));
    }

    public static AxisDirection directionAlongMeridian(AxisDirection baseDirection, double meridian) {
        return new DirectionAlongMeridian(baseDirection, meridian).getDirection();
    }

    public static Angle angle(AxisDirection source, AxisDirection target) {
        DirectionAlongMeridian tgtMeridian;
        ArgumentChecks.ensureNonNull("source", source);
        ArgumentChecks.ensureNonNull("target", target);
        int c = AxisDirections.angleForCompass(source, target);
        if (c != Integer.MIN_VALUE) {
            return new Angle((double)c * 22.5);
        }
        c = AxisDirections.angleForGeocentric(source, target);
        if (c != Integer.MIN_VALUE) {
            return new Angle(c * 90);
        }
        c = AxisDirections.angleForDisplay(source, target);
        if (c != Integer.MIN_VALUE) {
            return new Angle(c * 90);
        }
        DirectionAlongMeridian srcMeridian = AxisDirections.isUserDefined(source) ? DirectionAlongMeridian.parse(source) : null;
        DirectionAlongMeridian directionAlongMeridian = tgtMeridian = AxisDirections.isUserDefined(target) ? DirectionAlongMeridian.parse(target) : null;
        if (srcMeridian != null && tgtMeridian != null) {
            return new Angle(srcMeridian.angle(tgtMeridian));
        }
        boolean srcVrt = AxisDirections.isVertical(source);
        boolean tgtVrt = AxisDirections.isVertical(target);
        if (tgtVrt) {
            if (srcVrt) {
                return new Angle(source.equals((Object)target) ? 0.0 : (target.equals((Object)AxisDirection.UP) ? 180.0 : -180.0));
            }
            if (AxisDirections.isCompass(source) || srcMeridian != null) {
                return target.equals((Object)AxisDirection.UP) ? ElevationAngle.ZENITH : ElevationAngle.NADIR;
            }
        } else if (srcVrt && (AxisDirections.isCompass(target) || tgtMeridian != null)) {
            return source.equals((Object)AxisDirection.UP) ? ElevationAngle.NADIR : ElevationAngle.ZENITH;
        }
        return null;
    }

    public static Matrix swapAndScaleAxes(CoordinateSystem sourceCS, CoordinateSystem targetCS) throws IllegalArgumentException, IncommensurableException {
        ArgumentChecks.ensureNonNull("sourceCS", sourceCS);
        ArgumentChecks.ensureNonNull("targetCS", targetCS);
        if (!Classes.implementSameInterfaces(sourceCS.getClass(), targetCS.getClass(), CoordinateSystem.class)) {
            throw new IllegalArgumentException(Resources.format((short)27));
        }
        Object[] srcAxes = CoordinateSystems.getAxisDirections(sourceCS);
        Object[] dstAxes = CoordinateSystems.getAxisDirections(targetCS);
        MatrixSIS matrix = Matrices.createTransform((AxisDirection[])srcAxes, (AxisDirection[])dstAxes);
        assert (Arrays.equals(srcAxes, dstAxes) == matrix.isIdentity()) : matrix;
        int sourceDim = matrix.getNumCol() - 1;
        int targetDim = matrix.getNumRow() - 1;
        for (int j = 0; j < targetDim; ++j) {
            Unit targetUnit = targetCS.getAxis(j).getUnit();
            for (int i = 0; i < sourceDim; ++i) {
                Unit sourceUnit;
                if (matrix.getElement(j, i) == 0.0 || Objects.equals(sourceUnit = sourceCS.getAxis(i).getUnit(), targetUnit)) continue;
                Number scale = 1;
                Number offset = 0;
                Number[] coefficients = Units.coefficients(sourceUnit.getConverterToAny(targetUnit));
                switch (coefficients != null ? coefficients.length : -1) {
                    case 2: {
                        scale = coefficients[1];
                    }
                    case 1: {
                        offset = coefficients[0];
                    }
                    case 0: {
                        break;
                    }
                    default: {
                        throw new IncommensurableException(Resources.format((short)54, sourceUnit, targetUnit));
                    }
                }
                DoubleDouble element = DoubleDouble.castOrCopy(matrix.getNumber(j, i));
                DoubleDouble r = new DoubleDouble(element);
                r.multiplyGuessError(scale);
                matrix.setNumber(j, i, r);
                r.setFrom(element);
                r.multiplyGuessError(offset);
                r.addGuessError(matrix.getNumber(j, sourceDim));
                matrix.setNumber(j, sourceDim, r);
            }
        }
        return matrix;
    }

    public static CoordinateSystem replaceAxes(CoordinateSystem cs, AxisFilter filter) {
        ArgumentChecks.ensureNonNull("filter", filter);
        if (cs != null) {
            AbstractCS newCS;
            if (filter instanceof AxesConvention) {
                if (cs instanceof AbstractCS) {
                    return ((AbstractCS)cs).forConvention((AxesConvention)filter);
                }
                newCS = Normalizer.forConvention(cs, (AxesConvention)filter);
            } else {
                newCS = Normalizer.normalize(cs, filter, false);
            }
            if (newCS != null) {
                return newCS;
            }
        }
        return cs;
    }

    public static CoordinateSystem replaceLinearUnit(CoordinateSystem cs, final Unit<Length> newUnit) {
        ArgumentChecks.ensureNonNull("newUnit", newUnit);
        return CoordinateSystems.replaceAxes(cs, new AxisFilter(){

            @Override
            public Unit<?> getUnitReplacement(CoordinateSystemAxis axis, Unit<?> unit) {
                return Units.isLinear(unit) ? newUnit : unit;
            }
        });
    }

    public static CoordinateSystem replaceAngularUnit(CoordinateSystem cs, final Unit<javax.measure.quantity.Angle> newUnit) {
        ArgumentChecks.ensureNonNull("newUnit", newUnit);
        return CoordinateSystems.replaceAxes(cs, new AxisFilter(){

            @Override
            public Unit<?> getUnitReplacement(CoordinateSystemAxis axis, Unit<?> unit) {
                return Units.isAngular(unit) ? newUnit : unit;
            }
        });
    }

    public static AxisDirection[] getAxisDirections(CoordinateSystem cs) {
        ArgumentChecks.ensureNonNull("cs", cs);
        AxisDirection[] directions = new AxisDirection[cs.getDimension()];
        for (int i = 0; i < directions.length; ++i) {
            CoordinateSystemAxis axis = cs.getAxis(i);
            ArgumentChecks.ensureNonNullElement("cs", i, cs);
            directions[i] = axis.getDirection();
            ArgumentChecks.ensureNonNullElement("cs[#].direction", i, directions[i]);
        }
        return directions;
    }

    public static Integer getEpsgCode(Class<? extends CoordinateSystem> type, CoordinateSystemAxis ... axes) {
        ArgumentChecks.ensureNonNull("type", type);
        ArgumentChecks.ensureNonNull("axes", axes);
        block1 : switch (axes.length) {
            case 3: {
                if (!Units.METRE.equals((Object)axes[2].getUnit())) break;
            }
            case 2: {
                boolean isAngular;
                Unit unit = axes[0].getUnit();
                if (unit == null || !unit.equals(axes[1].getUnit()) || (!(isAngular = Units.isAngular(unit)) || !type.isAssignableFrom(EllipsoidalCS.class)) && (!Units.isLinear(unit) || !type.isAssignableFrom(CartesianCS.class))) break;
                AxisDirection[] directions = new AxisDirection[axes.length];
                for (int i = 0; i < directions.length; ++i) {
                    CoordinateSystemAxis axis = axes[i];
                    ArgumentChecks.ensureNonNullElement("axes", i, axis);
                    directions[i] = axis.getDirection();
                    if (!isAngular || !RangeMeaning.WRAPAROUND.equals((Object)axis.getRangeMeaning())) continue;
                    try {
                        UnitConverter uc = unit.getConverterToAny(Units.DEGREE);
                        double min = uc.convert(axis.getMinimumValue());
                        double max = uc.convert(axis.getMaximumValue());
                        if (min > Double.NEGATIVE_INFINITY && Math.abs(min - -180.0) > 8.999280057595393E-8) break block1;
                        if (!(max < Double.POSITIVE_INFINITY) || !(Math.abs(max - 180.0) > 8.999280057595393E-8)) continue;
                    }
                    catch (IncommensurableException e) {
                        Logging.unexpectedException(Logging.getLogger("org.apache.sis.referencing"), CoordinateSystems.class, "getEpsgCode", e);
                    }
                    break block1;
                }
                return CoordinateSystems.getEpsgCode(unit, directions);
            }
        }
        return null;
    }

    public static Integer getEpsgCode(Unit<?> unit, AxisDirection ... directions) {
        ArgumentChecks.ensureNonNull("unit", unit);
        ArgumentChecks.ensureNonNull("directions", directions);
        short code = Codes.lookup(unit, directions);
        return code != 0 ? Integer.valueOf(code) : null;
    }
}

