/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import java.util.Collections;
import java.util.Map;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.cs.AxisFilter;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.util.Utilities;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.Projection;
import org.opengis.util.FactoryException;

final class EllipsoidalHeightSeparator
implements AxisFilter {
    private final GeodeticDatum datum;
    private boolean vertical;

    EllipsoidalHeightSeparator(GeodeticDatum datum) {
        this.datum = datum;
    }

    @Override
    public boolean accept(CoordinateSystemAxis axis) {
        return AxisDirections.isVertical(axis.getDirection()) == this.vertical;
    }

    private static CRSFactory factory() {
        return DefaultFactories.forBuildin(CRSFactory.class);
    }

    private static Map<String, ?> properties(SingleCRS component) {
        return Collections.singletonMap("name", component.getName());
    }

    SingleCRS separate(SingleCRS crs, boolean vertical) throws FactoryException {
        this.vertical = vertical;
        CoordinateSystem cs = CoordinateSystems.replaceAxes(crs.getCoordinateSystem(), this);
        if (vertical) {
            VerticalCRS component = CommonCRS.Vertical.ELLIPSOIDAL.crs();
            if (!Utilities.equalsIgnoreMetadata(component.getCoordinateSystem(), cs)) {
                component = EllipsoidalHeightSeparator.factory().createVerticalCRS(EllipsoidalHeightSeparator.properties((SingleCRS)component), component.getDatum(), (VerticalCS)cs);
            }
            return component;
        }
        if (crs instanceof GeographicCRS) {
            CommonCRS c;
            CommonCRS ref = CommonCRS.WGS84;
            if (Utilities.equalsIgnoreMetadata(ref.geographic().getCoordinateSystem(), cs)) {
                CommonCRS c2 = CommonCRS.forDatum(this.datum);
                if (c2 != null) {
                    return c2.geographic();
                }
            } else if (Utilities.equalsIgnoreMetadata(ref.normalizedGeographic().getCoordinateSystem(), cs) && (c = CommonCRS.forDatum(this.datum)) != null) {
                return c.normalizedGeographic();
            }
            return EllipsoidalHeightSeparator.factory().createGeographicCRS(EllipsoidalHeightSeparator.properties(crs), this.datum, (EllipsoidalCS)cs);
        }
        if (crs instanceof ProjectedCRS) {
            GeographicCRS baseCRS = ((ProjectedCRS)crs).getBaseCRS();
            if (ReferencingUtilities.getDimension((CoordinateReferenceSystem)baseCRS) != 2) {
                baseCRS = (GeographicCRS)this.separate((SingleCRS)baseCRS, false);
            }
            Projection projection = ((ProjectedCRS)crs).getConversionFromBase();
            return EllipsoidalHeightSeparator.factory().createProjectedCRS(EllipsoidalHeightSeparator.properties(crs), baseCRS, (Conversion)projection, (CartesianCS)cs);
        }
        throw new IllegalArgumentException();
    }
}

