/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import javax.measure.Unit;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.measure.Range;
import org.apache.sis.parameter.DefaultParameterDescriptor;
import org.apache.sis.parameter.DefaultParameterDescriptorGroup;
import org.apache.sis.parameter.MapProjectionDescriptor;
import org.apache.sis.referencing.Builder;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.IdentifiedObject;

public class ParameterBuilder
extends Builder<ParameterBuilder> {
    private boolean required;

    public ParameterBuilder() {
    }

    public ParameterBuilder(GeneralParameterDescriptor descriptor) {
        super((IdentifiedObject)descriptor);
        if (descriptor != null) {
            this.required = descriptor.getMinimumOccurs() != 0;
        }
    }

    public ParameterBuilder setRequired(boolean required) {
        this.required = required;
        return this;
    }

    private static Double valueOf(double value) {
        return Double.isNaN(value) ? null : Double.valueOf(value);
    }

    public <T> ParameterDescriptor<T> create(Class<T> valueClass, T defaultValue) {
        return this.create(valueClass, null, null, defaultValue);
    }

    public ParameterDescriptor<Double> create(double defaultValue, Unit<?> unit) {
        MeasurementRange<Double> valueDomain = unit != null ? MeasurementRange.create(Double.NEGATIVE_INFINITY, false, Double.POSITIVE_INFINITY, false, unit) : null;
        return this.create(Double.class, valueDomain, null, ParameterBuilder.valueOf(defaultValue));
    }

    public ParameterDescriptor<Double> createStrictlyPositive(double defaultValue, Unit<?> unit) {
        NumberRange valueDomain = unit != null ? MeasurementRange.createGreaterThan(0.0, unit) : NumberRange.create(0.0, false, Double.POSITIVE_INFINITY, false);
        return this.create(Double.class, valueDomain, null, ParameterBuilder.valueOf(defaultValue));
    }

    public ParameterDescriptor<Double> createBounded(double minimumValue, double maximumValue, double defaultValue, Unit<?> unit) {
        NumberRange valueDomain = unit != null ? MeasurementRange.create(minimumValue, true, maximumValue, true, unit) : (minimumValue != Double.NEGATIVE_INFINITY || maximumValue != Double.POSITIVE_INFINITY ? NumberRange.create(minimumValue, true, maximumValue, true) : null);
        return this.create(Double.class, valueDomain, null, ParameterBuilder.valueOf(defaultValue));
    }

    public ParameterDescriptor<Integer> createBounded(int minimumValue, int maximumValue, int defaultValue) {
        return this.create(Integer.class, NumberRange.create(minimumValue, true, maximumValue, true), null, defaultValue);
    }

    public <T extends Comparable<? super T>> ParameterDescriptor<T> createBounded(Class<T> valueClass, T minimumValue, T maximumValue, T defaultValue) {
        ArgumentChecks.ensureNonNull("valueClass", valueClass);
        Range valueDomain = minimumValue == null && maximumValue == null ? null : (Number.class.isAssignableFrom(valueClass) ? new NumberRange<Number>(valueClass, (Number)((Object)minimumValue), true, (Number)((Object)maximumValue), true) : new Range(valueClass, minimumValue, true, maximumValue, true));
        return this.create(valueClass, valueDomain, null, defaultValue);
    }

    public <T extends Comparable<? super T>> ParameterDescriptor<T> createBounded(Range<T> valueDomain, T defaultValue) {
        ArgumentChecks.ensureNonNull("valueDomain", valueDomain);
        return this.create(valueDomain.getElementType(), valueDomain, null, defaultValue);
    }

    public <T> ParameterDescriptor<T> createEnumerated(Class<T> valueClass, T[] validValues, T defaultValue) {
        ArgumentChecks.ensureNonNull("valueClass", valueClass);
        return this.create(valueClass, null, validValues, defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> ParameterDescriptor<T> create(Class<T> valueClass, Range<?> valueDomain, T[] validValues, T defaultValue) {
        DefaultParameterDescriptor<T> descriptor;
        this.onCreate(false);
        try {
            descriptor = new DefaultParameterDescriptor<T>(this.properties, this.required ? 1 : 0, 1, valueClass, valueDomain, validValues, defaultValue);
        }
        finally {
            this.onCreate(true);
        }
        return descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParameterDescriptorGroup createGroup(int minimumOccurs, int maximumOccurs, GeneralParameterDescriptor ... parameters) {
        DefaultParameterDescriptorGroup group;
        this.onCreate(false);
        try {
            group = new DefaultParameterDescriptorGroup(this.properties, minimumOccurs, maximumOccurs, parameters);
        }
        finally {
            this.onCreate(true);
        }
        return group;
    }

    public ParameterDescriptorGroup createGroup(GeneralParameterDescriptor ... parameters) {
        return this.createGroup(this.required ? 1 : 0, 1, parameters);
    }

    public ParameterDescriptorGroup createGroupWithSameParameters(ParameterDescriptorGroup parameters) {
        DefaultParameterDescriptorGroup group;
        this.onCreate(false);
        try {
            group = new DefaultParameterDescriptorGroup(this.properties, parameters);
        }
        finally {
            this.onCreate(true);
        }
        return group;
    }

    public ParameterDescriptorGroup createGroupForMapProjection(ParameterDescriptor<?> ... parameters) {
        MapProjectionDescriptor group;
        this.onCreate(false);
        try {
            group = new MapProjectionDescriptor(this.properties, parameters);
        }
        finally {
            this.onCreate(true);
        }
        return group;
    }
}

