/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.sql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.metadata.sql.MetadataSource;
import org.apache.sis.metadata.sql.MetadataStoreException;
import org.apache.sis.util.logging.WarningListeners;
import org.apache.sis.util.resources.Errors;

final class CachedStatement
implements AutoCloseable {
    final Class<?> type;
    private String identifier;
    private final PreparedStatement statement;
    private ResultSet results;
    long expireTime;
    private final WarningListeners<MetadataSource> listeners;

    CachedStatement(Class<?> type, PreparedStatement statement, WarningListeners<MetadataSource> listeners) {
        this.type = type;
        this.statement = statement;
        this.listeners = listeners;
    }

    final Object getValue(String id, String attribute) throws SQLException, MetadataStoreException {
        ResultSet r;
        if (!id.equals(this.identifier)) {
            this.closeResultSet();
        }
        if ((r = this.results) == null) {
            this.statement.setString(1, id);
            r = this.statement.executeQuery();
            if (!r.next()) {
                String table = r.getMetaData().getTableName(1);
                r.close();
                throw new MetadataStoreException(Errors.format((short)122, table, id));
            }
            this.results = r;
            this.identifier = id;
        }
        int column = r.findColumn(attribute);
        switch (r.getMetaData().getColumnType(column)) {
            case 1111: {
                return r.getString(column);
            }
        }
        return r.getObject(column);
    }

    private void closeResultSet() throws SQLException {
        ResultSet r = this.results;
        this.results = null;
        if (r != null) {
            boolean hasNext = r.next();
            r.close();
            if (hasNext) {
                this.warning(this.type, "<init>", Errors.getResources((Locale)null).getLogRecord(Level.WARNING, (short)25, this.identifier));
            }
            this.identifier = null;
        }
    }

    @Override
    public void close() throws SQLException {
        this.closeResultSet();
        this.statement.close();
    }

    private void warning(Class<?> source, String method, LogRecord record) {
        record.setSourceClassName(source.getCanonicalName());
        record.setSourceMethodName(method);
        record.setLoggerName("org.apache.sis.sql");
        this.listeners.warning(record);
    }
}

