/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.spatial;

import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.measure.ValueRange;
import org.apache.sis.metadata.iso.spatial.AbstractSpatialRepresentation;
import org.apache.sis.metadata.iso.spatial.DefaultGeorectified;
import org.apache.sis.metadata.iso.spatial.DefaultGeoreferenceable;
import org.opengis.metadata.spatial.CellGeometry;
import org.opengis.metadata.spatial.Dimension;
import org.opengis.metadata.spatial.Georectified;
import org.opengis.metadata.spatial.Georeferenceable;
import org.opengis.metadata.spatial.GridSpatialRepresentation;
import org.opengis.metadata.spatial.SpatialRepresentation;

@XmlType(name="MD_GridSpatialRepresentation_Type", propOrder={"numberOfDimensions", "axisDimensionProperties", "cellGeometry", "transformationParameterAvailable"})
@XmlSeeAlso(value={DefaultGeorectified.class, DefaultGeoreferenceable.class})
@XmlRootElement(name="MD_GridSpatialRepresentation")
public class DefaultGridSpatialRepresentation
extends AbstractSpatialRepresentation
implements GridSpatialRepresentation {
    private static final long serialVersionUID = -1111392086980738831L;
    static final byte TRANSFORMATION_MASK = 1;
    private Integer numberOfDimensions;
    private List<Dimension> axisDimensionProperties;
    private CellGeometry cellGeometry;
    byte booleans;

    public DefaultGridSpatialRepresentation() {
    }

    public DefaultGridSpatialRepresentation(GridSpatialRepresentation object) {
        super((SpatialRepresentation)object);
        if (object != null) {
            this.numberOfDimensions = object.getNumberOfDimensions();
            this.axisDimensionProperties = this.copyList(object.getAxisDimensionProperties(), Dimension.class);
            this.cellGeometry = object.getCellGeometry();
            if (object.isTransformationParameterAvailable()) {
                this.booleans = 1;
            }
        }
    }

    public static DefaultGridSpatialRepresentation castOrCopy(GridSpatialRepresentation object) {
        if (object instanceof Georectified) {
            return DefaultGeorectified.castOrCopy((Georectified)object);
        }
        if (object instanceof Georeferenceable) {
            return DefaultGeoreferenceable.castOrCopy((Georeferenceable)object);
        }
        if (object == null || object instanceof DefaultGridSpatialRepresentation) {
            return (DefaultGridSpatialRepresentation)object;
        }
        return new DefaultGridSpatialRepresentation(object);
    }

    @ValueRange(minimum=0.0)
    @XmlElement(name="numberOfDimensions", required=true)
    public Integer getNumberOfDimensions() {
        return this.numberOfDimensions;
    }

    public void setNumberOfDimensions(Integer newValue) {
        this.checkWritePermission(this.numberOfDimensions);
        if (MetadataUtilities.ensurePositive(DefaultGridSpatialRepresentation.class, "numberOfDimensions", false, newValue)) {
            this.numberOfDimensions = newValue;
        }
    }

    @XmlElement(name="axisDimensionProperties")
    public List<Dimension> getAxisDimensionProperties() {
        this.axisDimensionProperties = this.nonNullList(this.axisDimensionProperties, Dimension.class);
        return this.axisDimensionProperties;
    }

    public void setAxisDimensionProperties(List<? extends Dimension> newValues) {
        this.axisDimensionProperties = this.writeList(newValues, this.axisDimensionProperties, Dimension.class);
    }

    @XmlElement(name="cellGeometry", required=true)
    public CellGeometry getCellGeometry() {
        return this.cellGeometry;
    }

    public void setCellGeometry(CellGeometry newValue) {
        this.checkWritePermission(this.cellGeometry);
        this.cellGeometry = newValue;
    }

    final Boolean isDefined(byte mask) {
        return (this.booleans & mask) != 0 ? Boolean.TRUE : null;
    }

    @XmlElement(name="transformationParameterAvailability", required=true)
    public boolean isTransformationParameterAvailable() {
        return (this.booleans & 1) != 0;
    }

    public void setTransformationParameterAvailable(boolean newValue) {
        this.checkWritePermission(this.isDefined((byte)1));
        this.booleans = newValue ? (byte)(this.booleans | 1) : (byte)(this.booleans & 0xFFFFFFFE);
    }
}

