/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.identification;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.gco.GO_Distance;
import org.apache.sis.internal.jaxb.gco.GO_Real;
import org.apache.sis.internal.jaxb.gco.InternationalStringAdapter;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.measure.ValueRange;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.util.resources.Messages;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.identification.RepresentativeFraction;
import org.opengis.metadata.identification.Resolution;
import org.opengis.util.InternationalString;

@XmlType(name="MD_Resolution_Type")
@XmlRootElement(name="MD_Resolution")
public class DefaultResolution
extends ISOMetadata
implements Resolution {
    private static final long serialVersionUID = 4333582736458380544L;
    private static final byte SCALE = 1;
    private static final byte DISTANCE = 2;
    private static final byte VERTICAL = 3;
    private static final byte ANGULAR = 4;
    private static final byte TEXT = 5;
    private static final String[] NAMES = new String[]{"equivalentScale", "distance", "vertical", "angularDistance", "levelOfDetail"};
    private static final String[] SETTERS = new String[]{"setEquivalentScale", "setDistance", "setVertical", "setAngularDistance", "setLevelOfDetail"};
    private byte property;
    private Object value;

    public DefaultResolution() {
    }

    public DefaultResolution(RepresentativeFraction scale) {
        if (scale != null) {
            this.value = scale;
            this.property = 1;
        }
    }

    public DefaultResolution(Resolution object) {
        super(object);
        if (object != null) {
            for (int p = 1; p <= 5; p = (int)((byte)(p + 1))) {
                Object c = null;
                switch (p) {
                    case 1: {
                        c = object.getEquivalentScale();
                        break;
                    }
                    case 2: {
                        c = object.getDistance();
                        break;
                    }
                    case 3: {
                        if (!(c instanceof DefaultResolution)) break;
                        c = ((DefaultResolution)object).getVertical();
                        break;
                    }
                    case 4: {
                        if (!(c instanceof DefaultResolution)) break;
                        c = ((DefaultResolution)object).getAngularDistance();
                        break;
                    }
                    case 5: {
                        if (!(c instanceof DefaultResolution)) break;
                        c = ((DefaultResolution)object).getLevelOfDetail();
                        break;
                    }
                    default: {
                        throw new AssertionError(p);
                    }
                }
                if (c == null) continue;
                this.property = (byte)p;
                this.value = c;
                break;
            }
        }
    }

    public static DefaultResolution castOrCopy(Resolution object) {
        if (object == null || object instanceof DefaultResolution) {
            return (DefaultResolution)object;
        }
        return new DefaultResolution(object);
    }

    private void setProperty(byte code, Object newValue) {
        this.checkWritePermission(this.value);
        if (this.value != null && this.property != code) {
            if (newValue == null) {
                return;
            }
            Context.warningOccured(Context.current(), DefaultResolution.class, SETTERS[code - 1], Messages.class, (short)19, NAMES[this.property - 1], NAMES[code - 1]);
        }
        this.value = newValue;
        this.property = code;
    }

    @XmlElement(name="equivalentScale")
    public RepresentativeFraction getEquivalentScale() {
        return this.property == 1 ? (RepresentativeFraction)this.value : null;
    }

    public void setEquivalentScale(RepresentativeFraction newValue) {
        this.setProperty((byte)1, newValue);
    }

    @XmlElement(name="distance")
    @XmlJavaTypeAdapter(value=GO_Distance.class)
    @ValueRange(minimum=0.0, isMinIncluded=false)
    public Double getDistance() {
        return this.property == 2 ? (Double)this.value : null;
    }

    public void setDistance(Double newValue) {
        if (MetadataUtilities.ensurePositive(DefaultResolution.class, "distance", true, newValue)) {
            this.setProperty((byte)2, newValue);
        }
    }

    @XmlElement(name="vertical")
    @XmlJavaTypeAdapter(value=GO_Real.Since2014.class)
    @UML(identifier="vertical", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    @ValueRange(minimum=0.0, isMinIncluded=false)
    public Double getVertical() {
        return this.property == 3 ? (Double)this.value : null;
    }

    public void setVertical(Double newValue) {
        if (MetadataUtilities.ensurePositive(DefaultResolution.class, "vertical", true, newValue)) {
            this.setProperty((byte)3, newValue);
        }
    }

    @XmlElement(name="angularDistance")
    @XmlJavaTypeAdapter(value=GO_Real.Since2014.class)
    @UML(identifier="angularDistance", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    @ValueRange(minimum=0.0, isMinIncluded=false)
    public Double getAngularDistance() {
        return this.property == 4 ? (Double)this.value : null;
    }

    public void setAngularDistance(Double newValue) {
        if (MetadataUtilities.ensurePositive(DefaultResolution.class, "angular", true, newValue)) {
            this.setProperty((byte)4, newValue);
        }
    }

    @XmlElement(name="levelOfDetail")
    @XmlJavaTypeAdapter(value=InternationalStringAdapter.Since2014.class)
    @UML(identifier="levelOfDetail", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public InternationalString getLevelOfDetail() {
        return this.property == 5 ? (InternationalString)this.value : null;
    }

    public void setLevelOfDetail(InternationalString newValue) {
        this.setProperty((byte)5, newValue);
    }
}

