/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.identification;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.internal.jaxb.gco.GO_GenericName;
import org.apache.sis.internal.jaxb.metadata.SV_OperationMetadata;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.identification.DefaultOperationMetadata;
import org.apache.sis.metadata.iso.identification.OperationName;
import org.apache.sis.util.iso.Names;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.identification.DataIdentification;
import org.opengis.util.ScopedName;

@XmlType(name="SV_CoupledResource_Type", namespace="http://standards.iso.org/iso/19115/-3/srv/2.0", propOrder={"scopedName", "resourceReference", "resource", "operation", "operationName", "id", "legacyName"})
@XmlRootElement(name="SV_CoupledResource", namespace="http://standards.iso.org/iso/19115/-3/srv/2.0")
@UML(identifier="SV_CoupledResource", specification=Specification.ISO_19115)
public class DefaultCoupledResource
extends ISOMetadata {
    private static final long serialVersionUID = 154704781596732747L;
    private ScopedName scopedName;
    private Collection<Citation> resourceReferences;
    private Collection<DataIdentification> resources;
    private DefaultOperationMetadata operation;

    public DefaultCoupledResource() {
    }

    public DefaultCoupledResource(ScopedName name, Citation reference, DataIdentification resource, DefaultOperationMetadata operation) {
        this.scopedName = name;
        this.resourceReferences = this.singleton(reference, Citation.class);
        this.resources = this.singleton(resource, DataIdentification.class);
        this.operation = operation;
    }

    public DefaultCoupledResource(DefaultCoupledResource object) {
        super(object);
        if (object != null) {
            this.scopedName = object.getScopedName();
            this.resourceReferences = this.copyCollection(object.getResourceReferences(), Citation.class);
            this.resources = this.copyCollection(object.getResources(), DataIdentification.class);
            this.operation = object.getOperation();
        }
    }

    @XmlElement(name="scopedName")
    @XmlJavaTypeAdapter(value=GO_GenericName.Since2014.class)
    @UML(identifier="scopedName", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public ScopedName getScopedName() {
        return this.scopedName;
    }

    public void setScopedName(ScopedName newValue) {
        this.checkWritePermission(this.scopedName);
        this.scopedName = newValue;
    }

    @UML(identifier="resourceReference", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Citation> getResourceReferences() {
        this.resourceReferences = this.nonNullCollection(this.resourceReferences, Citation.class);
        return this.resourceReferences;
    }

    public void setResourceReferences(Collection<? extends Citation> newValues) {
        this.resourceReferences = this.writeCollection(newValues, this.resourceReferences, Citation.class);
    }

    @UML(identifier="resource", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<DataIdentification> getResources() {
        this.resources = this.nonNullCollection(this.resources, DataIdentification.class);
        return this.resources;
    }

    public void setResources(Collection<? extends DataIdentification> newValues) {
        this.resources = this.writeCollection(newValues, this.resources, DataIdentification.class);
    }

    @XmlElement(name="operation")
    @XmlJavaTypeAdapter(value=SV_OperationMetadata.Since2014.class)
    @UML(identifier="operation", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public DefaultOperationMetadata getOperation() {
        return this.operation;
    }

    public void setOperation(DefaultOperationMetadata newValue) {
        this.checkWritePermission(this.operation);
        this.operation = newValue;
    }

    @XmlElement(name="operationName", namespace="http://www.isotc211.org/2005/srv")
    private String getOperationName() {
        DefaultOperationMetadata operation;
        if (FilterByVersion.LEGACY_METADATA.accept() && (operation = this.getOperation()) != null) {
            return operation.getOperationName();
        }
        return null;
    }

    private void setOperationName(String name) {
        if (this.operation == null) {
            this.operation = new OperationName(name);
        }
    }

    @XmlElement(name="identifier", namespace="http://www.isotc211.org/2005/srv")
    private String getId() {
        ScopedName name;
        if (FilterByVersion.LEGACY_METADATA.accept() && (name = this.getScopedName()) != null) {
            return name.tip().toString();
        }
        return null;
    }

    @XmlElement(name="ScopedName", namespace="http://standards.iso.org/iso/19115/-3/gco/1.0")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    private String getLegacyName() {
        ScopedName name;
        if (FilterByVersion.LEGACY_METADATA.accept() && (name = this.getScopedName()) != null) {
            return name.toString();
        }
        return null;
    }

    private void setLegacyName(String value) {
        if (value != null && !value.isEmpty()) {
            if (value.indexOf(58) < 0) {
                value = "global:" + value;
            }
            this.setScopedName((ScopedName)Names.parseGenericName(null, null, value));
        }
    }

    @XmlElement(name="resourceReference")
    private Collection<Citation> getResourceReference() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getResourceReferences() : null;
    }

    @XmlElement(name="resource")
    private Collection<DataIdentification> getResource() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getResources() : null;
    }
}

