/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.extent;

import java.util.ArrayList;
import java.util.Date;
import javax.measure.Unit;
import org.apache.sis.internal.metadata.ReferencingServices;
import org.apache.sis.measure.Longitude;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.Range;
import org.apache.sis.metadata.InvalidMetadataException;
import org.apache.sis.metadata.ModifiableMetadata;
import org.apache.sis.metadata.iso.extent.DefaultExtent;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.metadata.iso.extent.DefaultTemporalExtent;
import org.apache.sis.metadata.iso.extent.DefaultVerticalExtent;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Static;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.metadata.extent.TemporalExtent;
import org.opengis.metadata.extent.VerticalExtent;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.referencing.operation.TransformException;
import org.opengis.temporal.TemporalPrimitive;

public final class Extents
extends Static {
    public static final Extent WORLD;

    private Extents() {
    }

    public static GeographicBoundingBox getGeographicBoundingBox(Extent extent) {
        GeographicBoundingBox bounds = null;
        if (extent != null) {
            GeographicBoundingBox item;
            DefaultGeographicBoundingBox modifiable = null;
            ArrayList fallbacks = new ArrayList();
            for (GeographicExtent element : extent.getGeographicElements()) {
                if (!(element instanceof GeographicBoundingBox)) continue;
                item = (GeographicBoundingBox)element;
                if (bounds == null) {
                    if (!DefaultGeographicBoundingBox.getInclusion(item.getInclusion())) continue;
                    bounds = item;
                    continue;
                }
                if (modifiable == null) {
                    modifiable = new DefaultGeographicBoundingBox(bounds);
                    bounds = modifiable;
                }
                modifiable.add(item);
            }
            if (bounds == null) {
                try {
                    for (Envelope envelope : fallbacks) {
                        item = new DefaultGeographicBoundingBox();
                        item.setBounds(envelope);
                        if (bounds == null) {
                            bounds = item;
                            continue;
                        }
                        if (modifiable == null) {
                            modifiable = new DefaultGeographicBoundingBox(bounds);
                            bounds = modifiable;
                        }
                        modifiable.add(item);
                    }
                }
                catch (TransformException e) {
                    throw new InvalidMetadataException(Errors.format((short)16), e);
                }
            }
        }
        return bounds;
    }

    public static MeasurementRange<Double> getVerticalRange(Extent extent) {
        MeasurementRange range = null;
        VerticalDatumType selectedType = null;
        if (extent != null) {
            for (VerticalExtent element : extent.getVerticalElements()) {
                double min = element.getMinimumValue();
                double max = element.getMaximumValue();
                VerticalCRS crs = element.getVerticalCRS();
                VerticalDatumType type = null;
                Unit unit = null;
                if (crs != null) {
                    VerticalDatum datum = crs.getDatum();
                    if (datum != null && VerticalDatumType.DEPTH.equals((Object)(type = datum.getVerticalDatumType()))) {
                        type = VerticalDatumType.GEOIDAL;
                    }
                    CoordinateSystemAxis axis = crs.getCoordinateSystem().getAxis(0);
                    unit = axis.getUnit();
                    if (AxisDirection.DOWN.equals((Object)axis.getDirection())) {
                        double tmp = min;
                        min = -max;
                        max = -tmp;
                    }
                }
                if (range != null) {
                    Unit<?> previous;
                    if (type == null || unit == null) continue;
                    if (!type.equals(selectedType)) {
                        if (!type.equals((Object)VerticalDatumType.GEOIDAL)) {
                            continue;
                        }
                    } else if (selectedType != null && (previous = range.unit()) != null) {
                        if (!previous.isCompatible(unit)) continue;
                        range = (MeasurementRange)range.union(MeasurementRange.create(min, true, max, true, unit));
                        continue;
                    }
                }
                range = MeasurementRange.create(min, true, max, true, unit);
                selectedType = type;
            }
        }
        return range;
    }

    public static Range<Date> getTimeRange(Extent extent) {
        Date min = null;
        Date max = null;
        if (extent != null) {
            for (TemporalExtent t : extent.getTemporalElements()) {
                Date endTime;
                Date startTime;
                if (t instanceof DefaultTemporalExtent) {
                    DefaultTemporalExtent dt = (DefaultTemporalExtent)t;
                    startTime = dt.getStartTime();
                    endTime = dt.getEndTime();
                } else {
                    TemporalPrimitive p = t.getExtent();
                    startTime = DefaultTemporalExtent.getTime(p, true);
                    endTime = DefaultTemporalExtent.getTime(p, false);
                }
                if (startTime != null && (min == null || startTime.before(min))) {
                    min = startTime;
                }
                if (endTime == null || max != null && !endTime.after(max)) continue;
                max = endTime;
            }
        }
        if (min == null && max == null) {
            return null;
        }
        return new Range<Object>((Class<Object>)Date.class, min, true, max, true);
    }

    public static Date getDate(Extent extent, double location) {
        ArgumentChecks.ensureFinite("location", location);
        Date min = null;
        Date max = null;
        if (extent != null) {
            for (TemporalExtent t : extent.getTemporalElements()) {
                Date startTime = null;
                Date endTime = null;
                if (t instanceof DefaultTemporalExtent) {
                    DefaultTemporalExtent dt = (DefaultTemporalExtent)t;
                    if (location != 1.0) {
                        startTime = dt.getStartTime();
                    }
                    if (location != 0.0) {
                        endTime = dt.getEndTime();
                    }
                } else {
                    TemporalPrimitive p = t.getExtent();
                    if (location != 1.0) {
                        startTime = DefaultTemporalExtent.getTime(p, true);
                    }
                    if (location != 0.0) {
                        endTime = DefaultTemporalExtent.getTime(p, false);
                    }
                }
                if (startTime != null && (min == null || startTime.before(min))) {
                    min = startTime;
                }
                if (endTime == null || max != null && !endTime.after(max)) continue;
                max = endTime;
            }
        }
        if (min == null) {
            return max;
        }
        if (max == null) {
            return min;
        }
        long startTime = min.getTime();
        return new Date(Math.addExact(startTime, Math.round((double)(max.getTime() - startTime) * location)));
    }

    public static DirectPosition centroid(GeographicBoundingBox bbox) {
        if (bbox != null) {
            double y = (bbox.getNorthBoundLatitude() + bbox.getSouthBoundLatitude()) / 2.0;
            double x = bbox.getWestBoundLongitude();
            double xmax = bbox.getEastBoundLongitude();
            if (xmax < x) {
                xmax += 360.0;
            }
            if (Double.isFinite(x = Longitude.normalize((x + xmax) / 2.0)) || Double.isFinite(y)) {
                return ReferencingServices.getInstance().geographic(x, y);
            }
        }
        return null;
    }

    public static double area(GeographicBoundingBox box) {
        if (box == null) {
            return Double.NaN;
        }
        double \u0394\u03bb = box.getEastBoundLongitude() - box.getWestBoundLongitude();
        double span = 360.0;
        if (\u0394\u03bb > 360.0) {
            \u0394\u03bb = 360.0;
        } else if (\u0394\u03bb < 0.0) {
            \u0394\u03bb = \u0394\u03bb < -360.0 ? -360.0 : (\u0394\u03bb += 360.0);
        }
        return 4.0589730194049E13 * Math.toRadians(\u0394\u03bb) * Math.max(0.0, Math.sin(Math.toRadians(box.getNorthBoundLatitude())) - Math.sin(Math.toRadians(box.getSouthBoundLatitude())));
    }

    public static GeographicBoundingBox intersection(GeographicBoundingBox b1, GeographicBoundingBox b2) {
        if (b1 == null) {
            return b2;
        }
        if (b2 == null || b2 == b1) {
            return b1;
        }
        DefaultGeographicBoundingBox box = new DefaultGeographicBoundingBox(b1);
        box.intersect(b2);
        if (box.equals(b1, ComparisonMode.BY_CONTRACT)) {
            return b1;
        }
        if (box.equals(b2, ComparisonMode.BY_CONTRACT)) {
            return b2;
        }
        return box;
    }

    static GeographicExtent intersection(GeographicExtent e1, GeographicExtent e2) {
        return Extents.intersection(e1 instanceof GeographicBoundingBox ? (GeographicBoundingBox)e1 : null, e2 instanceof GeographicBoundingBox ? (GeographicBoundingBox)e2 : null);
    }

    public static VerticalExtent intersection(VerticalExtent e1, VerticalExtent e2) {
        if (e1 == null) {
            return e2;
        }
        if (e2 == null || e2 == e1) {
            return e1;
        }
        DefaultVerticalExtent extent = new DefaultVerticalExtent(e1);
        extent.intersect(e2);
        if (extent.equals(e1, ComparisonMode.BY_CONTRACT)) {
            return e1;
        }
        if (extent.equals(e2, ComparisonMode.BY_CONTRACT)) {
            return e2;
        }
        return extent;
    }

    public static TemporalExtent intersection(TemporalExtent e1, TemporalExtent e2) {
        if (e1 == null) {
            return e2;
        }
        if (e2 == null || e2 == e1) {
            return e1;
        }
        DefaultTemporalExtent extent = new DefaultTemporalExtent(e1);
        extent.intersect(e2);
        if (extent.equals(e1, ComparisonMode.BY_CONTRACT)) {
            return e1;
        }
        if (extent.equals(e2, ComparisonMode.BY_CONTRACT)) {
            return e2;
        }
        return extent;
    }

    public static Extent intersection(Extent e1, Extent e2) {
        if (e1 == null) {
            return e2;
        }
        if (e2 == null || e2 == e1) {
            return e1;
        }
        DefaultExtent extent = new DefaultExtent(e1);
        extent.intersect(e2);
        if (extent.equals(e1, ComparisonMode.BY_CONTRACT)) {
            return e1;
        }
        if (extent.equals(e2, ComparisonMode.BY_CONTRACT)) {
            return e2;
        }
        return extent;
    }

    static {
        DefaultGeographicBoundingBox box = new DefaultGeographicBoundingBox(-180.0, 180.0, -90.0, 90.0);
        box.transitionTo(ModifiableMetadata.State.FINAL);
        DefaultExtent world = new DefaultExtent((CharSequence)Vocabulary.formatInternational((short)118), box, null, null);
        world.transitionTo(ModifiableMetadata.State.FINAL);
        WORLD = world;
    }
}

