/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.distribution;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.internal.jaxb.gco.InternationalStringAdapter;
import org.apache.sis.metadata.TitleProperty;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.distribution.DigitalTransferOptions;
import org.opengis.metadata.distribution.Distribution;
import org.opengis.metadata.distribution.Distributor;
import org.opengis.metadata.distribution.Format;
import org.opengis.util.InternationalString;

@TitleProperty(name="description")
@XmlType(name="MD_Distribution_Type", propOrder={"description", "distributionFormats", "distributors", "transferOptions"})
@XmlRootElement(name="MD_Distribution")
public class DefaultDistribution
extends ISOMetadata
implements Distribution {
    private static final long serialVersionUID = 1331353255189686369L;
    private InternationalString description;
    private Collection<Format> distributionFormats;
    private Collection<Distributor> distributors;
    private Collection<DigitalTransferOptions> transferOptions;

    public DefaultDistribution() {
    }

    public DefaultDistribution(Distribution object) {
        super(object);
        if (object != null) {
            this.distributionFormats = this.copyCollection(object.getDistributionFormats(), Format.class);
            this.distributors = this.copyCollection(object.getDistributors(), Distributor.class);
            this.transferOptions = this.copyCollection(object.getTransferOptions(), DigitalTransferOptions.class);
            if (object instanceof DefaultDistribution) {
                this.description = ((DefaultDistribution)object).getDescription();
            }
        }
    }

    public static DefaultDistribution castOrCopy(Distribution object) {
        if (object == null || object instanceof DefaultDistribution) {
            return (DefaultDistribution)object;
        }
        return new DefaultDistribution(object);
    }

    @XmlElement(name="description")
    @XmlJavaTypeAdapter(value=InternationalStringAdapter.Since2014.class)
    @UML(identifier="description", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public InternationalString getDescription() {
        return this.description;
    }

    public void setDescription(InternationalString newValue) {
        this.checkWritePermission(this.description);
        this.description = newValue;
    }

    @XmlElement(name="distributionFormat")
    public Collection<Format> getDistributionFormats() {
        this.distributionFormats = this.nonNullCollection(this.distributionFormats, Format.class);
        return this.distributionFormats;
    }

    public void setDistributionFormats(Collection<? extends Format> newValues) {
        this.distributionFormats = this.writeCollection(newValues, this.distributionFormats, Format.class);
    }

    @XmlElement(name="distributor")
    public Collection<Distributor> getDistributors() {
        this.distributors = this.nonNullCollection(this.distributors, Distributor.class);
        return this.distributors;
    }

    public void setDistributors(Collection<? extends Distributor> newValues) {
        this.distributors = this.writeCollection(newValues, this.distributors, Distributor.class);
    }

    @XmlElement(name="transferOptions")
    public Collection<DigitalTransferOptions> getTransferOptions() {
        this.transferOptions = this.nonNullCollection(this.transferOptions, DigitalTransferOptions.class);
        return this.transferOptions;
    }

    public void setTransferOptions(Collection<? extends DigitalTransferOptions> newValues) {
        this.transferOptions = this.writeCollection(newValues, this.transferOptions, DigitalTransferOptions.class);
    }
}

