/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.citation;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.Dependencies;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.internal.metadata.legacy.LegacyPropertyAdapter;
import org.apache.sis.metadata.iso.citation.AbstractParty;
import org.apache.sis.metadata.iso.citation.DefaultIndividual;
import org.apache.sis.metadata.iso.citation.DefaultOrganisation;
import org.apache.sis.metadata.iso.citation.DefaultResponsibility;
import org.apache.sis.util.iso.Types;
import org.opengis.metadata.citation.Contact;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.citation.Role;
import org.opengis.util.InternationalString;

@XmlType(name="CI_ResponsibleParty_Type", namespace="http://www.isotc211.org/2005/gmd", propOrder={"individualName", "organisationName", "positionName", "contactInfo", "role"})
@XmlRootElement(name="CI_ResponsibleParty", namespace="http://www.isotc211.org/2005/gmd")
public class DefaultResponsibleParty
extends DefaultResponsibility
implements ResponsibleParty {
    private static final long serialVersionUID = -1022635486627088812L;

    public DefaultResponsibleParty() {
    }

    public DefaultResponsibleParty(Role role) {
        super(role, null, null);
    }

    public DefaultResponsibleParty(DefaultResponsibility object) {
        super(object);
    }

    public DefaultResponsibleParty(ResponsibleParty object) {
        super(object);
        if (object != null && !(object instanceof DefaultResponsibility)) {
            this.setIndividualName(object.getIndividualName());
            this.setOrganisationName(object.getOrganisationName());
        }
    }

    public static DefaultResponsibleParty castOrCopy(ResponsibleParty object) {
        if (object == null || object instanceof DefaultResponsibleParty) {
            return (DefaultResponsibleParty)object;
        }
        return new DefaultResponsibleParty(object);
    }

    private InternationalString getIndividual(boolean position) {
        InternationalString name;
        block1: {
            Collection<AbstractParty> parties = this.getParties();
            name = DefaultResponsibleParty.getName(parties, DefaultIndividual.class, position);
            if (name != null || parties == null) break block1;
            for (AbstractParty party : parties) {
                if (party instanceof DefaultOrganisation && (name = DefaultResponsibleParty.getName(((DefaultOrganisation)party).getIndividual(), DefaultIndividual.class, position)) != null) break;
            }
        }
        return name;
    }

    private static InternationalString getName(Collection<? extends AbstractParty> parties, Class<? extends AbstractParty> type, boolean position) {
        InternationalString name = null;
        if (parties != null) {
            for (AbstractParty abstractParty : parties) {
                if (!type.isInstance(abstractParty)) continue;
                if (name != null) {
                    LegacyPropertyAdapter.warnIgnoredExtraneous(type, DefaultResponsibleParty.class, position ? "getPositionName" : (type == DefaultIndividual.class ? "getIndividualName" : "getOrganisationName"));
                    break;
                }
                name = position ? ((DefaultIndividual)abstractParty).getPositionName() : abstractParty.getName();
            }
        }
        return name;
    }

    private boolean setName(Class<? extends AbstractParty> type, boolean position, InternationalString name) {
        this.checkWritePermission(MetadataUtilities.valueIfDefined(super.getParties()));
        Iterator<AbstractParty> it = this.getParties().iterator();
        while (it.hasNext()) {
            AbstractParty party = it.next();
            if (!type.isInstance(party)) continue;
            if (position) {
                ((DefaultIndividual)party).setPositionName(name);
            } else {
                party.setName(name);
            }
            if (party.isEmpty()) {
                it.remove();
            }
            return true;
        }
        return name == null;
    }

    @Deprecated
    @Dependencies(value={"getParties"})
    @XmlElement(name="individualName")
    public String getIndividualName() {
        InternationalString name = this.getIndividual(false);
        return name != null ? name.toString() : null;
    }

    @Deprecated
    public void setIndividualName(String newValue) {
        if (!this.setName(DefaultIndividual.class, false, Types.toInternationalString(newValue))) {
            this.getParties().add(new DefaultIndividual(newValue, null, null));
        }
    }

    @Deprecated
    @XmlElement(name="organisationName")
    @Dependencies(value={"getParties"})
    public InternationalString getOrganisationName() {
        return DefaultResponsibleParty.getName(this.getParties(), DefaultOrganisation.class, false);
    }

    @Deprecated
    public void setOrganisationName(InternationalString newValue) {
        if (!this.setName(DefaultOrganisation.class, false, Types.toInternationalString((CharSequence)newValue))) {
            this.getParties().add(new DefaultOrganisation((CharSequence)newValue, null, null, null));
        }
    }

    @Deprecated
    @XmlElement(name="positionName")
    @Dependencies(value={"getParties"})
    public InternationalString getPositionName() {
        return this.getIndividual(true);
    }

    @Deprecated
    public void setPositionName(InternationalString newValue) {
        if (!this.setName(DefaultIndividual.class, true, newValue)) {
            this.getParties().add(new DefaultIndividual(null, (CharSequence)newValue, null));
        }
    }

    @Deprecated
    @XmlElement(name="contactInfo")
    @Dependencies(value={"getParties"})
    public Contact getContactInfo() {
        Collection<AbstractParty> parties = this.getParties();
        if (parties != null) {
            for (AbstractParty party : parties) {
                Collection<Contact> contacts = party.getContactInfo();
                if (contacts == null) continue;
                for (Contact contact : contacts) {
                    if (contact == null) continue;
                    return contact;
                }
            }
        }
        return null;
    }

    @Deprecated
    public void setContactInfo(Contact newValue) {
        this.checkWritePermission(MetadataUtilities.valueIfDefined(super.getParties()));
        Iterator<AbstractParty> it = this.getParties().iterator();
        if (it.hasNext()) {
            AbstractParty party = it.next();
            party.setContactInfo(newValue != null ? Collections.singleton(newValue) : null);
            if (party.isEmpty()) {
                it.remove();
            }
            return;
        }
        if (newValue != null) {
            this.getParties().add(new DefaultIndividual(null, null, newValue));
        }
    }

    @Override
    @XmlElement(name="role", required=true)
    public Role getRole() {
        return super.getRole();
    }

    @Override
    public void setRole(Role newValue) {
        super.setRole(newValue);
    }
}

