/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.citation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.internal.geoapi.evolution.UnsupportedCodeList;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.internal.jaxb.gco.InternationalStringAdapter;
import org.apache.sis.internal.metadata.Dependencies;
import org.apache.sis.internal.metadata.legacy.LegacyPropertyAdapter;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.citation.DefaultTelephone;
import org.apache.sis.util.resources.Messages;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.Address;
import org.opengis.metadata.citation.Contact;
import org.opengis.metadata.citation.OnlineResource;
import org.opengis.metadata.citation.Telephone;
import org.opengis.util.CodeList;
import org.opengis.util.InternationalString;

@XmlType(name="CI_Contact_Type", propOrder={"phone", "phoneList", "address", "addressList", "onlineResource", "onlineResourceList", "hoursOfService", "contactInstructions", "contactType"})
@XmlRootElement(name="CI_Contact")
public class DefaultContact
extends ISOMetadata
implements Contact {
    private static final long serialVersionUID = -969735574940462381L;
    private Collection<Telephone> phones;
    private Collection<Address> addresses;
    private Collection<OnlineResource> onlineResources;
    private InternationalString hoursOfService;
    private InternationalString contactInstructions;
    private InternationalString contactType;

    public DefaultContact() {
    }

    public DefaultContact(OnlineResource resource) {
        this.onlineResources = this.singleton(resource, OnlineResource.class);
    }

    public DefaultContact(Contact object) {
        super(object);
        if (object != null) {
            this.hoursOfService = object.getHoursOfService();
            this.contactInstructions = object.getContactInstructions();
            if (object instanceof DefaultContact) {
                DefaultContact c = (DefaultContact)object;
                this.phones = this.copyCollection(c.getPhones(), Telephone.class);
                this.addresses = this.copyCollection(c.getAddresses(), Address.class);
                this.onlineResources = this.copyCollection(c.getOnlineResources(), OnlineResource.class);
                this.contactType = c.getContactType();
            } else {
                this.phones = this.singleton(object.getPhone(), Telephone.class);
                this.addresses = this.singleton(object.getAddress(), Address.class);
                this.onlineResources = this.singleton(object.getOnlineResource(), OnlineResource.class);
            }
        }
    }

    public static DefaultContact castOrCopy(Contact object) {
        if (object == null || object instanceof DefaultContact) {
            return (DefaultContact)object;
        }
        return new DefaultContact(object);
    }

    @UML(identifier="phone", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Telephone> getPhones() {
        this.phones = this.nonNullCollection(this.phones, Telephone.class);
        return this.phones;
    }

    public void setPhones(Collection<? extends Telephone> newValues) {
        this.phones = this.writeCollection(newValues, this.phones, Telephone.class);
        if (this.phones != null) {
            boolean modified = false;
            Telephone[] p = this.phones.toArray(new Telephone[newValues.size()]);
            for (int i = 0; i < p.length; ++i) {
                Telephone phone = p[i];
                if (!(phone instanceof DefaultTelephone)) continue;
                p[i] = ((DefaultTelephone)phone).setOwner(this.phones);
                modified |= p[i] != phone;
            }
            if (modified) {
                this.phones.clear();
                this.phones.addAll(Arrays.asList(p));
            }
        }
    }

    @Deprecated
    @Dependencies(value={"getPhones"})
    @XmlElement(name="phone", namespace="http://www.isotc211.org/2005/gmd")
    public Telephone getPhone() {
        Collection<Telephone> phones;
        Telephone phone = null;
        if (FilterByVersion.LEGACY_METADATA.accept() && (phones = this.getPhones()) != null) {
            CodeList<?> ignored = null;
            for (Telephone c : phones) {
                String name;
                if (!(c instanceof DefaultTelephone)) continue;
                CodeList<?> type = ((DefaultTelephone)c).numberType;
                if (type != null && ("VOICE".equals(name = type.name()) || "FACSIMILE".equals(name))) {
                    if (phone != null) continue;
                    phone = c;
                    continue;
                }
                if (ignored != null) continue;
                ignored = type;
            }
            if (ignored != null) {
                Context.warningOccured(Context.current(), DefaultContact.class, "getPhone", Messages.class, (short)21, ignored);
            }
        }
        return phone;
    }

    @Deprecated
    public void setPhone(Telephone newValue) {
        Collection<Telephone> newValues = null;
        if (newValue != null) {
            if (newValue instanceof DefaultTelephone) {
                newValues = ((DefaultTelephone)newValue).getOwner();
            } else {
                newValues = new ArrayList<Telephone>(4);
                for (String number : newValue.getVoices()) {
                    newValues.add(new DefaultTelephone(number, UnsupportedCodeList.VOICE));
                }
                for (String number : newValue.getFacsimiles()) {
                    newValues.add(new DefaultTelephone(number, UnsupportedCodeList.FACSIMILE));
                }
            }
        }
        this.setPhones(newValues);
    }

    @UML(identifier="address", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Address> getAddresses() {
        this.addresses = this.nonNullCollection(this.addresses, Address.class);
        return this.addresses;
    }

    public void setAddresses(Collection<? extends Address> newValues) {
        this.addresses = this.writeCollection(newValues, this.addresses, Address.class);
    }

    @Deprecated
    @Dependencies(value={"getAddresses"})
    @XmlElement(name="address", namespace="http://www.isotc211.org/2005/gmd")
    public Address getAddress() {
        if (FilterByVersion.LEGACY_METADATA.accept()) {
            return LegacyPropertyAdapter.getSingleton(this.getAddresses(), Address.class, null, DefaultContact.class, "getAddress");
        }
        return null;
    }

    @Deprecated
    public void setAddress(Address newValue) {
        this.setAddresses(CollectionsExt.singletonOrEmpty(newValue));
    }

    @UML(identifier="onlineResource", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<OnlineResource> getOnlineResources() {
        this.onlineResources = this.nonNullCollection(this.onlineResources, OnlineResource.class);
        return this.onlineResources;
    }

    public void setOnlineResources(Collection<? extends OnlineResource> newValues) {
        this.onlineResources = this.writeCollection(newValues, this.onlineResources, OnlineResource.class);
    }

    @Deprecated
    @Dependencies(value={"getOnlineResources"})
    @XmlElement(name="onlineResource", namespace="http://www.isotc211.org/2005/gmd")
    public OnlineResource getOnlineResource() {
        if (FilterByVersion.LEGACY_METADATA.accept()) {
            return LegacyPropertyAdapter.getSingleton(this.getOnlineResources(), OnlineResource.class, null, DefaultContact.class, "getOnlineResource");
        }
        return null;
    }

    @Deprecated
    public void setOnlineResource(OnlineResource newValue) {
        this.setOnlineResources(CollectionsExt.singletonOrEmpty(newValue));
    }

    @XmlElement(name="hoursOfService")
    public InternationalString getHoursOfService() {
        return this.hoursOfService;
    }

    public void setHoursOfService(InternationalString newValue) {
        this.checkWritePermission();
        this.hoursOfService = newValue;
    }

    @XmlElement(name="contactInstructions")
    public InternationalString getContactInstructions() {
        return this.contactInstructions;
    }

    public void setContactInstructions(InternationalString newValue) {
        this.checkWritePermission(this.contactInstructions);
        this.contactInstructions = newValue;
    }

    @XmlElement(name="contactType")
    @XmlJavaTypeAdapter(value=InternationalStringAdapter.Since2014.class)
    @UML(identifier="contactType", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public InternationalString getContactType() {
        return this.contactType;
    }

    public void setContactType(InternationalString newValue) {
        this.checkWritePermission(this.contactType);
        this.contactType = newValue;
    }

    @XmlElement(name="phone")
    private Collection<Telephone> getPhoneList() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getPhones() : null;
    }

    @XmlElement(name="address")
    private Collection<Address> getAddressList() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getAddresses() : null;
    }

    @XmlElement(name="onlineResource")
    private Collection<OnlineResource> getOnlineResourceList() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getOnlineResources() : null;
    }
}

