/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.citation;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.sis.internal.jaxb.NonMarshalledAuthority;
import org.apache.sis.internal.metadata.Identifiers;
import org.apache.sis.internal.simple.CitationConstant;
import org.apache.sis.internal.simple.SimpleCitation;
import org.apache.sis.internal.system.SystemListener;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.apache.sis.util.Static;
import org.apache.sis.xml.IdentifierSpace;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.InternationalString;

public final class Citations
extends Static {
    public static final List<Citation> ISO_19115 = UnmodifiableArrayList.wrap(new CitationConstant[]{new CitationConstant("ISO 19115-1"), new CitationConstant("ISO 19115-2")});
    static final CitationConstant IOGP = new CitationConstant("IOGP");
    public static final IdentifierSpace<Integer> EPSG = new CitationConstant.Authority<Integer>("EPSG");
    public static final IdentifierSpace<Integer> WMS = new CitationConstant.Authority<Integer>("WMS", "OGC");
    public static final IdentifierSpace<String> OGC = new CitationConstant.Authority<String>("OGC");
    public static final IdentifierSpace<String> ESRI = new CitationConstant.Authority<String>("ArcGIS", "ESRI");
    public static final IdentifierSpace<String> NETCDF = new CitationConstant.Authority<String>("NetCDF");
    public static final IdentifierSpace<Integer> GEOTIFF = new CitationConstant.Authority<Integer>("GeoTIFF");
    public static final IdentifierSpace<String> PROJ4 = new CitationConstant.Authority<String>("Proj4");
    public static final IdentifierSpace<Integer> MAP_INFO = new CitationConstant.Authority<Integer>("MapInfo");
    public static final IdentifierSpace<Integer> S57 = new CitationConstant.Authority<Integer>("IHO S-57", "S57");
    public static final IdentifierSpace<String> ISBN = new NonMarshalledAuthority<String>("ISBN", 5);
    public static final IdentifierSpace<String> ISSN = new NonMarshalledAuthority<String>("ISSN", 4);
    public static final Citation SIS = new CitationConstant.Authority("SIS");
    private static final CitationConstant[] CITATIONS = new CitationConstant[]{(CitationConstant)((Object)EPSG), (CitationConstant)((Object)OGC), (CitationConstant)((Object)WMS), (CitationConstant)((Object)ESRI), (CitationConstant)((Object)NETCDF), (CitationConstant)((Object)GEOTIFF), (CitationConstant)((Object)PROJ4), (CitationConstant)((Object)MAP_INFO), (CitationConstant)((Object)S57), (CitationConstant)((Object)ISBN), (CitationConstant)((Object)ISSN), (CitationConstant)SIS, (CitationConstant)ISO_19115.get(0), (CitationConstant)ISO_19115.get(1)};

    private Citations() {
    }

    static void refresh() {
        for (CitationConstant citation : CITATIONS) {
            citation.refresh();
        }
        IOGP.refresh();
    }

    public static Citation[] values() {
        return (Citation[])Arrays.copyOf(CITATIONS, CITATIONS.length, Citation[].class);
    }

    public static Citation fromName(String identifier) {
        if (identifier == null || (identifier = CharSequences.trimWhitespaces(identifier)).isEmpty()) {
            return null;
        }
        for (CitationConstant citation : CITATIONS) {
            if (!Citations.equalsFiltered(identifier, citation.namespace)) continue;
            return citation;
        }
        if (Citations.equalsFiltered(identifier, "CRS") || Citations.equalsFiltered(identifier, "WMS")) {
            return WMS;
        }
        if (Citations.equalsFiltered(identifier, "IOGP") || Citations.equalsFiltered(identifier, "OGP")) {
            return IOGP;
        }
        return new SimpleCitation(identifier);
    }

    private static boolean equalsFiltered(CharSequence s1, CharSequence s2) {
        return CharSequences.equalsFiltered(s1, s2, Characters.Filter.LETTERS_AND_DIGITS, true);
    }

    public static boolean titleMatches(Citation c1, Citation c2) {
        if (c1 != null && c2 != null) {
            if (c1 == c2) {
                return true;
            }
            InternationalString candidate = c2.getTitle();
            Iterator iterator = null;
            while (true) {
                if (candidate != null) {
                    String unlocalized = candidate.toString(Locale.ROOT);
                    if (Citations.titleMatches(c1, unlocalized)) {
                        return true;
                    }
                    String localized = candidate.toString();
                    if (!Objects.equals(localized, unlocalized) && Citations.titleMatches(c1, localized)) {
                        return true;
                    }
                }
                if (iterator == null && (iterator = CollectionsExt.nonEmptyIterator(c2.getAlternateTitles())) == null || !iterator.hasNext()) break;
                candidate = (InternationalString)iterator.next();
            }
        }
        return false;
    }

    public static boolean titleMatches(Citation citation, String title) {
        if (citation != null && title != null) {
            InternationalString candidate = citation.getTitle();
            Iterator iterator = null;
            while (true) {
                if (candidate != null) {
                    String unlocalized = candidate.toString(Locale.ROOT);
                    if (Citations.equalsFiltered(unlocalized, title)) {
                        return true;
                    }
                    String localized = candidate.toString();
                    if (!Objects.equals(localized, unlocalized) && Citations.equalsFiltered(localized, title)) {
                        return true;
                    }
                }
                if (iterator == null && (iterator = CollectionsExt.nonEmptyIterator(citation.getAlternateTitles())) == null || !iterator.hasNext()) break;
                candidate = (InternationalString)iterator.next();
            }
        }
        return false;
    }

    public static boolean identifierMatches(Citation c1, Citation c2) {
        if (c1 != null && c2 != null) {
            if (c1 == c2) {
                return true;
            }
            if (c1 instanceof CitationConstant && c2 instanceof CitationConstant) {
                return c1.equals(c2);
            }
            Iterator iterator = CollectionsExt.nonEmptyIterator(c2.getIdentifiers());
            if (iterator == null) {
                iterator = CollectionsExt.nonEmptyIterator(c1.getIdentifiers());
                if (iterator == null) {
                    return Citations.titleMatches(c1, c2);
                }
                c1 = c2;
            }
            do {
                Identifier id;
                if ((id = (Identifier)iterator.next()) == null || !Citations.identifierMatches(c1, id, id.getCode())) continue;
                return true;
            } while (iterator.hasNext());
        }
        return false;
    }

    public static boolean identifierMatches(Citation citation, String identifier) {
        return Citations.identifierMatches(citation, null, identifier);
    }

    static boolean identifierMatches(Citation citation, Identifier identifier, String code) {
        if (citation != null && code != null) {
            Collection citIds = citation.getIdentifiers();
            Iterator it = CollectionsExt.nonEmptyIterator(citIds);
            if (it == null) {
                return Citations.titleMatches(citation, code);
            }
            while (it.hasNext()) {
                String cs;
                String codeSpace;
                Identifier citId = (Identifier)it.next();
                if (citId == null || !Citations.equalsFiltered(code, citId.getCode()) || identifier instanceof ReferenceIdentifier && (codeSpace = ((ReferenceIdentifier)identifier).getCodeSpace()) != null && citId instanceof ReferenceIdentifier && (cs = ((ReferenceIdentifier)citId).getCodeSpace()) != null && !Citations.equalsFiltered(codeSpace, cs)) continue;
                return true;
            }
            if (identifier == null) {
                int s = 0;
                int length = code.length();
                while ((s = CharSequences.indexOf((CharSequence)code, 58, s, length)) >= 0) {
                    CharSequence codeSpace = code.subSequence(0, s);
                    CharSequence localPart = code.subSequence(++s, length);
                    for (Identifier id : citIds) {
                        String cs = id instanceof ReferenceIdentifier ? ((ReferenceIdentifier)id).getCodeSpace() : null;
                        if (!Citations.equalsFiltered(codeSpace, cs) || !Citations.equalsFiltered(localPart, id.getCode())) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static String getIdentifier(Citation citation) {
        return Identifiers.getIdentifier(citation, false);
    }

    @Deprecated
    public static String getUnicodeIdentifier(Citation citation) {
        return Citations.removeIgnorableCharacters(Identifiers.getIdentifier(citation, true));
    }

    public static String toCodeSpace(Citation citation) {
        if (citation instanceof IdentifierSpace) {
            return ((IdentifierSpace)citation).getName();
        }
        return Citations.removeIgnorableCharacters(Identifiers.getIdentifier(citation, true));
    }

    @Deprecated
    public static String getCodeSpace(Citation citation) {
        return Citations.toCodeSpace(citation);
    }

    private static String removeIgnorableCharacters(String identifier) {
        if (identifier != null) {
            int n;
            int length = identifier.length();
            for (int i = 0; i < length; i += n) {
                int c = identifier.codePointAt(i);
                n = Character.charCount(c);
                if (!Character.isIdentifierIgnorable(c)) continue;
                StringBuilder buffer = new StringBuilder(length - n).append(identifier, 0, i);
                while ((i += n) < length) {
                    c = identifier.codePointAt(i);
                    n = Character.charCount(c);
                    if (Character.isIdentifierIgnorable(c)) continue;
                    buffer.appendCodePoint(c);
                }
                return buffer.toString();
            }
        }
        return identifier;
    }

    static {
        SystemListener.add(new SystemListener("org.apache.sis.metadata"){

            @Override
            protected void classpathChanged() {
                Citations.refresh();
            }

            @Override
            protected void databaseChanged() {
                Citations.refresh();
            }
        });
    }
}

