/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.acquisition;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.acquisition.Event;
import org.opengis.metadata.acquisition.Objective;
import org.opengis.metadata.acquisition.Operation;
import org.opengis.metadata.acquisition.OperationType;
import org.opengis.metadata.acquisition.Plan;
import org.opengis.metadata.acquisition.Platform;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.identification.Progress;
import org.opengis.util.InternationalString;

@XmlType(name="MI_Operation_Type", propOrder={"description", "citation", "identifier", "status", "type", "childOperations", "objectives", "parentOperation", "plan", "platforms", "significantEvents"})
@XmlRootElement(name="MI_Operation")
public class DefaultOperation
extends ISOMetadata
implements Operation {
    private static final long serialVersionUID = 4828650802232651791L;
    private InternationalString description;
    private Citation citation;
    private Progress status;
    private OperationType type;
    private Collection<Operation> childOperations;
    private Collection<Objective> objectives;
    private Operation parentOperation;
    private Plan plan;
    private Collection<Platform> platforms;
    private Collection<Event> significantEvents;

    public DefaultOperation() {
    }

    public DefaultOperation(Operation object) {
        super(object);
        if (object != null) {
            this.description = object.getDescription();
            this.citation = object.getCitation();
            this.identifiers = this.singleton(object.getIdentifier(), Identifier.class);
            this.status = object.getStatus();
            this.type = object.getType();
            this.childOperations = this.copyCollection(object.getChildOperations(), Operation.class);
            this.objectives = this.copyCollection(object.getObjectives(), Objective.class);
            this.parentOperation = object.getParentOperation();
            this.plan = object.getPlan();
            this.platforms = this.copyCollection(object.getPlatforms(), Platform.class);
            this.significantEvents = this.copyCollection(object.getSignificantEvents(), Event.class);
        }
    }

    public static DefaultOperation castOrCopy(Operation object) {
        if (object == null || object instanceof DefaultOperation) {
            return (DefaultOperation)object;
        }
        return new DefaultOperation(object);
    }

    @XmlElement(name="description")
    public InternationalString getDescription() {
        return this.description;
    }

    public void setDescription(InternationalString newValue) {
        this.checkWritePermission(this.description);
        this.description = newValue;
    }

    @XmlElement(name="citation")
    public Citation getCitation() {
        return this.citation;
    }

    public void setCitation(Citation newValue) {
        this.checkWritePermission(this.citation);
        this.citation = newValue;
    }

    @Override
    @XmlElement(name="identifier")
    public Identifier getIdentifier() {
        return super.getIdentifier();
    }

    @Override
    public void setIdentifier(Identifier newValue) {
        super.setIdentifier(newValue);
    }

    @XmlElement(name="status", required=true)
    public Progress getStatus() {
        return this.status;
    }

    public void setStatus(Progress newValue) {
        this.checkWritePermission(this.status);
        this.status = newValue;
    }

    @XmlElement(name="type")
    public OperationType getType() {
        return this.type;
    }

    public void setType(OperationType newValue) {
        this.checkWritePermission(this.type);
        this.type = newValue;
    }

    @XmlElement(name="childOperation")
    public Collection<Operation> getChildOperations() {
        this.childOperations = this.nonNullCollection(this.childOperations, Operation.class);
        return this.childOperations;
    }

    public void setChildOperations(Collection<? extends Operation> newValues) {
        this.childOperations = this.writeCollection(newValues, this.childOperations, Operation.class);
    }

    @XmlElement(name="objective")
    public Collection<Objective> getObjectives() {
        this.objectives = this.nonNullCollection(this.objectives, Objective.class);
        return this.objectives;
    }

    public void setObjectives(Collection<? extends Objective> newValues) {
        this.objectives = this.writeCollection(newValues, this.objectives, Objective.class);
    }

    @XmlElement(name="parentOperation")
    public Operation getParentOperation() {
        return this.parentOperation;
    }

    public void setParentOperation(Operation newValue) {
        this.checkWritePermission(this.parentOperation);
        this.parentOperation = newValue;
    }

    @XmlElement(name="plan")
    public Plan getPlan() {
        return this.plan;
    }

    public void setPlan(Plan newValue) {
        this.checkWritePermission(this.plan);
        this.plan = newValue;
    }

    @XmlElement(name="platform")
    public Collection<Platform> getPlatforms() {
        this.platforms = this.nonNullCollection(this.platforms, Platform.class);
        return this.platforms;
    }

    public void setPlatforms(Collection<? extends Platform> newValues) {
        this.platforms = this.writeCollection(newValues, this.platforms, Platform.class);
    }

    @XmlElement(name="significantEvent")
    public Collection<Event> getSignificantEvents() {
        this.significantEvents = this.nonNullCollection(this.significantEvents, Event.class);
        return this.significantEvents;
    }

    public void setSignificantEvents(Collection<? extends Event> newValues) {
        this.significantEvents = this.writeCollection(newValues, this.significantEvents, Event.class);
    }
}

